/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.gen;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.gen.DelegateSupport;
import com.amazon.carbonado.gen.MasterFeature;
import com.amazon.carbonado.gen.MasterStorableGenerator;
import com.amazon.carbonado.gen.MasterSupport;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.util.SoftValuedCache;
import java.util.EnumSet;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.KeyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateStorableGenerator<S extends Storable> {
    private static final SoftValuedCache<Object, Class> cCache = SoftValuedCache.newCache(11);
    private final Class<S> mStorableType;
    private final ClassInjector mClassInjector;
    private final ClassFile mClassFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> Class<? extends S> getDelegateClass(Class<S> type, EnumSet<MasterFeature> features) throws SupportException {
        if (features == null) {
            features = EnumSet.noneOf(MasterFeature.class);
        }
        Object key = KeyFactory.createKey((Object[])new Object[]{type, features});
        SoftValuedCache<Object, Class> softValuedCache = cCache;
        synchronized (softValuedCache) {
            Class<S> generatedClass = cCache.get(key);
            if (generatedClass != null) {
                return generatedClass;
            }
            generatedClass = super.generateAndInjectClass();
            cCache.put(key, generatedClass);
            return generatedClass;
        }
    }

    private DelegateStorableGenerator(Class<S> type, EnumSet<MasterFeature> features) throws SupportException {
        this.mStorableType = type;
        Class<S> abstractClass = MasterStorableGenerator.getAbstractClass(this.mStorableType, features);
        this.mClassInjector = ClassInjector.create((String)this.mStorableType.getName(), (ClassLoader)abstractClass.getClassLoader());
        this.mClassFile = new ClassFile(this.mClassInjector.getClassName(), abstractClass);
        this.mClassFile.markSynthetic();
        this.mClassFile.setSourceFile(DelegateStorableGenerator.class.getName());
        this.mClassFile.setTarget("1.5");
    }

    private Class<? extends S> generateAndInjectClass() {
        TypeDesc masterSupportType = TypeDesc.forClass(MasterSupport.class);
        TypeDesc delegateSupportType = TypeDesc.forClass(DelegateSupport.class);
        TypeDesc[] params = new TypeDesc[]{delegateSupportType};
        MethodInfo mi = this.mClassFile.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.invokeSuperConstructor(new TypeDesc[]{masterSupportType});
        b.returnVoid();
        CodeBuilderUtil.definePrepareMethod(this.mClassFile, this.mStorableType, delegateSupportType);
        this.generateDelegatedMethod("doTryLoad$", "doTryLoad");
        this.generateDelegatedMethod("doTryInsert$master", "doTryInsert");
        this.generateDelegatedMethod("doTryUpdate$master", "doTryUpdate");
        this.generateDelegatedMethod("doTryDelete$master", "doTryDelete");
        Class generatedClass = this.mClassInjector.defineClass(this.mClassFile);
        return generatedClass;
    }

    private void generateDelegatedMethod(String masterMethodName, String supportMethodName) {
        TypeDesc triggerSupportType = TypeDesc.forClass(TriggerSupport.class);
        TypeDesc delegateSupportType = TypeDesc.forClass(DelegateSupport.class);
        TypeDesc[] storableParam = new TypeDesc[]{TypeDesc.forClass(Storable.class)};
        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PROTECTED, masterMethodName, TypeDesc.BOOLEAN, null);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.checkCast(delegateSupportType);
        b.loadThis();
        b.invokeInterface(delegateSupportType, supportMethodName, TypeDesc.BOOLEAN, storableParam);
        b.returnValue(TypeDesc.BOOLEAN);
    }
}

