/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.BinaryOpFilter;
import com.amazon.carbonado.filter.Distributer;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrFilter<S extends Storable>
extends BinaryOpFilter<S> {
    private static final long serialVersionUID = 1L;

    static <S extends Storable> OrFilter<S> getCanonical(Filter<S> left, Filter<S> right) {
        return (OrFilter)cCanonical.put(new OrFilter<S>(left, right));
    }

    private OrFilter(Filter<S> left, Filter<S> right) {
        super(left, right);
    }

    @Override
    public Filter<S> not() {
        return this.mLeft.not().and(this.mRight.not());
    }

    @Override
    public <R, P> R accept(Visitor<S, R, P> visitor, P param) {
        return visitor.visit(this, param);
    }

    @Override
    public Filter<S> unbind() {
        if (!this.isBound()) {
            return this;
        }
        return this.mLeft.unbind().or(this.mRight.unbind());
    }

    @Override
    public <T extends Storable> Filter<T> asJoinedFromAny(ChainedProperty<T> joinProperty) {
        return this.mLeft.asJoinedFromAny(joinProperty).or(this.mRight.asJoinedFromAny(joinProperty));
    }

    @Override
    Filter.NotJoined notJoinedFromCNF(ChainedProperty<S> joinProperty) {
        Filter.NotJoined left = this.mLeft.notJoinedFromCNF(joinProperty);
        Filter.NotJoined right = this.mRight.notJoinedFromCNF(joinProperty);
        if (!this.isConjunctiveNormalForm()) {
            throw new IllegalStateException();
        }
        if (!left.getRemainderFilter().isOpen() || !right.getRemainderFilter().isOpen()) {
            return super.notJoinedFromCNF(joinProperty);
        }
        Filter<?> leftNotJoined = left.getNotJoinedFilter();
        Filter<?> rightNotJoined = right.getNotJoinedFilter();
        return new Filter.NotJoined(leftNotJoined.or(rightNotJoined), OrFilter.getOpenFilter(this.getStorableType()));
    }

    @Override
    Filter<S> buildDisjunctiveNormalForm() {
        return this.mLeft.dnf().or(this.mRight.dnf()).reduce();
    }

    @Override
    Filter<S> buildConjunctiveNormalForm() {
        Filter left = this.mLeft.reduce().cnf();
        Filter right = this.mRight.reduce().cnf();
        if (left instanceof AndFilter) {
            return ((Filter)left.accept(new Distributer(true, false), right)).reduce().cnf();
        }
        if (right instanceof AndFilter) {
            return ((Filter)right.accept(new Distributer(false, false), left)).reduce().cnf();
        }
        return left.or(right).reduce();
    }

    @Override
    boolean checkIsDisjunctiveNormalForm() {
        return this.mLeft.isDisjunctiveNormalForm() && this.mRight.isDisjunctiveNormalForm();
    }

    @Override
    boolean checkIsConjunctiveNormalForm() {
        return !(this.mLeft instanceof AndFilter) && !(this.mRight instanceof AndFilter) && this.mLeft.isConjunctiveNormalForm() && this.mRight.isConjunctiveNormalForm();
    }

    @Override
    int generateHashCode() {
        return this.mLeft.hashCode() * 31 + this.mRight.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OrFilter) {
            OrFilter other = (OrFilter)obj;
            return this.getStorableType() == other.getStorableType() && this.mLeft.equals(other.mLeft) && this.mRight.equals(other.mRight);
        }
        return false;
    }

    @Override
    public void appendTo(Appendable app, FilterValues<S> values) throws IOException {
        if (this.mLeft instanceof AndFilter) {
            app.append('(');
            this.mLeft.appendTo(app, values);
            app.append(')');
        } else {
            this.mLeft.appendTo(app, values);
        }
        app.append(" | ");
        if (this.mRight instanceof AndFilter) {
            app.append('(');
            this.mRight.appendTo(app, values);
            app.append(')');
        } else {
            this.mRight.appendTo(app, values);
        }
    }
}

