/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Group<S extends Storable> {
    final boolean mForAnd;
    Set<Filter<S>> mElements;

    Group(boolean forAnd) {
        this.mForAnd = forAnd;
    }

    boolean add(Filter<S> element) {
        if (this.mElements == null) {
            this.mElements = new LinkedHashSet<Filter<S>>(20);
        }
        return this.mElements.add(element);
    }

    void reduce() {
        Scanner scanner = this.mForAnd ? OrChildScanner.THE : AndChildScanner.THE;
        Iterator<Filter<S>> it = this.mElements.iterator();
        block0: while (it.hasNext()) {
            Filter<S> a = it.next();
            for (Filter<S> b : this.mElements) {
                if (a == b || !((Boolean)a.accept(scanner, b)).booleanValue()) continue;
                it.remove();
                continue block0;
            }
        }
    }

    Filter<S> merge() {
        Filter<S> filter = null;
        if (this.mElements != null) {
            for (Filter<S> element : this.mElements) {
                if (filter == null) {
                    filter = element;
                    continue;
                }
                if (this.mForAnd) {
                    filter = filter.and(element);
                    continue;
                }
                filter = filter.or(element);
            }
        }
        return filter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndParentScanner<S extends Storable>
    extends Scanner<S> {
        static final AndParentScanner THE = new AndParentScanner();

        private AndParentScanner() {
        }

        @Override
        public Boolean visit(AndFilter<S> child, Filter<S> parent) {
            if (child == parent) {
                return true;
            }
            AndChildScanner scanner = AndChildScanner.THE;
            return (Boolean)parent.accept(scanner, child.getLeftFilter()) != false && (Boolean)parent.accept(scanner, child.getRightFilter()) != false;
        }

        @Override
        public Boolean visit(OrFilter<S> child, Filter<S> parent) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrParentScanner<S extends Storable>
    extends Scanner<S> {
        static final OrParentScanner THE = new OrParentScanner();

        private OrParentScanner() {
        }

        @Override
        public Boolean visit(AndFilter<S> child, Filter<S> parent) {
            return false;
        }

        @Override
        public Boolean visit(OrFilter<S> child, Filter<S> parent) {
            if (child == parent) {
                return true;
            }
            OrChildScanner scanner = OrChildScanner.THE;
            return (Boolean)parent.accept(scanner, child.getLeftFilter()) != false && (Boolean)parent.accept(scanner, child.getRightFilter()) != false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndChildScanner<S extends Storable>
    extends Scanner<S> {
        static final AndChildScanner THE = new AndChildScanner();

        private AndChildScanner() {
        }

        @Override
        public Boolean visit(OrFilter<S> parent, Filter<S> child) {
            return false;
        }

        @Override
        public Boolean visit(AndFilter<S> parent, Filter<S> child) {
            if (parent == child) {
                return true;
            }
            if (((Boolean)parent.getLeftFilter().accept(this, child)).booleanValue() || ((Boolean)parent.getRightFilter().accept(this, child)).booleanValue()) {
                return true;
            }
            AndParentScanner scanner = AndParentScanner.THE;
            return (Boolean)child.accept(scanner, parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrChildScanner<S extends Storable>
    extends Scanner<S> {
        static final OrChildScanner THE = new OrChildScanner();

        private OrChildScanner() {
        }

        @Override
        public Boolean visit(OrFilter<S> parent, Filter<S> child) {
            if (parent == child) {
                return true;
            }
            if (((Boolean)parent.getLeftFilter().accept(this, child)).booleanValue() || ((Boolean)parent.getRightFilter().accept(this, child)).booleanValue()) {
                return true;
            }
            OrParentScanner scanner = OrParentScanner.THE;
            return (Boolean)child.accept(scanner, parent);
        }

        @Override
        public Boolean visit(AndFilter<S> parent, Filter<S> child) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Scanner<S extends Storable>
    extends Visitor<S, Boolean, Filter<S>> {
        private Scanner() {
        }

        @Override
        public Boolean visit(PropertyFilter<S> filter, Filter<S> search) {
            return filter == search;
        }

        @Override
        public Boolean visit(ExistsFilter<S> filter, Filter<S> search) {
            return filter == search;
        }
    }
}

