/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ClosedFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.FilterParser;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.OpenFilter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.PropertyFilterList;
import com.amazon.carbonado.filter.Reducer;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.util.Appender;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cojen.util.WeakCanonicalSet;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter<S extends Storable>
implements Serializable,
Appender {
    private static final Object OPEN_KEY = new Object();
    private static final Object CLOSED_KEY = new Object();
    static WeakCanonicalSet cCanonical = new WeakCanonicalSet();
    private static Map cCache = new WeakIdentityMap();
    private final Class<S> mType;
    private transient int mHashCode;
    private volatile transient FilterValues<S> mFilterValues;
    private volatile transient PropertyFilterList<S> mTailPropertyFilterList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> Filter<S> filterFor(Class<S> type, String expression) {
        SoftValuedCache<Object, Filter<S>> filterCache;
        SoftValuedCache<Object, Filter<S>> softValuedCache = filterCache = Filter.getFilterCache(type);
        synchronized (softValuedCache) {
            Filter<S> filter = filterCache.get(expression);
            if (filter == null) {
                filter = new FilterParser<S>(type, expression).parseRoot();
                filterCache.put(expression, filter);
            }
            return filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> OpenFilter<S> getOpenFilter(Class<S> type) {
        SoftValuedCache<Object, Filter<S>> filterCache;
        SoftValuedCache<Object, Filter<S>> softValuedCache = filterCache = Filter.getFilterCache(type);
        synchronized (softValuedCache) {
            Filter<S> filter = filterCache.get(OPEN_KEY);
            if (filter == null) {
                filter = OpenFilter.getCanonical(type);
                filterCache.put(OPEN_KEY, filter);
            }
            return (OpenFilter)filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> ClosedFilter<S> getClosedFilter(Class<S> type) {
        SoftValuedCache<Object, Filter<S>> filterCache;
        SoftValuedCache<Object, Filter<S>> softValuedCache = filterCache = Filter.getFilterCache(type);
        synchronized (softValuedCache) {
            Filter<S> filter = filterCache.get(CLOSED_KEY);
            if (filter == null) {
                filter = ClosedFilter.getCanonical(type);
                filterCache.put(CLOSED_KEY, filter);
            }
            return (ClosedFilter)filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S extends Storable> SoftValuedCache<Object, Filter<S>> getFilterCache(Class<S> type) {
        Map map = cCache;
        synchronized (map) {
            SoftValuedCache<Object, Filter<S>> filterCache = (SoftValuedCache<Object, Filter<S>>)cCache.get(type);
            if (filterCache == null) {
                filterCache = SoftValuedCache.newCache(11);
                cCache.put(type, filterCache);
            }
            return filterCache;
        }
    }

    Filter(Class<S> type) {
        this.mType = type;
    }

    public Class<S> getStorableType() {
        return this.mType;
    }

    public FilterValues<S> initialFilterValues() {
        FilterValues<S> filterValues = this.mFilterValues;
        if (filterValues == null) {
            this.buildFilterValues();
            filterValues = this.mFilterValues;
        }
        return filterValues;
    }

    PropertyFilterList<S> getTailPropertyFilterList() {
        PropertyFilterList<S> tail = this.mTailPropertyFilterList;
        if (tail == null) {
            this.buildFilterValues();
            tail = this.mTailPropertyFilterList;
        }
        return tail;
    }

    private void buildFilterValues() {
        Filter<S> boundFilter = this.bind();
        if (boundFilter != this) {
            this.mFilterValues = boundFilter.initialFilterValues();
            this.mTailPropertyFilterList = boundFilter.getTailPropertyFilterList();
            return;
        }
        PropertyFilterList list = (PropertyFilterList)this.accept(new PropertyFilterList.Builder(), null);
        if (list != null) {
            this.mFilterValues = FilterValues.create(this, list);
            this.mTailPropertyFilterList = list.get(-1);
        }
    }

    public final Filter<S> and(String expression) {
        return this.and(new FilterParser<S>(this.mType, expression).parseRoot());
    }

    public Filter<S> and(Filter<S> filter) {
        if (filter.isOpen()) {
            return this;
        }
        if (filter.isClosed()) {
            return filter;
        }
        return AndFilter.getCanonical(this, filter);
    }

    public final Filter<S> and(String propertyName, RelOp operator) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.and(PropertyFilter.getCanonical(prop, operator, 0));
    }

    public final Filter<S> and(String propertyName, RelOp operator, Object constantValue) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.and(PropertyFilter.getCanonical(prop, operator, 0).constant(constantValue));
    }

    public final Filter<S> andExists(String propertyName, Filter<?> subFilter) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.and(ExistsFilter.build(prop, subFilter, false));
    }

    public final Filter<S> andNotExists(String propertyName, Filter<?> subFilter) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.and(ExistsFilter.build(prop, subFilter, true));
    }

    public final Filter<S> or(String expression) {
        return this.or(new FilterParser<S>(this.mType, expression).parseRoot());
    }

    public Filter<S> or(Filter<S> filter) {
        if (filter.isOpen()) {
            return filter;
        }
        if (filter.isClosed()) {
            return this;
        }
        return OrFilter.getCanonical(this, filter);
    }

    public final Filter<S> or(String propertyName, RelOp operator) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.or(PropertyFilter.getCanonical(prop, operator, 0));
    }

    public final Filter<S> or(String propertyName, RelOp operator, Object constantValue) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.or(PropertyFilter.getCanonical(prop, operator, 0).constant(constantValue));
    }

    public final Filter<S> orExists(String propertyName, Filter<?> subFilter) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.or(ExistsFilter.build(prop, subFilter, false));
    }

    public final Filter<S> orNotExists(String propertyName, Filter<?> subFilter) {
        ChainedProperty<S> prop = new FilterParser<S>(this.mType, propertyName).parseChainedProperty();
        return this.or(ExistsFilter.build(prop, subFilter, true));
    }

    public abstract Filter<S> not();

    public final Filter<S> disjunctiveNormalForm() {
        return this.bind().dnf();
    }

    public List<Filter<S>> disjunctiveNormalFormSplit() {
        final ArrayList list = new ArrayList();
        this.disjunctiveNormalForm().accept(new Visitor<S, Object, Object>(){

            @Override
            public Object visit(AndFilter<S> filter, Object param) {
                list.add(filter);
                return null;
            }

            @Override
            public Object visit(PropertyFilter<S> filter, Object param) {
                list.add(filter);
                return null;
            }

            @Override
            public Object visit(ExistsFilter<S> filter, Object param) {
                list.add(filter);
                return null;
            }
        }, null);
        return Collections.unmodifiableList(list);
    }

    final Filter<S> dnf() {
        Filter<S> filter = this;
        if (!filter.isDisjunctiveNormalForm()) {
            filter = filter.buildDisjunctiveNormalForm();
        }
        return filter.reduce();
    }

    public final Filter<S> conjunctiveNormalForm() {
        return this.bind().cnf();
    }

    public List<Filter<S>> conjunctiveNormalFormSplit() {
        final ArrayList list = new ArrayList();
        this.conjunctiveNormalForm().accept(new Visitor<S, Object, Object>(){

            @Override
            public Object visit(OrFilter<S> filter, Object param) {
                list.add(filter);
                return null;
            }

            @Override
            public Object visit(PropertyFilter<S> filter, Object param) {
                list.add(filter);
                return null;
            }

            @Override
            public Object visit(ExistsFilter<S> filter, Object param) {
                list.add(filter);
                return null;
            }
        }, null);
        return Collections.unmodifiableList(list);
    }

    final Filter<S> cnf() {
        Filter<S> filter = this;
        if (!filter.isConjunctiveNormalForm()) {
            filter = filter.buildConjunctiveNormalForm();
        }
        return filter.reduce();
    }

    public abstract <R, P> R accept(Visitor<S, R, P> var1, P var2);

    public abstract Filter<S> bind();

    public abstract Filter<S> unbind();

    public abstract boolean isBound();

    abstract void markBound();

    public final Filter<S> reduce() {
        return this.isReduced() ? this : (Filter)this.accept(new Reducer(), null);
    }

    public final <T extends Storable> Filter<T> asJoinedFrom(Class<T> type, String joinProperty) {
        return this.asJoinedFrom(ChainedProperty.parse(StorableIntrospector.examine(type), joinProperty));
    }

    public final <T extends Storable> Filter<T> asJoinedFrom(ChainedProperty<T> joinProperty) {
        if (joinProperty.getType() != this.getStorableType()) {
            throw new IllegalArgumentException("Property is not of type \"" + this.getStorableType().getName() + "\": " + joinProperty);
        }
        return this.asJoinedFromAny(joinProperty);
    }

    public abstract <T extends Storable> Filter<T> asJoinedFromAny(ChainedProperty<T> var1);

    public final NotJoined notJoinedFrom(String joinProperty) {
        return this.notJoinedFrom(ChainedProperty.parse(StorableIntrospector.examine(this.mType), joinProperty));
    }

    public final NotJoined notJoinedFrom(ChainedProperty<S> joinProperty) {
        if (!Storable.class.isAssignableFrom(joinProperty.getType())) {
            throw new IllegalArgumentException("Join property type is not a Storable: " + joinProperty);
        }
        return this.notJoinedFromAny(joinProperty);
    }

    final NotJoined notJoinedFromAny(ChainedProperty<S> joinProperty) {
        NotJoined nj = this.conjunctiveNormalForm().notJoinedFromCNF(joinProperty);
        if (nj.getNotJoinedFilter().isOpen() && nj.getRemainderFilter() != this) {
            nj = new NotJoined(nj.getNotJoinedFilter(), this.bind());
        }
        if (!(!this.isDisjunctiveNormalForm() || nj.getNotJoinedFilter().isDisjunctiveNormalForm() && nj.getRemainderFilter().isDisjunctiveNormalForm())) {
            nj = new NotJoined(nj.getNotJoinedFilter().disjunctiveNormalForm(), nj.getRemainderFilter().disjunctiveNormalForm());
        }
        return nj;
    }

    NotJoined notJoinedFromCNF(ChainedProperty<S> joinProperty) {
        return new NotJoined(Filter.getOpenFilter(joinProperty.getLastProperty().getJoinedType()), this);
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isClosed() {
        return false;
    }

    abstract Filter<S> buildDisjunctiveNormalForm();

    abstract Filter<S> buildConjunctiveNormalForm();

    abstract boolean isDisjunctiveNormalForm();

    abstract boolean isConjunctiveNormalForm();

    abstract boolean isReduced();

    abstract void markReduced();

    public final int hashCode() {
        int hashCode = this.mHashCode;
        if (hashCode == 0) {
            this.mHashCode = hashCode = this.generateHashCode();
        }
        return hashCode;
    }

    abstract int generateHashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            this.appendTo(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        this.appendTo(app, null);
    }

    public abstract void appendTo(Appendable var1, FilterValues<S> var2) throws IOException;

    Object readResolve() {
        return cCanonical.put((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NotJoined {
        private final Filter<?> mNotJoined;
        private final Filter<S> mRemainder;

        NotJoined(Filter<?> notJoined, Filter<S> remainder) {
            this.mNotJoined = notJoined;
            this.mRemainder = remainder;
        }

        public Filter<?> getNotJoinedFilter() {
            return this.mNotJoined;
        }

        public Filter<S> getRemainderFilter() {
            return this.mRemainder;
        }

        public int hashCode() {
            return this.mNotJoined.hashCode() * 31 + this.mRemainder.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NotJoined) {
                NotJoined other = (NotJoined)obj;
                return this.mNotJoined.equals(other.mNotJoined) && this.mRemainder.equals(other.mRemainder);
            }
            return false;
        }

        public String toString() {
            return "not joined: " + this.mNotJoined + ", remainder: " + this.mRemainder;
        }
    }
}

