/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Binder<S extends Storable>
extends Visitor<S, Filter<S>, Object> {
    private final Map<PropertyFilter<S>, PropertyFilter<S>> mBindMap;
    private boolean mNeedsRebind;

    static <S extends Storable> Filter<S> doBind(Filter<S> filter) {
        return Binder.doBind(filter, null);
    }

    private static <S extends Storable> Filter<S> doBind(Filter<S> filter, Binder<S> binder) {
        binder = new Binder<S>(binder);
        Filter boundFilter = (Filter)filter.accept(binder, null);
        if (binder.isRebindNeeded()) {
            binder = new Binder<S>(binder);
            boundFilter = (Filter)boundFilter.accept(binder, null);
        }
        return boundFilter;
    }

    private Binder(Binder<S> binder) {
        this.mBindMap = binder == null ? new IdentityHashMap<PropertyFilter<S>, PropertyFilter<S>>() : binder.mBindMap;
    }

    public boolean isRebindNeeded() {
        return this.mNeedsRebind;
    }

    @Override
    public Filter<S> visit(OrFilter<S> filter, Object param) {
        Filter left = filter.getLeftFilter();
        Filter newLeft = (Filter)left.accept(this, null);
        Filter right = filter.getRightFilter();
        Filter newRight = (Filter)right.accept(this, null);
        Filter newFilter = left != newLeft || right != newRight ? newLeft.or(newRight) : filter;
        newFilter.markBound();
        return newFilter;
    }

    @Override
    public Filter<S> visit(AndFilter<S> filter, Object param) {
        Filter left = filter.getLeftFilter();
        Filter newLeft = (Filter)left.accept(this, null);
        Filter right = filter.getRightFilter();
        Filter newRight = (Filter)right.accept(this, null);
        Filter newFilter = left != newLeft || right != newRight ? newLeft.and(newRight) : filter;
        newFilter.markBound();
        return newFilter;
    }

    @Override
    public Filter<S> visit(PropertyFilter<S> filter, Object param) {
        if (filter.isBound()) {
            if (this.mBindMap.containsKey(filter)) {
                return filter;
            }
            PropertyFilter<S> zero = PropertyFilter.getCanonical(filter, 0);
            PropertyFilter<S> highest = this.mBindMap.get(zero);
            if (highest == null) {
                this.mBindMap.put(zero, filter);
            } else {
                this.mNeedsRebind = true;
                if (filter.getBindID() > highest.getBindID()) {
                    this.mBindMap.put(zero, filter);
                }
            }
            return filter;
        }
        PropertyFilter<S> zero = filter.getBindID() == 0 ? filter : PropertyFilter.getCanonical(filter, 0);
        PropertyFilter<S> highest = this.mBindMap.get(zero);
        highest = highest == null ? PropertyFilter.getCanonical(filter, 1) : PropertyFilter.getCanonical(filter, highest.getBindID() + 1);
        this.mBindMap.put(zero, highest);
        this.mBindMap.put(highest, highest);
        return highest;
    }

    @Override
    public Filter<S> visit(ExistsFilter<S> filter, Object param) {
        if (filter.isBound()) {
            return filter;
        }
        Filter<S> boundJoinedSubFilter = Binder.doBind(filter.getJoinedSubFilter(), this);
        Filter.NotJoined nj = boundJoinedSubFilter.notJoinedFromAny(filter.getChainedProperty());
        if (nj.getRemainderFilter() != null && !nj.getRemainderFilter().isOpen()) {
            throw new IllegalStateException(nj.toString());
        }
        return ExistsFilter.build(filter.getChainedProperty(), nj.getNotJoinedFilter(), filter.isNotExists());
    }
}

