/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.cursor.MergeSortBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkFilePool {
    private static final String cTempDir = System.getProperty("java.io.tmpdir");
    private static final ConcurrentMap<String, WorkFilePool> cPools = new ConcurrentHashMap<String, WorkFilePool>();
    private final File mTempDir;
    private final List<RandomAccessFile> mWorkFilePool;
    private final Set<MergeSortBuffer<?>> mWorkFileUsers;
    private Thread mShutdownHook;

    static WorkFilePool getInstance(String tempDir) {
        String canonical;
        WorkFilePool pool;
        if (tempDir == null) {
            tempDir = cTempDir;
        }
        if ((pool = (WorkFilePool)cPools.get(tempDir)) != null) {
            return pool;
        }
        try {
            canonical = new File(tempDir).getCanonicalPath();
        }
        catch (IOException e) {
            canonical = new File(tempDir).getAbsolutePath();
        }
        if (!canonical.equals(tempDir)) {
            pool = WorkFilePool.getInstance(canonical);
            cPools.putIfAbsent(tempDir, pool);
            return pool;
        }
        pool = new WorkFilePool(new File(tempDir));
        WorkFilePool existing = cPools.putIfAbsent(tempDir, pool);
        if (existing == null) {
            pool.addShutdownHook(tempDir);
        } else {
            pool = existing;
        }
        return pool;
    }

    private WorkFilePool(File tempDir) {
        this.mTempDir = tempDir;
        this.mWorkFilePool = new ArrayList<RandomAccessFile>();
        this.mWorkFileUsers = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RandomAccessFile acquireWorkFile(MergeSortBuffer<?> buffer) throws IOException {
        Collection<Object> collection = this.mWorkFileUsers;
        synchronized (collection) {
            this.mWorkFileUsers.add(buffer);
        }
        collection = this.mWorkFilePool;
        synchronized (collection) {
            if (this.mWorkFilePool.size() > 0) {
                return this.mWorkFilePool.remove(this.mWorkFilePool.size() - 1);
            }
        }
        File file = File.createTempFile("carbonado-mergesort-", null, this.mTempDir);
        file.deleteOnExit();
        return new RandomAccessFile(file, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseWorkFiles(List<RandomAccessFile> files) {
        List<RandomAccessFile> list = this.mWorkFilePool;
        synchronized (list) {
            for (RandomAccessFile raf : files) {
                try {
                    raf.seek(0L);
                    raf.setLength(0L);
                    this.mWorkFilePool.add(raf);
                }
                catch (IOException e) {
                    try {
                        raf.close();
                    }
                    catch (IOException e2) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterWorkFileUser(MergeSortBuffer<?> buffer) {
        Set<MergeSortBuffer<?>> set = this.mWorkFileUsers;
        synchronized (set) {
            this.mWorkFileUsers.remove(buffer);
            this.mWorkFileUsers.notify();
        }
    }

    private synchronized void addShutdownHook(String tempDir) {
        if (this.mShutdownHook != null) {
            return;
        }
        String threadName = "MergeSortBuffer shutdown (" + tempDir + ')';
        this.mShutdownHook = new Thread(threadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Collection collection = WorkFilePool.this.mWorkFileUsers;
                synchronized (collection) {
                    for (MergeSortBuffer buffer : WorkFilePool.this.mWorkFileUsers) {
                        buffer.stop();
                    }
                    long timeout = 10000L;
                    long giveup = System.currentTimeMillis() + 10000L;
                    try {
                        long now;
                        while (WorkFilePool.this.mWorkFileUsers.size() > 0 && (now = System.currentTimeMillis()) < giveup) {
                            WorkFilePool.this.mWorkFileUsers.wait(giveup - now);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                collection = WorkFilePool.this.mWorkFilePool;
                synchronized (collection) {
                    for (RandomAccessFile raf : WorkFilePool.this.mWorkFilePool) {
                        try {
                            raf.close();
                        }
                        catch (IOException e) {}
                    }
                    WorkFilePool.this.mWorkFilePool.clear();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.mShutdownHook);
    }
}

