/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.constraint;

import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.constraint.ConstraintDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@ConstraintDefinition
public @interface FloatConstraint {
    public double[] allowed() default {};

    public double[] disallowed() default {};

    public double min() default -Infinity;

    public double max() default Infinity;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constraint {
        private final String mPropertyName;
        private final double mMinValue;
        private final double mMaxValue;
        private final double[] mDisallowed;
        private final double[] mAllowed;

        public Constraint(Class<?> type, String propertyName, FloatConstraint ann) {
            this(type, propertyName, ann.min(), ann.max(), ann.allowed(), ann.disallowed());
        }

        public Constraint(Class<?> type, String propertyName, double min, double max, double[] allowed, double[] disallowed) {
            this.mPropertyName = propertyName;
            this.mMinValue = min;
            this.mMaxValue = max;
            if (this.mMaxValue < this.mMinValue) {
                throw new MalformedTypeException(type, "Illegal range for float constraint on property \"" + propertyName + "\": " + this.rangeString());
            }
            if (disallowed == null || disallowed.length == 0) {
                disallowed = null;
            } else {
                disallowed = (double[])disallowed.clone();
                Arrays.sort(disallowed);
            }
            if (allowed == null || allowed.length == 0) {
                allowed = null;
            } else {
                allowed = (double[])allowed.clone();
                Arrays.sort(allowed);
                for (double value : allowed) {
                    if (!(value < this.mMinValue) && !(value > this.mMaxValue) && (disallowed == null || Arrays.binarySearch(disallowed, value) < 0)) continue;
                    throw new MalformedTypeException(type, "Allowed value contradiction for float constraint on property \"" + propertyName + "\": " + value);
                }
                disallowed = null;
            }
            this.mDisallowed = disallowed;
            this.mAllowed = allowed;
        }

        public void constrain(double propertyValue) {
            if (propertyValue < this.mMinValue || propertyValue > this.mMaxValue) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" must be in range " + this.rangeString() + ": " + propertyValue);
            }
            if (this.mDisallowed != null && Arrays.binarySearch(this.mDisallowed, propertyValue) >= 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is disallowed: " + propertyValue);
            }
            if (this.mAllowed != null && Arrays.binarySearch(this.mAllowed, propertyValue) < 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not allowed: " + propertyValue);
            }
        }

        public void constrain(CharSequence propertyValue) {
            if (propertyValue != null) {
                try {
                    this.constrain(Double.parseDouble(((Object)propertyValue).toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not a number: " + propertyValue);
                }
            }
        }

        public void constrain(char propertyValue) {
            if ('0' > propertyValue || propertyValue > '9') {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not a number: " + propertyValue);
            }
            this.constrain(propertyValue - 48);
        }

        public void constrain(char[] propertyValue) {
            if (propertyValue != null) {
                this.constrain(new String(propertyValue));
            }
        }

        private String rangeString() {
            StringBuilder b = new StringBuilder();
            b.append('(');
            if (this.mMinValue > Double.MIN_VALUE) {
                b.append(this.mMinValue);
            }
            b.append("..");
            if (this.mMaxValue < Double.MAX_VALUE) {
                b.append(this.mMaxValue);
            }
            b.append(')');
            return b.toString();
        }
    }
}

