/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.adapter;

import com.amazon.carbonado.adapter.AdapterDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@AdapterDefinition(storageTypePreferences={char.class, Character.class, String.class})
public @interface TrueFalseAdapter {
    public boolean lenient() default true;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter {
        private final String mPropertyName;
        private final boolean mLenient;

        public Adapter(Class<?> type, String propertyName, TrueFalseAdapter ann) {
            this(type, propertyName, ann == null ? true : ann.lenient());
        }

        public Adapter(Class<?> type, String propertyName, boolean lenient) {
            this.mPropertyName = propertyName;
            this.mLenient = lenient;
        }

        public char adaptToChar(boolean value) {
            return value ? (char)'T' : 'F';
        }

        public char adaptToChar(Boolean value) {
            return (char)(value != null && value != false ? 84 : 70);
        }

        public Character adaptToCharacter(boolean value) {
            return Character.valueOf(value ? (char)'T' : 'F');
        }

        public Character adaptToCharacter(Boolean value) {
            return Character.valueOf((char)(value != null && value != false ? 84 : 70));
        }

        public String adaptToString(boolean value) {
            return value ? "T" : "F";
        }

        public String adaptToString(Boolean value) {
            return value != null && value != false ? "T" : "F";
        }

        public boolean adaptToBoolean(char value) {
            switch (value) {
                case 'T': {
                    return true;
                }
                case 'F': {
                    return false;
                }
                case '1': 
                case 'Y': 
                case 't': 
                case 'y': {
                    if (!this.mLenient) break;
                    return true;
                }
                case '0': 
                case 'N': 
                case 'f': 
                case 'n': {
                    if (!this.mLenient) break;
                    return false;
                }
            }
            throw new IllegalArgumentException("Cannot adapt '" + value + "' into boolean for property \"" + this.mPropertyName + '\"');
        }

        public boolean adaptToBoolean(Character value) {
            if (value == null) {
                if (this.mLenient) {
                    return false;
                }
            } else {
                return this.adaptToBoolean(value.charValue());
            }
            throw new IllegalArgumentException("Cannot adapt '" + value + "' into boolean for property \"" + this.mPropertyName + '\"');
        }

        public boolean adaptToBoolean(String value) {
            int length;
            if (value == null || (length = value.length()) == 0) {
                if (this.mLenient) {
                    return false;
                }
            } else if (length == 1 || this.mLenient) {
                return this.adaptToBoolean(value.charAt(0));
            }
            throw new IllegalArgumentException("Cannot adapt '" + value + "' into boolean for property \"" + this.mPropertyName + '\"');
        }

        public Boolean adaptToBooleanObj(char value) {
            return this.adaptToBoolean(value);
        }

        public Boolean adaptToBooleanObj(Character value) {
            return this.adaptToBoolean(value);
        }

        public Boolean adaptToBooleanObj(String value) {
            return this.adaptToBoolean(value);
        }
    }
}

