/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.adapter;

import com.amazon.carbonado.adapter.AdapterDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@AdapterDefinition(storageTypePreferences={byte[].class})
public @interface PrimitiveArrayAdapter {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter {
        public Adapter(Class<?> type, String propertyName, PrimitiveArrayAdapter ann) {
        }

        public Adapter() {
        }

        public byte[] adaptToByteArray(short[] src) {
            if (src == null) {
                return null;
            }
            byte[] dst = new byte[src.length << 1];
            ByteBuffer.wrap(dst).asShortBuffer().put(src);
            return dst;
        }

        public byte[] adaptToByteArray(char[] src) {
            if (src == null) {
                return null;
            }
            byte[] dst = new byte[src.length << 1];
            ByteBuffer.wrap(dst).asCharBuffer().put(src);
            return dst;
        }

        public byte[] adaptToByteArray(int[] src) {
            if (src == null) {
                return null;
            }
            byte[] dst = new byte[src.length << 2];
            ByteBuffer.wrap(dst).asIntBuffer().put(src);
            return dst;
        }

        public byte[] adaptToByteArray(long[] src) {
            if (src == null) {
                return null;
            }
            byte[] dst = new byte[src.length << 3];
            ByteBuffer.wrap(dst).asLongBuffer().put(src);
            return dst;
        }

        public byte[] adaptToByteArray(float[] src) {
            if (src == null) {
                return null;
            }
            byte[] dst = new byte[src.length << 2];
            ByteBuffer.wrap(dst).asFloatBuffer().put(src);
            return dst;
        }

        public byte[] adaptToByteArray(double[] src) {
            if (src == null) {
                return null;
            }
            byte[] dst = new byte[src.length << 3];
            ByteBuffer.wrap(dst).asDoubleBuffer().put(src);
            return dst;
        }

        public byte[] adaptToByteArray(boolean[] src) {
            if (src == null) {
                return null;
            }
            int srcLength = src.length;
            byte[] dst = new byte[srcLength + 7 >> 3];
            int dstOffset = 0;
            int i = 0;
            while (i + 8 <= srcLength) {
                dst[dstOffset++] = (byte)((src[i++] ? 128 : 0) | (src[i++] ? 64 : 0) | (src[i++] ? 32 : 0) | (src[i++] ? 16 : 0) | (src[i++] ? 8 : 0) | (src[i++] ? 4 : 0) | (src[i++] ? 2 : 0) | (src[i++] ? 1 : 0));
            }
            if (i < srcLength) {
                int accum = 0;
                while (i < srcLength) {
                    accum = accum << 1 | (src[i++] ? 1 : 0);
                }
                dst[dstOffset] = (byte)(accum <<= 8 - (srcLength & 7));
            }
            return dst;
        }

        public short[] adaptToShortArray(byte[] src) {
            if (src == null) {
                return null;
            }
            short[] dst = new short[src.length + 1 >> 1];
            ByteBuffer.wrap(src).asShortBuffer().get(dst);
            return dst;
        }

        public char[] adaptToCharArray(byte[] src) {
            if (src == null) {
                return null;
            }
            char[] dst = new char[src.length + 1 >> 1];
            ByteBuffer.wrap(src).asCharBuffer().get(dst);
            return dst;
        }

        public int[] adaptToIntArray(byte[] src) {
            if (src == null) {
                return null;
            }
            int[] dst = new int[src.length + 3 >> 2];
            ByteBuffer.wrap(src).asIntBuffer().get(dst);
            return dst;
        }

        public long[] adaptToLongArray(byte[] src) {
            if (src == null) {
                return null;
            }
            long[] dst = new long[src.length + 7 >> 3];
            ByteBuffer.wrap(src).asLongBuffer().get(dst);
            return dst;
        }

        public float[] adaptToFloatArray(byte[] src) {
            if (src == null) {
                return null;
            }
            float[] dst = new float[src.length + 3 >> 2];
            ByteBuffer.wrap(src).asFloatBuffer().get(dst);
            return dst;
        }

        public double[] adaptToDoubleArray(byte[] src) {
            if (src == null) {
                return null;
            }
            double[] dst = new double[src.length + 7 >> 3];
            ByteBuffer.wrap(src).asDoubleBuffer().get(dst);
            return dst;
        }

        public boolean[] adaptToBooleanArray(byte[] src) {
            if (src == null) {
                return null;
            }
            int srcLength = src.length;
            boolean[] dst = new boolean[srcLength << 3];
            int dstOffset = 0;
            for (int i = 0; i < srcLength; ++i) {
                byte b = src[i];
                dst[dstOffset++] = (b & 0x80) != 0;
                dst[dstOffset++] = (b & 0x40) != 0;
                dst[dstOffset++] = (b & 0x20) != 0;
                dst[dstOffset++] = (b & 0x10) != 0;
                dst[dstOffset++] = (b & 8) != 0;
                dst[dstOffset++] = (b & 4) != 0;
                dst[dstOffset++] = (b & 2) != 0;
                dst[dstOffset++] = (b & 1) != 0;
            }
            return dst;
        }
    }
}

