/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import java.util.Random;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryException
extends Exception {
    private static final long serialVersionUID = 7261406895435249366L;
    private static Random cRandom;

    public static <E extends Throwable> int backoff(E e, int retryCount, int milliseconds) throws E {
        if (retryCount <= 0) {
            ThrowUnchecked.fire(e);
        }
        if (milliseconds > 0) {
            Random rnd = cRandom;
            if (rnd == null) {
                cRandom = rnd = new Random();
            }
            if ((milliseconds = rnd.nextInt(milliseconds)) > 0) {
                try {
                    Thread.sleep(milliseconds);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                return retryCount - 1;
            }
        }
        Thread.yield();
        return retryCount - 1;
    }

    public RepositoryException() {
    }

    public RepositoryException(String message) {
        super(message);
    }

    public RepositoryException(String message, Throwable cause) {
        super(message, cause);
    }

    public RepositoryException(Throwable cause) {
        super(cause);
    }

    public Throwable getRootCause() {
        Throwable cause = this;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public final PersistException toPersistException() {
        return this.toPersistException(null);
    }

    public final PersistException toPersistException(String message) {
        Throwable cause = this instanceof PersistException ? this : this.getCause();
        if (cause == null) {
            cause = this;
        } else if (cause instanceof PersistException && message == null) {
            return (PersistException)cause;
        }
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = message;
        } else if (message != null) {
            causeMessage = message + " : " + causeMessage;
        }
        return this.makePersistException(causeMessage, cause);
    }

    public final FetchException toFetchException() {
        return this.toFetchException(null);
    }

    public final FetchException toFetchException(String message) {
        Throwable cause = this instanceof FetchException ? this : this.getCause();
        if (cause == null) {
            cause = this;
        } else if (cause instanceof FetchException && message == null) {
            return (FetchException)cause;
        }
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = message;
        } else if (message != null) {
            causeMessage = message + " : " + causeMessage;
        }
        return this.makeFetchException(causeMessage, cause);
    }

    protected PersistException makePersistException(String message, Throwable cause) {
        return new PersistException(message, cause);
    }

    protected FetchException makeFetchException(String message, Throwable cause) {
        return new FetchException(message, cause);
    }
}

