/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Query<S extends Storable> {
    public Class<S> getStorableType();

    public Filter<S> getFilter();

    public FilterValues<S> getFilterValues();

    public int getBlankParameterCount();

    public Query<S> with(int var1);

    public Query<S> with(long var1);

    public Query<S> with(float var1);

    public Query<S> with(double var1);

    public Query<S> with(boolean var1);

    public Query<S> with(char var1);

    public Query<S> with(byte var1);

    public Query<S> with(short var1);

    public Query<S> with(Object var1);

    public Query<S> withValues(Object ... var1);

    public Query<S> and(String var1) throws FetchException;

    public Query<S> and(Filter<S> var1) throws FetchException;

    public Query<S> or(String var1) throws FetchException;

    public Query<S> or(Filter<S> var1) throws FetchException;

    public Query<S> not() throws FetchException;

    public Query<S> orderBy(String var1) throws FetchException;

    public Query<S> orderBy(String ... var1) throws FetchException;

    public <T extends S> Query<S> after(T var1) throws FetchException;

    public Cursor<S> fetch() throws FetchException;

    public Cursor<S> fetch(Controller var1) throws FetchException;

    public Cursor<S> fetchSlice(long var1, Long var3) throws FetchException;

    public Cursor<S> fetchSlice(long var1, Long var3, Controller var4) throws FetchException;

    public <T extends S> Cursor<S> fetchAfter(T var1) throws FetchException;

    public <T extends S> Cursor<S> fetchAfter(T var1, Controller var2) throws FetchException;

    public S loadOne() throws FetchException;

    public S loadOne(Controller var1) throws FetchException;

    public S tryLoadOne() throws FetchException;

    public S tryLoadOne(Controller var1) throws FetchException;

    public void deleteOne() throws PersistException;

    public void deleteOne(Controller var1) throws PersistException;

    public boolean tryDeleteOne() throws PersistException;

    public boolean tryDeleteOne(Controller var1) throws PersistException;

    public void deleteAll() throws PersistException;

    public void deleteAll(Controller var1) throws PersistException;

    public long count() throws FetchException;

    public long count(Controller var1) throws FetchException;

    public boolean exists() throws FetchException;

    public boolean exists(Controller var1) throws FetchException;

    public boolean printNative();

    public boolean printNative(Appendable var1) throws IOException;

    public boolean printNative(Appendable var1, int var2) throws IOException;

    public boolean printPlan();

    public boolean printPlan(Appendable var1) throws IOException;

    public boolean printPlan(Appendable var1, int var2) throws IOException;

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();

    public static final class Timeout
    implements Controller {
        private static final long serialVersionUID = 1L;
        private static final AtomicLongFieldUpdater<Timeout> endUpdater = AtomicLongFieldUpdater.newUpdater(Timeout.class, "mEndNanos");
        private final long mTimeout;
        private final TimeUnit mUnit;
        private volatile transient long mEndNanos;

        public static Timeout nanos(long timeout) {
            return new Timeout(timeout, TimeUnit.NANOSECONDS);
        }

        public static Timeout micros(long timeout) {
            return new Timeout(timeout, TimeUnit.MICROSECONDS);
        }

        public static Timeout millis(long timeout) {
            return new Timeout(timeout, TimeUnit.MILLISECONDS);
        }

        public static Timeout seconds(long timeout) {
            return new Timeout(timeout, TimeUnit.SECONDS);
        }

        public static Timeout minutes(long timeout) {
            return new Timeout(timeout, TimeUnit.MINUTES);
        }

        public static Timeout hours(long timeout) {
            return new Timeout(timeout, TimeUnit.HOURS);
        }

        public Timeout(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout cannot be negative: " + timeout);
            }
            if (unit == null && timeout != 0L) {
                throw new IllegalArgumentException("TimeUnit cannot be null if timeout is non-zero: " + timeout);
            }
            this.mTimeout = timeout;
            this.mUnit = unit;
        }

        public long getTimeout() {
            return this.mTimeout;
        }

        public TimeUnit getTimeoutUnit() {
            return this.mUnit;
        }

        public void begin() {
            long end = System.nanoTime() + this.mUnit.toNanos(this.mTimeout);
            if (end == 0L) {
                end = 1L;
            }
            endUpdater.compareAndSet(this, 0L, end);
        }

        public void continueCheck() throws FetchTimeoutException {
            long end = this.mEndNanos;
            if (end == 0L) {
                this.begin();
                end = this.mEndNanos;
            }
            if (System.nanoTime() - end >= 0L) {
                throw new FetchTimeoutException("Timed out: " + this.mTimeout + ' ' + (Object)((Object)this.mUnit));
            }
        }

        public void close() {
        }

        public String toString() {
            return "Query.Timeout {timeout=" + this.mTimeout + ", unit=" + (Object)((Object)this.mUnit) + '}';
        }
    }

    public static interface Controller
    extends Serializable,
    Closeable {
        public long getTimeout();

        public TimeUnit getTimeoutUnit();

        public void begin();

        public void continueCheck() throws FetchException;

        public void close();
    }
}

