/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.WireRecord;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.TxnEnd;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class OutputWireRecord
extends WireRecord {
    protected final ByteBuffer entryBuffer;
    protected final EnvironmentImpl envImpl;

    OutputWireRecord(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer readerBuffer) {
        this.envImpl = envImpl;
        this.header = header;
        this.entryBuffer = readerBuffer.slice();
        this.entryBuffer.limit(header.getItemSize());
    }

    OutputWireRecord(EnvironmentImpl envImpl, LogItem logItem) {
        this.envImpl = envImpl;
        this.header = logItem.getHeader();
        ByteBuffer buffer = logItem.getBuffer();
        buffer.position(this.header.getSize());
        this.entryBuffer = buffer.slice();
        assert (this.entryBuffer.limit() == this.header.getItemSize()) : "Limit:" + this.entryBuffer.limit() + " size:" + this.header.getItemSize();
    }

    OutputWireRecord(EnvironmentImpl envImpl, InputWireRecord input) {
        this.envImpl = envImpl;
        this.header = input.header;
        LogEntry entry = input.getLogEntry();
        this.entryBuffer = ByteBuffer.allocate(entry.getSize());
        entry.writeEntry(this.header, this.entryBuffer);
        this.entryBuffer.flip();
    }

    public byte getEntryType() {
        return this.header.getType();
    }

    public boolean match(InputWireRecord input) throws DatabaseException {
        if (!this.header.logicalEqualsIgnoreVersion(input.header)) {
            return false;
        }
        LogEntry entry = this.instantiateEntry(this.envImpl, this.entryBuffer);
        return entry.logicalEquals(input.getLogEntry());
    }

    public boolean match(OutputWireRecord otherRecord) throws DatabaseException {
        if (!this.header.logicalEqualsIgnoreVersion(otherRecord.header)) {
            return false;
        }
        LogEntry entry = this.instantiateEntry(this.envImpl, this.entryBuffer);
        LogEntry otherEntry = otherRecord.instantiateEntry(this.envImpl, otherRecord.entryBuffer);
        return entry.logicalEquals(otherEntry);
    }

    public VLSN getVLSN() {
        return this.header.getVLSN();
    }

    public String dump() throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        this.header.dumpRep(sb);
        LogEntry logEntry = this.instantiateEntry(this.envImpl, this.entryBuffer);
        logEntry.dumpRep(sb);
        return sb.toString();
    }

    public String toString() {
        try {
            return this.dump();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return "";
        }
    }

    int getWireSize() {
        return 17 + this.entryBuffer.limit() - this.entryBuffer.position();
    }

    void writeToWire(ByteBuffer messageBuffer) {
        messageBuffer.put(this.header.getType());
        LogUtils.writeInt(messageBuffer, this.header.getVersion());
        LogUtils.writeInt(messageBuffer, this.header.getItemSize());
        LogUtils.writeLong(messageBuffer, this.header.getVLSN().getSequence());
        this.entryBuffer.mark();
        messageBuffer.put(this.entryBuffer);
        this.entryBuffer.reset();
    }

    public long getCommitTxnId() throws DatabaseException {
        if (!LogEntryType.LOG_TXN_COMMIT.equalsType(this.header.getType())) {
            return 0L;
        }
        LogEntry commitEntry = this.instantiateEntry(this.envImpl, this.entryBuffer);
        return commitEntry.getTransactionId();
    }

    public long getTimeStamp() throws DatabaseException {
        LogEntry txnEndEntry = this.instantiateEntry(this.envImpl, this.entryBuffer);
        if (txnEndEntry instanceof TxnEnd) {
            return ((TxnEnd)txnEndEntry.getMainItem()).getTime().getTime();
        }
        return 0L;
    }

    public boolean verifyNegativeSequences(String debugTag) {
        LogEntry entry = null;
        try {
            entry = this.instantiateEntry(this.envImpl, this.entryBuffer);
        }
        catch (DatabaseException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        if (entry.getTransactionId() >= 0L) {
            throw EnvironmentFailureException.unexpectedState(debugTag + " txn id should be negative: " + entry);
        }
        if (entry instanceof LNLogEntry) {
            if (LogEntryType.LOG_NAMELN_TRANSACTIONAL.equalsType(this.getEntryType())) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                lnEntry.postFetchInit(false);
                NameLN nameLN = (NameLN)lnEntry.getLN();
                if (nameLN.getId().getId() >= 0L) {
                    throw EnvironmentFailureException.unexpectedState(debugTag + " db id should be negative: " + entry);
                }
            } else if (entry.getDbId().getId() >= 0L) {
                throw EnvironmentFailureException.unexpectedState(debugTag + " db id should be negative: " + entry);
            }
        }
        return true;
    }
}

