/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.raw.StorableCodecFactory;
import com.amazon.carbonado.repo.sleepycat.BDBCursor;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.repo.sleepycat.CompactionCapability;
import com.amazon.carbonado.repo.sleepycat.DB_Cursor;
import com.amazon.carbonado.repo.sleepycat.DB_Repository;
import com.amazon.carbonado.txn.TransactionScope;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import java.io.FileNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DB_Storage<S extends Storable>
extends BDBStorage<Transaction, S> {
    private Database mDatabase;

    DB_Storage(DB_Repository repository, Class<S> type) throws DatabaseException, RepositoryException {
        super((BDBRepository)repository, type);
        this.open(repository.mReadOnly);
    }

    protected boolean db_exists(Transaction txn, byte[] key, boolean rmw) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry dataEntry = new DatabaseEntry();
        dataEntry.setPartial(0, 0, true);
        OperationStatus status = this.mDatabase.get(txn, keyEntry, dataEntry, (LockMode)(rmw ? LockMode.RMW : null));
        return status != OperationStatus.NOTFOUND;
    }

    protected byte[] db_get(Transaction txn, byte[] key, boolean rmw) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry dataEntry = new DatabaseEntry();
        OperationStatus status = this.mDatabase.get(txn, keyEntry, dataEntry, (LockMode)(rmw ? LockMode.RMW : null));
        if (status == OperationStatus.NOTFOUND) {
            return NOT_FOUND;
        }
        return dataEntry.getData();
    }

    protected Object db_putNoOverwrite(Transaction txn, byte[] key, byte[] value) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry dataEntry = new DatabaseEntry(value);
        OperationStatus status = this.mDatabase.putNoOverwrite(txn, keyEntry, dataEntry);
        if (status == OperationStatus.SUCCESS) {
            return SUCCESS;
        }
        if (status == OperationStatus.KEYEXIST) {
            return KEY_EXIST;
        }
        return NOT_FOUND;
    }

    protected boolean db_put(Transaction txn, byte[] key, byte[] value) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry dataEntry = new DatabaseEntry(value);
        return this.mDatabase.put(txn, keyEntry, dataEntry) == OperationStatus.SUCCESS;
    }

    protected boolean db_delete(Transaction txn, byte[] key) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        return this.mDatabase.delete(txn, keyEntry) == OperationStatus.SUCCESS;
    }

    protected void db_truncate(Transaction txn) throws Exception {
        if (txn != null) {
            this.mDatabase.truncate(txn, false);
            return;
        }
        DB_Repository dbRepository = (DB_Repository)this.getRepository();
        StorableCodecFactory codecFactory = dbRepository.getStorableCodecFactory();
        String name = codecFactory.getStorageName(this.getStorableType());
        if (name == null) {
            name = this.getStorableType().getName();
        }
        String fileName = dbRepository.getDatabaseFileName(name);
        String dbName = dbRepository.getDatabaseName(name);
        this.close();
        dbRepository.mEnv.removeDatabase(null, fileName, dbName);
        this.open(false, null, false);
    }

    protected boolean db_isEmpty(Transaction txn, Object database, boolean rmw) throws Exception {
        Cursor cursor = ((Database)database).openCursor(txn, null);
        OperationStatus status = cursor.getFirst(new DatabaseEntry(), new DatabaseEntry(), (LockMode)(rmw ? LockMode.RMW : null));
        cursor.close();
        return status == OperationStatus.NOTFOUND;
    }

    protected CompactionCapability.Result<S> db_compact(Transaction txn, Object database, byte[] start, byte[] end) throws Exception {
        DatabaseEntry dstart = start == null ? null : new DatabaseEntry(start);
        DatabaseEntry dstop = end == null ? null : new DatabaseEntry(end);
        final CompactStats stats = ((Database)database).compact(txn, dstart, dstop, null, null);
        return new CompactionCapability.Result<S>(){

            public int getPagesExamine() {
                return stats.getPagesExamine();
            }

            public int getPagesFree() {
                return stats.getPagesFree();
            }

            public int getPagesTruncated() {
                return stats.getPagesTruncated();
            }

            public int getLevels() {
                return stats.getLevels();
            }

            public int getDeadlockCount() {
                return stats.getDeadlock();
            }

            public String toString() {
                return stats.toString();
            }
        };
    }

    protected void db_close(Object database) throws Exception {
        ((Database)database).close();
    }

    protected Object env_openPrimaryDatabase(Transaction txn, String name) throws Exception {
        DatabaseConfig config;
        DB_Repository dbRepository = (DB_Repository)this.getRepository();
        Environment env = dbRepository.mEnv;
        boolean readOnly = dbRepository.mReadOnly;
        try {
            config = (DatabaseConfig)dbRepository.getInitialDatabaseConfig();
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Unsupported initial environment config. Must be instance of " + DatabaseConfig.class.getName(), (Throwable)e);
        }
        if (config == null) {
            Integer pageSize;
            config = new DatabaseConfig();
            config.setType(DatabaseType.BTREE);
            config.setSortedDuplicates(false);
            if (dbRepository.mReverseSplitOff) {
                config.setReverseSplitOff(true);
            }
            if ((pageSize = dbRepository.getDatabasePageSize(this.getStorableType())) != null) {
                config.setPageSize(pageSize.intValue());
            }
            if (dbRepository.mChecksum != null) {
                config.setChecksum(dbRepository.mChecksum.booleanValue());
            }
        } else {
            if (DatabaseType.BTREE != config.getType()) {
                throw new IllegalArgumentException("DatabaseConfig: database type is not BTREE");
            }
            if (config.getSortedDuplicates()) {
                throw new IllegalArgumentException("DatabaseConfig: getSortedDuplicates is true");
            }
        }
        config.setTransactional(dbRepository.mDatabasesTransactional);
        config.setReadOnly(readOnly);
        config.setAllowCreate(!readOnly);
        this.runDatabasePrepareForOpeningHook(config);
        String fileName = dbRepository.getDatabaseFileName(name);
        String dbName = dbRepository.getDatabaseName(name);
        try {
            this.mDatabase = env.openDatabase(txn, fileName, dbName, config);
            return this.mDatabase;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(e.getMessage() + ": " + fileName);
        }
    }

    protected void env_removeDatabase(Transaction txn, String databaseName) throws Exception {
        DB_Repository dbRepository = (DB_Repository)this.getRepository();
        String fileName = dbRepository.getDatabaseFileName(databaseName);
        String dbName = dbRepository.getDatabaseName(databaseName);
        this.mDatabase.getEnvironment().removeDatabase(txn, fileName, dbName);
    }

    protected BDBCursor<Transaction, S> openCursor(TransactionScope<Transaction> scope, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse, Object database) throws Exception {
        return new DB_Cursor(scope, startBound, inclusiveStart, endBound, inclusiveEnd, maxPrefix, reverse, this, (Database)database);
    }
}

