/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.UtilizationFileReader;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;

public class DbSpace {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbSpace.class) + "\n" + "       -h <dir> # environment home directory\n" + "       [-q]     # quiet, print grand totals only\n" + "       [-u]     # sort by utilization\n" + "       [-d]     # dump file summary details\n" + "       [-r]     # recalculate utilization (reads entire log)\n" + "       [-V]     # print JE version number";
    private File envHome = null;
    private EnvironmentImpl envImpl;
    private UtilizationCalculator calculator;
    private boolean quiet = false;
    private boolean sorted = false;
    private boolean details = false;
    private boolean recalc = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] argv) throws Exception {
        block8: {
            DbSpace space = new DbSpace();
            space.parseArgs(argv);
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(true);
            Environment env = new Environment(space.envHome, envConfig);
            space.initEnv(DbInternal.getEnvironmentImpl(env));
            space.print(System.out);
            System.exit(0);
            Object var6_4 = null;
            try {
                env.close();
            }
            catch (Throwable e2) {
                e2.printStackTrace(System.err);
                System.exit(1);
            }
            break block8;
            {
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    System.exit(1);
                    Object var6_5 = null;
                    try {
                        env.close();
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace(System.err);
                        System.exit(1);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    env.close();
                }
                catch (Throwable e2) {
                    e2.printStackTrace(System.err);
                    System.exit(1);
                }
                throw throwable;
            }
        }
    }

    private DbSpace() {
    }

    public DbSpace(Environment env, boolean quiet, boolean details, boolean sorted) {
        this(DbInternal.getEnvironmentImpl(env), quiet, details, sorted);
    }

    public DbSpace(EnvironmentImpl envImpl, boolean quiet, boolean details, boolean sorted) {
        this.initEnv(envImpl);
        this.quiet = quiet;
        this.details = details;
        this.sorted = sorted;
    }

    private void initEnv(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.calculator = envImpl.getCleaner().getUtilizationCalculator();
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-u")) {
                this.sorted = true;
                continue;
            }
            if (thisArg.equals("-d")) {
                this.details = true;
                continue;
            }
            if (thisArg.equals("-r")) {
                this.recalc = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (!thisArg.equals("-h")) continue;
            if (argc < nArgs) {
                this.envHome = new File(argv[argc++]);
                continue;
            }
            this.printUsage("-h requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    public void setRecalculate(boolean recalc) {
        this.recalc = recalc;
    }

    public void print(PrintStream out) throws DatabaseException {
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        SortedMap<Long, FileSummary> map = profile.getFileSummaryMap(true);
        Map<Long, FileSummary> recalcMap = this.recalc ? UtilizationFileReader.calcFileSummaryMap(this.envImpl) : null;
        int fileIndex = 0;
        Summary totals = new Summary();
        Summary[] summaries = null;
        if (!this.quiet) {
            summaries = new Summary[map.size()];
        }
        for (Map.Entry<Long, FileSummary> entry : map.entrySet()) {
            Long fileNum = entry.getKey();
            FileSummary fs = entry.getValue();
            FileSummary recalcFs = null;
            if (recalcMap != null) {
                recalcFs = recalcMap.get(fileNum);
            }
            Summary summary = new Summary(fileNum, fs, recalcFs);
            if (summaries != null) {
                summaries[fileIndex] = summary;
            }
            if (this.details) {
                out.println("File 0x" + Long.toHexString(fileNum) + ": " + fs);
                if (recalcMap != null) {
                    out.println("Recalculated File 0x" + Long.toHexString(fileNum) + ": " + recalcFs);
                }
            }
            totals.add(summary);
            ++fileIndex;
        }
        if (this.details) {
            out.println();
        }
        out.println(this.recalc ? "  File    Size (KB)  % Used  % Used (recalculated)\n--------  ---------  ------  ------" : "  File    Size (KB)  % Used\n--------  ---------  ------");
        if (summaries != null) {
            if (this.sorted) {
                Arrays.sort(summaries, new Comparator<Summary>(){

                    @Override
                    public int compare(Summary s1, Summary s2) {
                        return s1.utilization() - s2.utilization();
                    }
                });
            }
            for (int i = 0; i < summaries.length; ++i) {
                summaries[i].print(out, this.recalc);
            }
        }
        totals.print(out, this.recalc);
        out.println("(LN size correction factor: " + this.calculator.getLNSizeCorrectionFactor() + ')');
    }

    private class Summary {
        static final String HEADER = "  File    Size (KB)  % Used\n--------  ---------  ------";
        static final String RECALC_HEADER = "  File    Size (KB)  % Used  % Used (recalculated)\n--------  ---------  ------  ------";
        Long fileNum;
        long totalSize;
        long obsoleteSize;
        long recalcObsoleteSize;

        Summary() {
        }

        Summary(Long fileNum, FileSummary summary, FileSummary recalcSummary) {
            this.fileNum = fileNum;
            this.totalSize = summary.totalSize;
            this.obsoleteSize = summary.getObsoleteSize(DbSpace.this.calculator.getLNSizeCorrectionFactor());
            if (recalcSummary != null) {
                this.recalcObsoleteSize = recalcSummary.getObsoleteSize();
            }
        }

        void add(Summary o) {
            this.totalSize += o.totalSize;
            this.obsoleteSize += o.obsoleteSize;
            this.recalcObsoleteSize += o.recalcObsoleteSize;
        }

        void print(PrintStream out, boolean recalc) {
            if (this.fileNum != null) {
                this.pad(out, Long.toHexString(this.fileNum), 8, '0');
            } else {
                out.print(" TOTALS ");
            }
            int kb = (int)(this.totalSize / 1024L);
            out.print("  ");
            this.pad(out, Integer.toString(kb), 9, ' ');
            out.print("     ");
            this.pad(out, Integer.toString(this.utilization()), 3, ' ');
            if (recalc) {
                out.print("     ");
                this.pad(out, Integer.toString(this.recalcUtilization()), 3, ' ');
            }
            out.println();
        }

        int utilization() {
            return FileSummary.utilization(this.obsoleteSize, this.totalSize);
        }

        int recalcUtilization() {
            return FileSummary.utilization(this.recalcObsoleteSize, this.totalSize);
        }

        private void pad(PrintStream out, String val, int digits, char padChar) {
            int padSize = digits - val.length();
            for (int i = 0; i < padSize; ++i) {
                out.print(padChar);
            }
            out.print(val);
        }
    }
}

