/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicationConfig;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class RepConfigManager
extends DbConfigManager {
    private final boolean validateParams;

    public RepConfigManager(EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        super(envConfig);
        RepConfigManager.checkEnvConfig(envConfig);
        ReplicationConfig repConfig = (ReplicationConfig)repConfigProxy;
        this.props.putAll((Map<?, ?>)repConfig.getProps());
        repConfig.verify();
        this.validateParams = repConfig.getValidateParams();
    }

    private static void checkEnvConfig(EnvironmentConfig envConfig) throws IllegalArgumentException {
        if (!envConfig.getTransactional()) {
            throw new IllegalArgumentException("A replicated environment must be transactional");
        }
        String logMemOnly = envConfig.getConfigParam(EnvironmentParams.LOG_MEMORY_ONLY.getName());
        if (Boolean.parseBoolean(logMemOnly)) {
            throw new IllegalArgumentException("A replicated environment must not log to memory");
        }
    }

    public ReplicationConfig makeReplicationConfig() {
        Properties repProperties = new Properties();
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String mvParamName;
            String name = (String)propNames.nextElement();
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(name);
            if (param == null && (param = EnvironmentParams.SUPPORTED_PARAMS.get(mvParamName = ConfigParam.multiValueParamName(name))) == null) {
                throw EnvironmentFailureException.unexpectedState(name + " is not a valid BDBJE environment configuration");
            }
            if (!param.isForReplication()) continue;
            repProperties.setProperty(name, this.props.getProperty(name));
        }
        return RepInternal.makeReplicationConfig(repProperties, this.validateParams);
    }
}

