/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import java.util.Comparator;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionComparator
implements Comparator<Class> {
    private final TypeDesc mFrom;

    public ConversionComparator(Class fromType) {
        this.mFrom = TypeDesc.forClass((Class)fromType);
    }

    public boolean isConversionPossible(Class toType) {
        return ConversionComparator.isConversionPossible(this.mFrom, TypeDesc.forClass((Class)toType));
    }

    private static boolean isConversionPossible(TypeDesc from, TypeDesc to) {
        if (from == to) {
            return true;
        }
        if (from.toPrimitiveType() != null && to.toPrimitiveType() != null) {
            from = from.toPrimitiveType();
            to = to.toPrimitiveType();
        } else {
            from = from.toObjectType();
            to = to.toObjectType();
        }
        switch (from.getTypeCode()) {
            default: {
                return to.toClass().isAssignableFrom(from.toClass());
            }
            case 4: {
                return to == TypeDesc.BOOLEAN;
            }
            case 8: {
                return to == TypeDesc.BYTE || to == TypeDesc.SHORT || to == TypeDesc.INT || to == TypeDesc.LONG || to == TypeDesc.FLOAT || to == TypeDesc.DOUBLE;
            }
            case 9: {
                return to == TypeDesc.SHORT || to == TypeDesc.INT || to == TypeDesc.LONG || to == TypeDesc.FLOAT || to == TypeDesc.DOUBLE;
            }
            case 5: {
                return to == TypeDesc.CHAR;
            }
            case 10: {
                return to == TypeDesc.INT || to == TypeDesc.LONG || to == TypeDesc.DOUBLE;
            }
            case 6: {
                return to == TypeDesc.FLOAT || to == TypeDesc.DOUBLE;
            }
            case 11: {
                return to == TypeDesc.LONG;
            }
            case 7: 
        }
        return to == TypeDesc.DOUBLE;
    }

    @Override
    public int compare(Class toType_a, Class toType_b) {
        TypeDesc from = this.mFrom;
        TypeDesc a = TypeDesc.forClass((Class)toType_a);
        TypeDesc b = TypeDesc.forClass((Class)toType_b);
        if (from == a) {
            if (from == b) {
                return 0;
            }
            return -1;
        }
        if (from == b) {
            return 1;
        }
        int result = ConversionComparator.compare(from, a, b);
        if (result != 0) {
            return result;
        }
        if (from.isPrimitive()) {
            if (from.toObjectType() != null) {
                from = from.toObjectType();
                return ConversionComparator.compare(from, a, b);
            }
        } else if (from.toPrimitiveType() != null) {
            result = ConversionComparator.compare(from = from.toPrimitiveType(), a, b);
            if (result != 0) {
                return result;
            }
            if (!toType_a.isPrimitive() && a.toPrimitiveType() != null) {
                a = a.toPrimitiveType();
            }
            if (!toType_b.isPrimitive() && b.toPrimitiveType() != null) {
                b = b.toPrimitiveType();
            }
            return ConversionComparator.compare(from, a, b);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int compare(TypeDesc from, TypeDesc a, TypeDesc b) {
        if (ConversionComparator.isConversionPossible(from, a)) {
            if (!ConversionComparator.isConversionPossible(from, b)) return -1;
            if (from.isPrimitive()) {
                if (a.isPrimitive()) {
                    if (!b.isPrimitive()) return -1;
                    return ConversionComparator.primitiveWidth(a) - ConversionComparator.primitiveWidth(b);
                }
                if (!b.isPrimitive()) return 0;
                return 1;
            }
            Class fromClass = from.toClass();
            if (fromClass.isInterface()) return 0;
            if (a.toClass().isInterface()) {
                if (b.toClass().isInterface()) return 0;
                return -1;
            }
            if (!b.toClass().isInterface()) return ConversionComparator.distance(fromClass, a.toClass()) - ConversionComparator.distance(fromClass, b.toClass());
            return 1;
        }
        if (!ConversionComparator.isConversionPossible(from, b)) return 0;
        return 1;
    }

    private static int primitiveWidth(TypeDesc type) {
        switch (type.getTypeCode()) {
            default: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 11: {
                return 7;
            }
            case 7: 
        }
        return 8;
    }

    private static int distance(Class from, Class to) {
        int distance = 0;
        while (from != to) {
            if ((from = from.getSuperclass()) == null) {
                return Integer.MAX_VALUE;
            }
            ++distance;
        }
        return distance;
    }
}

