/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.capability.Capability;
import com.amazon.carbonado.capability.ShutdownCapability;
import com.amazon.carbonado.sequence.SequenceCapability;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.sequence.SequenceValueProducerPool;
import com.amazon.carbonado.spi.StoragePool;
import com.amazon.carbonado.txn.TransactionManager;
import com.amazon.carbonado.txn.TransactionScope;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepository<Txn>
implements Repository,
ShutdownCapability,
SequenceCapability {
    private final String mName;
    private final ReadWriteLock mShutdownLock;
    private final StoragePool mStoragePool;
    private final SequenceValueProducerPool mSequencePool;
    private ShutdownHook mShutdownHook;
    volatile boolean mHasShutdown;

    protected AbstractRepository(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Repository name cannot be null");
        }
        this.mName = name;
        this.mShutdownLock = new ReentrantReadWriteLock();
        this.mStoragePool = new StoragePool(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected <S extends Storable> Storage<S> createStorage(Class<S> type) throws RepositoryException {
                AbstractRepository.this.lockoutShutdown();
                try {
                    Storage<S> storage = AbstractRepository.this.createStorage(type);
                    return storage;
                }
                finally {
                    AbstractRepository.this.unlockoutShutdown();
                }
            }
        };
        this.mSequencePool = new SequenceValueProducerPool(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected SequenceValueProducer createSequenceValueProducer(String name) throws RepositoryException {
                AbstractRepository.this.lockoutShutdown();
                try {
                    SequenceValueProducer sequenceValueProducer = AbstractRepository.this.createSequenceValueProducer(name);
                    return sequenceValueProducer;
                }
                finally {
                    AbstractRepository.this.unlockoutShutdown();
                }
            }
        };
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public <S extends Storable> Storage<S> storageFor(Class<S> type) throws SupportException, RepositoryException {
        return (Storage)this.mStoragePool.get(type);
    }

    @Override
    public Transaction enterTransaction() {
        return this.localTransactionScope().enter(null);
    }

    @Override
    public Transaction enterTransaction(IsolationLevel level) {
        return this.localTransactionScope().enter(level);
    }

    @Override
    public Transaction enterTopTransaction(IsolationLevel level) {
        return this.localTransactionScope().enterTop(level);
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        return this.localTransactionScope().getIsolationLevel();
    }

    @Override
    public <C extends Capability> C getCapability(Class<C> capabilityType) {
        if (capabilityType.isInstance(this)) {
            return (C)this;
        }
        return null;
    }

    @Override
    public void close() {
        this.shutdown(false);
    }

    public boolean isClosed() {
        return this.transactionManager().isClosed();
    }

    @Override
    public synchronized boolean isAutoShutdownEnabled() {
        return this.mShutdownHook != null;
    }

    @Override
    public synchronized void setAutoShutdownEnabled(boolean enabled) {
        try {
            if (this.mShutdownHook == null) {
                if (enabled) {
                    ShutdownHook hook = new ShutdownHook(this);
                    Runtime.getRuntime().addShutdownHook(hook);
                    this.mShutdownHook = hook;
                }
            } else if (!enabled) {
                Runtime.getRuntime().removeShutdownHook(this.mShutdownHook);
                this.mShutdownHook = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean suspendThreads) {
        if (!this.mHasShutdown) {
            ShutdownHook hook;
            AbstractRepository abstractRepository = this;
            synchronized (abstractRepository) {
                hook = this.mShutdownHook;
                if (hook == null) {
                    hook = new ShutdownHook(this);
                } else {
                    try {
                        Runtime.getRuntime().removeShutdownHook(hook);
                        this.mShutdownHook = null;
                    }
                    catch (IllegalStateException e) {
                        hook = null;
                    }
                }
            }
            if (hook != null) {
                hook.run(suspendThreads);
            }
        }
    }

    @Override
    public SequenceValueProducer getSequenceValueProducer(String name) throws RepositoryException {
        return this.mSequencePool.get(name);
    }

    protected abstract TransactionManager<Txn> transactionManager();

    protected abstract TransactionScope<Txn> localTransactionScope();

    protected void lockoutShutdown() {
        this.mShutdownLock.readLock().lock();
    }

    protected void unlockoutShutdown() {
        this.mShutdownLock.readLock().unlock();
    }

    void lockForShutdown() {
        this.mShutdownLock.writeLock().lock();
    }

    void unlockForShutdown() {
        this.mShutdownLock.writeLock().unlock();
    }

    protected Collection<Storage> allStorage() {
        return this.mStoragePool.values();
    }

    protected void shutdownHook() {
    }

    protected abstract Log getLog();

    protected abstract <S extends Storable> Storage<S> createStorage(Class<S> var1) throws RepositoryException;

    protected abstract SequenceValueProducer createSequenceValueProducer(String var1) throws RepositoryException;

    void info(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.info((Object)message);
        }
    }

    void error(String message, Throwable e) {
        Log log = this.getLog();
        if (log != null) {
            log.error((Object)message, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShutdownHook
    extends Thread {
        private final WeakReference<AbstractRepository<?>> mRepository;

        ShutdownHook(AbstractRepository repository) {
            super(repository.getClass().getSimpleName() + " shutdown (" + repository.getName() + ')');
            this.mRepository = new WeakReference<AbstractRepository>(repository);
        }

        @Override
        public void run() {
            this.run(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(boolean suspendThreads) {
            AbstractRepository repository = (AbstractRepository)this.mRepository.get();
            if (repository == null) {
                return;
            }
            repository.info("Closing repository \"" + repository.getName() + '\"');
            try {
                this.doShutdown(repository, suspendThreads);
            }
            finally {
                repository.mHasShutdown = true;
                this.mRepository.clear();
                repository.info("Closed repository \"" + repository.getName() + '\"');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doShutdown(AbstractRepository<?> repository, boolean suspendThreads) {
            repository.lockForShutdown();
            try {
                ((AbstractRepository)repository).mSequencePool.returnReservedValues(null);
                try {
                    repository.transactionManager().close(suspendThreads);
                }
                catch (Throwable e) {
                    repository.error("Failed to close TransactionManager", e);
                }
                repository.shutdownHook();
            }
            finally {
                repository.unlockForShutdown();
            }
        }
    }
}

