/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.sequence;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.sequence.AbstractSequenceValueProducer;
import com.amazon.carbonado.sequence.StoredSequence;

public class SequenceValueGenerator
extends AbstractSequenceValueProducer {
    public static final int DEFAULT_RESERVE_AMOUNT = 100;
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final int DEFAULT_INCREMENT = 1;
    private final Repository mRepository;
    private final Storage<StoredSequence> mStorage;
    private final StoredSequence mStoredSequence;
    private final int mIncrement;
    private final int mReserveAmount;
    private boolean mHasReservedValues;
    private long mNextValue;

    public SequenceValueGenerator(Repository repo, String name) throws RepositoryException {
        this(repo, name, 1L, 1);
    }

    public SequenceValueGenerator(Repository repo, String name, long initialValue, int increment) throws RepositoryException {
        this(repo, name, initialValue, increment, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceValueGenerator(Repository repo, String name, long initialValue, int increment, int reserveAmount) throws RepositoryException {
        if (repo == null || name == null || increment < 1 || reserveAmount < 1) {
            throw new IllegalArgumentException();
        }
        this.mRepository = repo;
        this.mIncrement = increment;
        this.mReserveAmount = reserveAmount;
        this.mStorage = repo.storageFor(StoredSequence.class);
        this.mStoredSequence = this.mStorage.prepare();
        this.mStoredSequence.setName(name);
        Transaction txn = repo.enterTopTransaction(null);
        txn.setForUpdate(true);
        try {
            if (!this.mStoredSequence.tryLoad()) {
                com.amazon.carbonado.spi.StoredSequence oldSequence;
                this.mStoredSequence.setInitialValue(initialValue);
                this.mStoredSequence.setNextValue(Long.MIN_VALUE);
                try {
                    oldSequence = repo.storageFor(com.amazon.carbonado.spi.StoredSequence.class).prepare();
                    oldSequence.setName(name);
                    if (oldSequence.tryLoad()) {
                        this.mStoredSequence.setInitialValue(oldSequence.getInitialValue());
                        this.mStoredSequence.setNextValue(oldSequence.getNextValue());
                    } else {
                        oldSequence = null;
                    }
                }
                catch (RepositoryException e) {
                    oldSequence = null;
                }
                if (this.mStoredSequence.tryInsert()) {
                    if (oldSequence != null) {
                        try {
                            oldSequence.tryDelete();
                        }
                        catch (RepositoryException e) {}
                    }
                } else {
                    this.mStoredSequence.load();
                }
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int initialValue) throws FetchException, PersistException {
        StoredSequence storedSequence = this.mStoredSequence;
        synchronized (storedSequence) {
            Transaction txn = this.mRepository.enterTopTransaction(null);
            txn.setForUpdate(true);
            try {
                boolean doUpdate = this.mStoredSequence.tryLoad();
                this.mStoredSequence.setInitialValue(initialValue);
                this.mStoredSequence.setNextValue(Long.MIN_VALUE);
                if (doUpdate) {
                    this.mStoredSequence.update();
                } else {
                    this.mStoredSequence.insert();
                }
                txn.commit();
                this.mHasReservedValues = false;
            }
            finally {
                txn.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextLongValue() throws PersistException {
        try {
            StoredSequence storedSequence = this.mStoredSequence;
            synchronized (storedSequence) {
                return this.nextUnadjustedValue() + Long.MIN_VALUE + this.mStoredSequence.getInitialValue();
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextIntValue() throws PersistException {
        try {
            StoredSequence storedSequence = this.mStoredSequence;
            synchronized (storedSequence) {
                long initial = this.mStoredSequence.getInitialValue();
                if (initial >= 0x100000000L) {
                    throw new PersistException("Sequence initial value too large to support 32-bit ints: " + this.mStoredSequence.getName() + ", initial: " + initial);
                }
                long next = this.nextUnadjustedValue();
                if (next >= -9223372032559808512L) {
                    throw new PersistException("Sequence exhausted for 32-bit ints: " + this.mStoredSequence.getName() + ", next: " + (next + Long.MIN_VALUE + initial));
                }
                return (int)(next + Long.MIN_VALUE + initial);
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnReservedValues() throws FetchException, PersistException {
        StoredSequence storedSequence = this.mStoredSequence;
        synchronized (storedSequence) {
            block9: {
                if (!this.mHasReservedValues) break block9;
                Transaction txn = this.mRepository.enterTopTransaction(null);
                txn.setForUpdate(true);
                try {
                    StoredSequence current = this.mStorage.prepare();
                    current.setName(this.mStoredSequence.getName());
                    if (current.tryLoad() && current.equals(this.mStoredSequence)) {
                        this.mStoredSequence.setNextValue(this.mNextValue + (long)this.mIncrement);
                        this.mStoredSequence.update();
                        txn.commit();
                        this.mHasReservedValues = false;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    txn.exit();
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextUnadjustedValue() throws FetchException, PersistException {
        if (this.mHasReservedValues) {
            long next;
            this.mNextValue = next = this.mNextValue + (long)this.mIncrement;
            if (next < this.mStoredSequence.getNextValue()) {
                return next;
            }
            this.mHasReservedValues = false;
        }
        Transaction txn = this.mRepository.enterTopTransaction(null);
        txn.setForUpdate(true);
        try {
            this.mStoredSequence.load();
            long next = this.mStoredSequence.getNextValue();
            long nextStored = next + (long)(this.mReserveAmount * this.mIncrement);
            if (next >= 0L && nextStored < 0L) {
                long avail = (Long.MAX_VALUE - next) / (long)this.mIncrement;
                if (avail > 0L) {
                    nextStored = next + avail * (long)this.mIncrement;
                } else {
                    throw new PersistException("Sequence exhausted: " + this.mStoredSequence.getName());
                }
            }
            this.mStoredSequence.setNextValue(nextStored);
            this.mStoredSequence.update();
            txn.commit();
            this.mNextValue = next;
            this.mHasReservedValues = true;
            long l = next;
            return l;
        }
        finally {
            txn.exit();
        }
    }
}

