/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistDeadlockException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.cursor.ControllerCursor;
import com.amazon.carbonado.cursor.EmptyCursor;
import com.amazon.carbonado.cursor.MergeSortBuffer;
import com.amazon.carbonado.cursor.SingletonCursor;
import com.amazon.carbonado.cursor.SortBuffer;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.layout.Layout;
import com.amazon.carbonado.layout.LayoutFactory;
import com.amazon.carbonado.layout.Unevolvable;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.qe.BoundaryType;
import com.amazon.carbonado.qe.QueryEngine;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.StorableIndexSet;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.raw.RawSupport;
import com.amazon.carbonado.raw.RawUtil;
import com.amazon.carbonado.raw.StorableCodec;
import com.amazon.carbonado.raw.StorableCodecFactory;
import com.amazon.carbonado.repo.sleepycat.BDBCursor;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.repo.sleepycat.CompactionCapability;
import com.amazon.carbonado.repo.sleepycat.StoredDatabaseInfo;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.IndexInfoImpl;
import com.amazon.carbonado.spi.LobEngine;
import com.amazon.carbonado.spi.TriggerManager;
import com.amazon.carbonado.txn.TransactionScope;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BDBStorage<Txn, S extends Storable>
implements Storage<S>,
StorageAccess<S> {
    protected static final byte[] SUCCESS = new byte[0];
    protected static final byte[] NOT_FOUND = new byte[0];
    protected static final Object KEY_EXIST = new Object();
    private static final int DEFAULT_LOB_BLOCK_SIZE = 1000;
    final BDBRepository<Txn> mRepository;
    private final Class<S> mType;
    StorableCodec<S> mStorableCodec;
    private final RawSupport<S> mRawSupport;
    private StorableIndex<S> mPrimaryKeyIndex;
    private Object mPrimaryDatabase;
    private QueryEngine<S> mQueryEngine;
    final TriggerManager<S> mTriggerManager;

    protected BDBStorage(BDBRepository<Txn> repository, Class<S> type) throws SupportException {
        this.mRepository = repository;
        this.mType = type;
        this.mRawSupport = new Support(repository, this);
        this.mTriggerManager = new TriggerManager();
        try {
            if (LobEngine.hasLobs(type)) {
                Trigger<S> lobTrigger = repository.getLobEngine().getSupportTrigger(type, 1000);
                this.addTrigger(lobTrigger);
            }
        }
        catch (SupportException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new SupportException(e);
        }
    }

    @Override
    public Class<S> getStorableType() {
        return this.mType;
    }

    @Override
    public S prepare() {
        return this.mStorableCodec.instantiate();
    }

    @Override
    public Query<S> query() throws FetchException {
        return this.mQueryEngine.query();
    }

    @Override
    public Query<S> query(String filter) throws FetchException {
        return this.mQueryEngine.query(filter);
    }

    @Override
    public Query<S> query(Filter<S> filter) throws FetchException {
        return this.mQueryEngine.query(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate() throws PersistException {
        if (this.mTriggerManager.getDeleteTrigger() == null && this.mRepository.mSingleFileName == null) {
            TransactionScope<Txn> scope = this.localTransactionScope();
            scope.getLock().lock();
            try {
                try {
                    this.db_truncate(scope.getTxn());
                    return;
                }
                catch (Exception e) {
                    throw this.toPersistException(e);
                }
            }
            finally {
                scope.getLock().unlock();
            }
        }
        int batchSize = 100;
        while (true) {
            Transaction txn = this.mRepository.enterTransaction(IsolationLevel.READ_COMMITTED);
            txn.setForUpdate(true);
            try {
                Cursor<S> cursor = this.query().fetch();
                if (!cursor.hasNext()) {
                    return;
                }
                int count = 0;
                do {
                    ((Storable)cursor.next()).tryDelete();
                } while (count++ < 100 && cursor.hasNext());
                txn.commit();
                continue;
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
            finally {
                txn.exit();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean addTrigger(Trigger<? super S> trigger) {
        return this.mTriggerManager.addTrigger(trigger);
    }

    @Override
    public boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mTriggerManager.removeTrigger(trigger);
    }

    public IndexInfo[] getIndexInfo() {
        StorableIndex<S> pkIndex = this.mPrimaryKeyIndex;
        if (pkIndex == null) {
            return new IndexInfo[0];
        }
        int i = pkIndex.getPropertyCount();
        String[] propertyNames = new String[i];
        Direction[] directions = new Direction[i];
        while (--i >= 0) {
            propertyNames[i] = pkIndex.getProperty(i).getName();
            directions[i] = pkIndex.getPropertyDirection(i);
        }
        return new IndexInfo[]{new IndexInfoImpl(this.getStorableType().getName(), true, true, propertyNames, directions)};
    }

    @Override
    public QueryExecutorFactory<S> getQueryExecutorFactory() {
        return this.mQueryEngine;
    }

    @Override
    public Collection<StorableIndex<S>> getAllIndexes() {
        return Collections.singletonList(this.mPrimaryKeyIndex);
    }

    @Override
    public Storage<S> storageDelegate(StorableIndex<S> index) {
        return null;
    }

    @Override
    public SortBuffer<S> createSortBuffer() {
        return new MergeSortBuffer();
    }

    @Override
    public SortBuffer<S> createSortBuffer(Query.Controller controller) {
        return new MergeSortBuffer(controller);
    }

    @Override
    public long countAll() throws FetchException {
        return -1L;
    }

    @Override
    public long countAll(Query.Controller controller) throws FetchException {
        return -1L;
    }

    @Override
    public Cursor<S> fetchAll() throws FetchException {
        return this.fetchAll(null);
    }

    @Override
    public Cursor<S> fetchAll(Query.Controller controller) throws FetchException {
        return this.fetchSubset(null, null, BoundaryType.OPEN, null, BoundaryType.OPEN, null, false, false, controller);
    }

    @Override
    public Cursor<S> fetchOne(StorableIndex<S> index, Object[] identityValues) throws FetchException {
        return this.fetchOne(index, identityValues, null);
    }

    @Override
    public Cursor<S> fetchOne(StorableIndex<S> index, Object[] identityValues, Query.Controller controller) throws FetchException {
        byte[] key = this.mStorableCodec.encodePrimaryKey(identityValues);
        byte[] value = this.mRawSupport.tryLoad(null, key);
        if (value == null) {
            return EmptyCursor.the();
        }
        return new SingletonCursor<S>(this.instantiate(key, value));
    }

    @Override
    public Query<?> indexEntryQuery(StorableIndex<S> index) {
        return null;
    }

    @Override
    public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> index, Query<?> indexEntryQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> index, Query<?> indexEntryQuery, Query.Controller controller) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<S> fetchSubset(StorableIndex<S> index, Object[] identityValues, BoundaryType rangeStartBoundary, Object rangeStartValue, BoundaryType rangeEndBoundary, Object rangeEndValue, boolean reverseRange, boolean reverseOrder) throws FetchException {
        TransactionScope<Txn> scope = this.localTransactionScope();
        if (reverseRange) {
            Object temp = rangeStartBoundary;
            rangeStartBoundary = rangeEndBoundary;
            rangeEndBoundary = temp;
            temp = rangeStartValue;
            rangeStartValue = rangeEndValue;
            rangeEndValue = temp;
        }
        scope.getLock().lock();
        try {
            byte[] endBound;
            byte[] startBound;
            StorableCodec<S> codec = this.mStorableCodec;
            byte[] identityKey = identityValues == null || identityValues.length == 0 ? codec.encodePrimaryKeyPrefix() : codec.encodePrimaryKey(identityValues, 0, identityValues.length);
            if (rangeStartBoundary == BoundaryType.OPEN) {
                startBound = identityKey;
            } else {
                startBound = this.createBound(identityValues, identityKey, rangeStartValue, codec);
                if (!reverseOrder && rangeStartBoundary == BoundaryType.EXCLUSIVE) {
                    if (!RawUtil.increment(startBound)) {
                        Cursor cursor = EmptyCursor.the();
                        return cursor;
                    }
                    rangeStartBoundary = BoundaryType.INCLUSIVE;
                }
            }
            if (rangeEndBoundary == BoundaryType.OPEN) {
                endBound = identityKey;
            } else {
                endBound = this.createBound(identityValues, identityKey, rangeEndValue, codec);
                if (reverseOrder && rangeEndBoundary == BoundaryType.EXCLUSIVE) {
                    if (!RawUtil.decrement(endBound)) {
                        Cursor cursor = EmptyCursor.the();
                        return cursor;
                    }
                    rangeEndBoundary = BoundaryType.INCLUSIVE;
                }
            }
            boolean inclusiveStart = rangeStartBoundary != BoundaryType.EXCLUSIVE;
            boolean inclusiveEnd = rangeEndBoundary != BoundaryType.EXCLUSIVE;
            try {
                BDBCursor<Txn, S> cursor = this.openCursor(scope, startBound, inclusiveStart, endBound, inclusiveEnd, this.mStorableCodec.getPrimaryKeyPrefixLength(), reverseOrder, this.getPrimaryDatabase());
                cursor.open();
                BDBCursor<Txn, S> bDBCursor = cursor;
                return bDBCursor;
            }
            catch (Exception e) {
                throw this.toFetchException(e);
            }
        }
        finally {
            scope.getLock().unlock();
        }
    }

    @Override
    public Cursor<S> fetchSubset(StorableIndex<S> index, Object[] identityValues, BoundaryType rangeStartBoundary, Object rangeStartValue, BoundaryType rangeEndBoundary, Object rangeEndValue, boolean reverseRange, boolean reverseOrder, Query.Controller controller) throws FetchException {
        return ControllerCursor.apply(this.fetchSubset(index, identityValues, rangeStartBoundary, rangeStartValue, rangeEndBoundary, rangeEndValue, reverseRange, reverseOrder), controller);
    }

    private byte[] createBound(Object[] exactValues, byte[] exactKey, Object rangeValue, StorableCodec<S> codec) {
        Object[] values = new Object[]{rangeValue};
        if (exactValues == null || exactValues.length == 0) {
            return codec.encodePrimaryKey(values, 0, 1);
        }
        byte[] rangeKey = codec.encodePrimaryKey(values, exactValues.length, exactValues.length + 1);
        byte[] bound = new byte[exactKey.length + rangeKey.length];
        System.arraycopy(exactKey, 0, bound, 0, exactKey.length);
        System.arraycopy(rangeKey, 0, bound, exactKey.length, rangeKey.length);
        return bound;
    }

    protected BDBRepository getRepository() {
        return this.mRepository;
    }

    protected void open(boolean readOnly) throws RepositoryException {
        this.open(readOnly, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(boolean readOnly, Txn openTxn, boolean installTriggers) throws RepositoryException {
        StorableIndex pkIndex;
        boolean isPrimaryEmpty;
        StoredDatabaseInfo primaryInfo;
        Object primaryDatabase;
        StorableInfo<S> info = StorableIntrospector.examine(this.getStorableType());
        StorableCodecFactory codecFactory = this.mRepository.getStorableCodecFactory();
        Layout layout = this.getLayout(readOnly, codecFactory);
        String databaseName = codecFactory.getStorageName(this.getStorableType());
        if (databaseName == null) {
            databaseName = this.getStorableType().getName();
        }
        try {
            TransactionScope<Txn> scope = this.mRepository.localTransactionScope();
            scope.getLock().lock();
            try {
                primaryDatabase = this.env_openPrimaryDatabase(openTxn, databaseName);
                primaryInfo = this.registerPrimaryDatabase(readOnly, layout);
                isPrimaryEmpty = this.db_isEmpty(null, primaryDatabase, scope.isForUpdate());
            }
            finally {
                scope.getLock().unlock();
            }
        }
        catch (Exception e) {
            throw this.toRepositoryException(e);
        }
        StorableIndexSet<S> indexSet = new StorableIndexSet<S>();
        indexSet.addIndexes(info);
        indexSet.addAlternateKeys(info);
        indexSet.addPrimaryKey(info);
        indexSet.reduce(Direction.ASCENDING);
        StorableIndex desiredPkIndex = indexSet.findPrimaryKeyIndex(info);
        if (!isPrimaryEmpty && primaryInfo != null && primaryInfo.getIndexNameDescriptor() != null) {
            try {
                pkIndex = this.verifyPrimaryKey(info, desiredPkIndex, primaryInfo.getIndexNameDescriptor(), primaryInfo.getIndexTypeDescriptor());
            }
            catch (SupportException e) {
                try {
                    this.db_close(primaryDatabase);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        pkIndex = desiredPkIndex;
        if (!(primaryInfo == null || pkIndex.getNameDescriptor().equals(primaryInfo.getIndexNameDescriptor()) && pkIndex.getTypeDescriptor().equals(primaryInfo.getIndexTypeDescriptor()))) {
            primaryInfo.setIndexNameDescriptor(pkIndex.getNameDescriptor());
            primaryInfo.setIndexTypeDescriptor(pkIndex.getTypeDescriptor());
            if (!readOnly) {
                Repository repo = this.mRepository.getRootRepository();
                try {
                    Transaction txn = repo.enterTopTransaction(IsolationLevel.READ_COMMITTED);
                    try {
                        primaryInfo.update();
                        txn.commit();
                    }
                    finally {
                        txn.exit();
                    }
                }
                catch (PersistException e) {
                    if (e instanceof PersistDeadlockException || e instanceof PersistTimeoutException) {
                        Transaction txn = repo.enterTransaction(IsolationLevel.READ_COMMITTED);
                        try {
                            primaryInfo.update();
                            txn.commit();
                        }
                        finally {
                            txn.exit();
                        }
                    }
                    throw e;
                }
            }
        }
        pkIndex = pkIndex.clustered(true);
        try {
            this.mStorableCodec = codecFactory.createCodec(this.getStorableType(), pkIndex, this.mRepository.isMaster(), layout, this.mRawSupport);
        }
        catch (SupportException e) {
            try {
                this.db_close(primaryDatabase);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.unregisterDatabase(readOnly, this.getStorableType().getName());
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        this.mPrimaryKeyIndex = this.mStorableCodec.getPrimaryKeyIndex();
        this.mPrimaryDatabase = primaryDatabase;
        this.mQueryEngine = new QueryEngine<S>(this.getStorableType(), this.mRepository);
        if (installTriggers) {
            this.mTriggerManager.addTriggers(this.getStorableType(), this.mRepository.mTriggerFactories);
        }
    }

    protected S instantiate(byte[] key, byte[] value) throws FetchException {
        return this.mStorableCodec.instantiate(key, value);
    }

    protected CompactionCapability.Result<S> compact() throws RepositoryException {
        byte[] end;
        byte[] start = this.mStorableCodec.encodePrimaryKeyPrefix();
        if (start != null && start.length == 0) {
            start = null;
        }
        if (start == null) {
            end = null;
        } else {
            end = (byte[])start.clone();
            if (!RawUtil.increment(end)) {
                end = null;
            }
        }
        try {
            Txn txn = this.mRepository.localTransactionScope().getTxn();
            return this.db_compact(txn, this.mPrimaryDatabase, start, end);
        }
        catch (Exception e) {
            throw this.mRepository.toRepositoryException(e);
        }
    }

    protected abstract boolean db_exists(Txn var1, byte[] var2, boolean var3) throws Exception;

    protected abstract byte[] db_get(Txn var1, byte[] var2, boolean var3) throws Exception;

    protected abstract Object db_putNoOverwrite(Txn var1, byte[] var2, byte[] var3) throws Exception;

    protected abstract boolean db_put(Txn var1, byte[] var2, byte[] var3) throws Exception;

    protected abstract boolean db_delete(Txn var1, byte[] var2) throws Exception;

    protected abstract void db_truncate(Txn var1) throws Exception;

    protected abstract boolean db_isEmpty(Txn var1, Object var2, boolean var3) throws Exception;

    protected CompactionCapability.Result<S> db_compact(Txn txn, Object database, byte[] start, byte[] end) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract void db_close(Object var1) throws Exception;

    protected abstract Object env_openPrimaryDatabase(Txn var1, String var2) throws Exception;

    protected void runDatabasePrepareForOpeningHook(Object database) throws RepositoryException {
        this.mRepository.runDatabasePrepareForOpeningHook(database);
    }

    protected abstract void env_removeDatabase(Txn var1, String var2) throws Exception;

    protected abstract BDBCursor<Txn, S> openCursor(TransactionScope<Txn> var1, byte[] var2, boolean var3, byte[] var4, boolean var5, int var6, boolean var7, Object var8) throws Exception;

    FetchException toFetchException(Throwable e) {
        return this.mRepository.toFetchException(e);
    }

    PersistException toPersistException(Throwable e) {
        return this.mRepository.toPersistException(e);
    }

    RepositoryException toRepositoryException(Throwable e) {
        return this.mRepository.toRepositoryException(e);
    }

    TransactionScope<Txn> localTransactionScope() {
        return this.mRepository.localTransactionScope();
    }

    Object getPrimaryDatabase() throws FetchException {
        Object database = this.mPrimaryDatabase;
        if (database == null) {
            this.checkClosed();
            throw new IllegalStateException("BDBStorage not opened");
        }
        return database;
    }

    Blob getBlob(S storable, String name, long locator) throws FetchException {
        try {
            return this.mRepository.getLobEngine().getBlobValue(locator);
        }
        catch (RepositoryException e) {
            throw e.toFetchException();
        }
    }

    long getLocator(Blob blob) throws PersistException {
        try {
            return this.mRepository.getLobEngine().getLocator(blob);
        }
        catch (ClassCastException e) {
            throw new PersistException(e);
        }
        catch (RepositoryException e) {
            throw e.toPersistException();
        }
    }

    Clob getClob(S storable, String name, long locator) throws FetchException {
        try {
            return this.mRepository.getLobEngine().getClobValue(locator);
        }
        catch (RepositoryException e) {
            throw e.toFetchException();
        }
    }

    long getLocator(Clob clob) throws PersistException {
        try {
            return this.mRepository.getLobEngine().getLocator(clob);
        }
        catch (ClassCastException e) {
            throw new PersistException(e);
        }
        catch (RepositoryException e) {
            throw e.toPersistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() throws FetchException {
        block5: {
            TransactionScope<Txn> scope = this.localTransactionScope();
            scope.getLock().lock();
            try {
                if (this.mPrimaryDatabase != null) break block5;
                try {
                    scope.getTxn();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new FetchException("Repository closed");
            }
            finally {
                scope.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws Exception {
        TransactionScope<Txn> scope = this.mRepository.localTransactionScope();
        scope.getLock().lock();
        try {
            if (this.mPrimaryDatabase != null) {
                this.db_close(this.mPrimaryDatabase);
                this.mPrimaryDatabase = null;
            }
        }
        finally {
            scope.getLock().unlock();
        }
    }

    Layout getLayout(boolean readOnly, StorableCodecFactory codecFactory) throws RepositoryException {
        LayoutFactory factory;
        if (Unevolvable.class.isAssignableFrom(this.getStorableType())) {
            return null;
        }
        try {
            factory = this.mRepository.getLayoutFactory();
        }
        catch (SupportException e) {
            return null;
        }
        Class<S> type = this.getStorableType();
        return factory.layoutFor(readOnly, type, codecFactory.getLayoutOptions(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoredDatabaseInfo registerPrimaryDatabase(boolean readOnly, Layout layout) throws Exception {
        StoredDatabaseInfo info;
        if (this.getStorableType() == StoredDatabaseInfo.class) {
            return null;
        }
        Repository repo = this.mRepository.getRootRepository();
        try {
            info = repo.storageFor(StoredDatabaseInfo.class).prepare();
        }
        catch (SupportException e) {
            return null;
        }
        info.setDatabaseName(this.getStorableType().getName());
        boolean top = true;
        int retryCount = 3;
        while (true) {
            try {
                Transaction txn = top ? repo.enterTopTransaction(IsolationLevel.READ_COMMITTED) : repo.enterTransaction(IsolationLevel.READ_COMMITTED);
                txn.setForUpdate(true);
                try {
                    if (!info.tryLoad()) {
                        if (layout == null) {
                            info.setEvolutionStrategy(0);
                        } else {
                            info.setEvolutionStrategy(1);
                        }
                        info.setCreationTimestamp(System.currentTimeMillis());
                        info.setVersionNumber(0);
                        if (!readOnly) {
                            info.insert();
                        }
                    }
                    txn.commit();
                }
                finally {
                    txn.exit();
                }
            }
            catch (UniqueConstraintException e) {
                retryCount = UniqueConstraintException.backoff(e, retryCount, 1000);
                continue;
            }
            catch (FetchException e) {
                if ((e instanceof FetchDeadlockException || e instanceof FetchTimeoutException) && top) {
                    top = false;
                    retryCount = FetchException.backoff(e, retryCount, 100);
                    continue;
                }
                throw e;
            }
            catch (PersistException e) {
                if ((e instanceof PersistDeadlockException || e instanceof PersistTimeoutException) && top) {
                    top = false;
                    retryCount = PersistException.backoff(e, retryCount, 100);
                    continue;
                }
                throw e;
            }
            break;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDatabase(boolean readOnly, String name) throws RepositoryException {
        if (this.getStorableType() == StoredDatabaseInfo.class) {
            return;
        }
        if (!readOnly) {
            StoredDatabaseInfo info;
            Repository repo = this.mRepository.getRootRepository();
            try {
                info = repo.storageFor(StoredDatabaseInfo.class).prepare();
            }
            catch (SupportException e) {
                return;
            }
            info.setDatabaseName(name);
            Transaction txn = repo.enterTopTransaction(IsolationLevel.READ_COMMITTED);
            try {
                info.delete();
                txn.commit();
            }
            finally {
                txn.exit();
            }
        }
    }

    private StorableIndex<S> verifyPrimaryKey(StorableInfo<S> info, StorableIndex<S> desiredPkIndex, String nameDescriptor, String typeDescriptor) throws SupportException {
        StorableIndex<S> pkIndex;
        try {
            pkIndex = StorableIndex.parseNameDescriptor(nameDescriptor, info);
        }
        catch (IllegalArgumentException e) {
            throw new SupportException("Existing primary key apparently refers to properties which no longer exist. Primary key cannot change if Storage<" + info.getStorableType().getName() + "> is not empty. " + "Primary key name descriptor: " + nameDescriptor + ", error: " + e.getMessage());
        }
        if (!nameDescriptor.equals(desiredPkIndex.getNameDescriptor())) {
            throw new SupportException(this.buildIndexMismatchMessage(info, pkIndex, desiredPkIndex, null, false));
        }
        if (!typeDescriptor.equals(desiredPkIndex.getTypeDescriptor())) {
            throw new SupportException(this.buildIndexMismatchMessage(info, pkIndex, desiredPkIndex, typeDescriptor, true));
        }
        return pkIndex;
    }

    private String buildIndexMismatchMessage(StorableInfo<S> info, StorableIndex<S> pkIndex, StorableIndex<S> desiredPkIndex, String typeDescriptor, boolean showDesiredType) {
        StringBuilder message = new StringBuilder();
        message.append("Cannot change primary key if Storage<" + info.getStorableType().getName() + "> is not empty. Primary key was ");
        this.appendIndexDecl(message, pkIndex, typeDescriptor, false);
        message.append(", but new specification is ");
        this.appendIndexDecl(message, desiredPkIndex, null, showDesiredType);
        return message.toString();
    }

    private void appendIndexDecl(StringBuilder buf, StorableIndex<S> index, String typeDescriptor, boolean showDesiredType) {
        int i;
        buf.append('[');
        int count = index.getPropertyCount();
        TypeDesc[] types = null;
        boolean[] nullable = null;
        if (typeDescriptor != null) {
            types = new TypeDesc[count];
            nullable = new boolean[count];
            try {
                for (i = 0; i < count; ++i) {
                    String typeStr;
                    if (typeDescriptor.charAt(0) == 'N') {
                        typeDescriptor = typeDescriptor.substring(1);
                        nullable[i] = true;
                    }
                    if (typeDescriptor.charAt(0) == 'L') {
                        int end = typeDescriptor.indexOf(59);
                        typeStr = typeDescriptor.substring(0, end + 1);
                        typeDescriptor = typeDescriptor.substring(end + 1);
                    } else {
                        typeStr = typeDescriptor.substring(0, 1);
                        typeDescriptor = typeDescriptor.substring(1);
                    }
                    types[i] = TypeDesc.forDescriptor((String)typeStr);
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (types != null) {
                if (nullable[i]) {
                    buf.append("@Nullable ");
                }
                buf.append(types[i].getFullName());
                buf.append(' ');
            } else if (showDesiredType) {
                if (index.getProperty(i).isNullable()) {
                    buf.append("@Nullable ");
                }
                buf.append(TypeDesc.forClass(index.getProperty(i).getType()).getFullName());
                buf.append(' ');
            }
            buf.append(index.getPropertyDirection(i).toCharacter());
            buf.append(index.getProperty(i).getName());
        }
        buf.append(']');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Support
    implements RawSupport<S> {
        private final BDBRepository<Txn> mRepository;
        private final BDBStorage<Txn, S> mStorage;
        private Map<String, ? extends StorableProperty<S>> mProperties;

        Support(BDBRepository<Txn> repo, BDBStorage<Txn, S> storage) {
            this.mRepository = repo;
            this.mStorage = storage;
        }

        @Override
        public Repository getRootRepository() {
            return this.mRepository.getRootRepository();
        }

        @Override
        public boolean isPropertySupported(String name) {
            if (name == null) {
                return false;
            }
            if (this.mProperties == null) {
                this.mProperties = StorableIntrospector.examine(this.mStorage.getStorableType()).getAllProperties();
            }
            return this.mProperties.containsKey(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] tryLoad(S storable, byte[] key) throws FetchException {
            byte[] result;
            TransactionScope scope = this.mStorage.localTransactionScope();
            scope.getLock().lock();
            try {
                try {
                    result = this.mStorage.db_get(scope.getTxn(), key, scope.isForUpdate());
                }
                catch (Throwable e) {
                    throw this.mStorage.toFetchException(e);
                }
            }
            finally {
                scope.getLock().unlock();
            }
            if (result == NOT_FOUND) {
                return null;
            }
            if (result == null) {
                result = SUCCESS;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryInsert(S storable, byte[] key, byte[] value) throws PersistException {
            Object result;
            TransactionScope scope = this.mStorage.localTransactionScope();
            scope.getLock().lock();
            try {
                try {
                    result = this.mStorage.db_putNoOverwrite(scope.getTxn(), key, value);
                }
                catch (Throwable e) {
                    throw this.mStorage.toPersistException(e);
                }
            }
            finally {
                scope.getLock().unlock();
            }
            if (result == KEY_EXIST) {
                return false;
            }
            if (result != SUCCESS) {
                throw new PersistException("Failed");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(S storable, byte[] key, byte[] value) throws PersistException {
            TransactionScope scope = this.mStorage.localTransactionScope();
            scope.getLock().lock();
            try {
                try {
                    if (!this.mStorage.db_put(scope.getTxn(), key, value)) {
                        throw new PersistException("Failed");
                    }
                }
                catch (Throwable e) {
                    throw this.mStorage.toPersistException(e);
                }
            }
            finally {
                scope.getLock().unlock();
            }
        }

        @Override
        public boolean tryDelete(S storable, byte[] key) throws PersistException {
            TransactionScope scope = this.mStorage.localTransactionScope();
            scope.getLock().lock();
            try {
                boolean bl = this.mStorage.db_delete(scope.getTxn(), key);
                return bl;
            }
            catch (Throwable e) {
                throw this.mStorage.toPersistException(e);
            }
            finally {
                scope.getLock().unlock();
            }
        }

        @Override
        public Blob getBlob(S storable, String name, long locator) throws FetchException {
            return this.mStorage.getBlob(storable, name, locator);
        }

        @Override
        public long getLocator(Blob blob) throws PersistException {
            return this.mStorage.getLocator(blob);
        }

        @Override
        public Clob getClob(S storable, String name, long locator) throws FetchException {
            return this.mStorage.getClob(storable, name, locator);
        }

        @Override
        public long getLocator(Clob clob) throws PersistException {
            return this.mStorage.getLocator(clob);
        }

        @Override
        public void decode(S dest, int generation, byte[] data) throws CorruptEncodingException {
            BDBStorage.this.mStorableCodec.decode(dest, generation, data);
        }

        @Override
        public SequenceValueProducer getSequenceValueProducer(String name) throws PersistException {
            try {
                return this.mStorage.mRepository.getSequenceValueProducer(name);
            }
            catch (RepositoryException e) {
                throw e.toPersistException();
            }
        }

        @Override
        public Trigger<? super S> getInsertTrigger() {
            return this.mStorage.mTriggerManager.getInsertTrigger();
        }

        @Override
        public Trigger<? super S> getUpdateTrigger() {
            return this.mStorage.mTriggerManager.getUpdateTrigger();
        }

        @Override
        public Trigger<? super S> getDeleteTrigger() {
            return this.mStorage.mTriggerManager.getDeleteTrigger();
        }

        @Override
        public Trigger<? super S> getLoadTrigger() {
            return this.mStorage.mTriggerManager.getLoadTrigger();
        }

        @Override
        public void locallyDisableLoadTrigger() {
            this.mStorage.mTriggerManager.locallyDisableLoad();
        }

        @Override
        public void locallyEnableLoadTrigger() {
            this.mStorage.mTriggerManager.locallyEnableLoad();
        }
    }
}

