/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.raw.RawCursor;
import com.amazon.carbonado.raw.RawUtil;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.txn.TransactionScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BDBCursor<Txn, S extends Storable>
extends RawCursor<S> {
    private static final byte[] NO_DATA = new byte[0];
    private final TransactionScope<Txn> mScope;
    private final BDBStorage<Txn, S> mStorage;

    protected BDBCursor(TransactionScope<Txn> scope, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse, BDBStorage<Txn, S> storage) throws FetchException {
        super(scope.getLock(), startBound, inclusiveStart, endBound, inclusiveEnd, maxPrefix, reverse);
        this.mScope = scope;
        this.mStorage = storage;
        scope.register(storage.getStorableType(), this);
    }

    void open() throws FetchException {
        try {
            this.cursor_open(this.mScope.getTxn(), this.mScope.getIsolationLevel());
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FetchException {
        try {
            super.close();
        }
        finally {
            this.mScope.unregister(this.mStorage.getStorableType(), this);
        }
    }

    @Override
    protected void release() throws FetchException {
        try {
            this.cursor_close();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected byte[] getCurrentKey() throws FetchException {
        if (this.searchKey_getPartial()) {
            throw new IllegalStateException();
        }
        return this.searchKey_getDataCopy();
    }

    @Override
    protected byte[] getCurrentValue() throws FetchException {
        if (this.data_getPartial()) {
            throw new IllegalStateException();
        }
        return this.data_getDataCopy();
    }

    @Override
    protected void disableKeyAndValue() {
        this.searchKey_setPartial(true);
        this.data_setPartial(true);
    }

    @Override
    protected void disableValue() {
        this.data_setPartial(true);
    }

    @Override
    protected void enableKeyAndValue() throws FetchException {
        this.searchKey_setPartial(false);
        this.data_setPartial(false);
        if (!this.hasCurrent()) {
            throw new FetchException("Current key and value missing");
        }
    }

    protected boolean hasCurrent() throws FetchException {
        try {
            return this.cursor_getCurrent();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected S instantiateCurrent() throws FetchException {
        return this.mStorage.instantiate(this.primaryKey_getData(), this.data_getData());
    }

    @Override
    protected boolean toFirst() throws FetchException {
        try {
            return this.cursor_getFirst();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected boolean toFirst(byte[] key) throws FetchException {
        try {
            this.searchKey_setData(key);
            return this.cursor_getSearchKeyRange();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected boolean toLast() throws FetchException {
        try {
            return this.cursor_getLast();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected boolean toLast(byte[] key) throws FetchException {
        try {
            if (!RawUtil.increment(key)) {
                return this.cursor_getLast();
            }
            this.searchKey_setData(key);
            if (this.cursor_getSearchKeyRange() ? !this.cursor_getPrev() : !this.cursor_getLast()) {
                return false;
            }
            key = this.searchKey_getData();
            do {
                if (this.compareKeysPartially(this.searchKey_getData(), key) > 0) continue;
                return true;
            } while (this.cursor_getPrevNoDup());
            return false;
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected boolean toNext() throws FetchException {
        try {
            return this.cursor_getNext();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    @Override
    protected boolean toPrevious() throws FetchException {
        try {
            return this.cursor_getPrev();
        }
        catch (Exception e) {
            throw this.mStorage.toFetchException(e);
        }
    }

    protected static byte[] getData(byte[] data, int size) {
        if (data == null) {
            return NO_DATA;
        }
        if (data.length <= size) {
            return data;
        }
        byte[] newData = new byte[size];
        System.arraycopy(data, 0, newData, 0, size);
        return newData;
    }

    protected static byte[] getDataCopy(byte[] data, int size) {
        if (data == null) {
            return NO_DATA;
        }
        byte[] newData = new byte[size];
        System.arraycopy(data, 0, newData, 0, size);
        return newData;
    }

    @Override
    protected void handleNoSuchElement() throws FetchException {
        this.mStorage.checkClosed();
    }

    protected abstract byte[] searchKey_getData();

    protected abstract byte[] searchKey_getDataCopy();

    protected abstract void searchKey_setData(byte[] var1);

    protected abstract void searchKey_setPartial(boolean var1);

    protected abstract boolean searchKey_getPartial();

    protected abstract byte[] data_getData();

    protected abstract byte[] data_getDataCopy();

    protected abstract void data_setPartial(boolean var1);

    protected abstract boolean data_getPartial();

    protected abstract byte[] primaryKey_getData();

    protected abstract void cursor_open(Txn var1, IsolationLevel var2) throws Exception;

    protected abstract void cursor_close() throws Exception;

    protected abstract boolean cursor_getCurrent() throws Exception;

    protected abstract boolean cursor_getFirst() throws Exception;

    protected abstract boolean cursor_getLast() throws Exception;

    protected abstract boolean cursor_getSearchKeyRange() throws Exception;

    protected abstract boolean cursor_getNext() throws Exception;

    protected abstract boolean cursor_getNextDup() throws Exception;

    protected abstract boolean cursor_getPrev() throws Exception;

    protected abstract boolean cursor_getPrevNoDup() throws Exception;
}

