/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.replicated;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.lob.AbstractClob;
import com.amazon.carbonado.lob.Clob;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClobReplicationTrigger<S extends Storable>
extends Trigger<S> {
    private final Storage<S> mMasterStorage;
    private final String[] mClobNames;

    static <S extends Storable> ClobReplicationTrigger<S> create(Storage<S> masterStorage) {
        Map<String, StorableProperty<S>> properties = StorableIntrospector.examine(masterStorage.getStorableType()).getDataProperties();
        ArrayList<String> clobNames = new ArrayList<String>(2);
        for (StorableProperty<S> property : properties.values()) {
            if (property.getType() != Clob.class) continue;
            clobNames.add(property.getName());
        }
        if (clobNames.size() == 0) {
            return null;
        }
        return new ClobReplicationTrigger<S>(masterStorage, clobNames.toArray(new String[clobNames.size()]));
    }

    private ClobReplicationTrigger(Storage<S> masterStorage, String[] clobNames) {
        this.mMasterStorage = masterStorage;
        this.mClobNames = clobNames;
    }

    @Override
    public void afterInsert(S replica, Object state) {
        this.afterLoad(replica);
    }

    @Override
    public void afterUpdate(S replica, Object state) {
        this.afterLoad(replica);
    }

    @Override
    public void afterLoad(S replica) {
        for (String name : this.mClobNames) {
            Clob replicaClob;
            if (!replica.isPropertySupported(name) || (replicaClob = (Clob)replica.getPropertyValue(name)) == null || replicaClob instanceof Replicated && ((Replicated)replicaClob).parent() == this) continue;
            Replicated clob = new Replicated(this, name, replica, replicaClob);
            replica.setPropertyValue(name, clob);
        }
        replica.markAllPropertiesClean();
    }

    private static class Copier
    extends Writer {
        private final Writer mReplicaOut;
        private final Writer mMasterOut;

        Copier(Writer master, Writer replica) {
            this.mMasterOut = master;
            this.mReplicaOut = replica;
        }

        public void write(int c) throws IOException {
            this.mMasterOut.write(c);
            this.mReplicaOut.write(c);
        }

        public void write(char[] c, int off, int len) throws IOException {
            this.mMasterOut.write(c, off, len);
            this.mReplicaOut.write(c, off, len);
        }

        public void flush() throws IOException {
            this.mMasterOut.flush();
            this.mReplicaOut.flush();
        }

        public void close() throws IOException {
            this.mMasterOut.close();
            this.mReplicaOut.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Replicated
    extends AbstractClob {
        private static final int DEFAULT_BUFFER_SIZE = 4000;
        private final String mClobName;
        private final S mReplica;
        private final Clob mReplicaClob;
        private Clob mMasterClob;
        private boolean mMasterClobLoaded;
        final /* synthetic */ ClobReplicationTrigger this$0;

        Replicated(String clobName, S replica, Clob replicaClob) {
            this.this$0 = var1_1;
            this.mClobName = clobName;
            this.mReplica = replica;
            this.mReplicaClob = replicaClob;
        }

        @Override
        public Reader openReader() throws FetchException {
            return this.mReplicaClob.openReader();
        }

        @Override
        public Reader openReader(long pos) throws FetchException {
            return this.mReplicaClob.openReader(pos);
        }

        @Override
        public Reader openReader(long pos, int bufferSize) throws FetchException {
            return this.mReplicaClob.openReader(pos, bufferSize);
        }

        @Override
        public long getLength() throws FetchException {
            return this.mReplicaClob.getLength();
        }

        @Override
        public String asString() throws FetchException {
            return this.mReplicaClob.asString();
        }

        @Override
        public Writer openWriter() throws PersistException {
            Clob masterClob = this.masterClob();
            if (masterClob == null) {
                return this.mReplicaClob.openWriter();
            }
            return this.openWriter(masterClob, 0L, 4000);
        }

        @Override
        public Writer openWriter(long pos) throws PersistException {
            Clob masterClob = this.masterClob();
            if (masterClob == null) {
                return this.mReplicaClob.openWriter(pos);
            }
            return this.openWriter(masterClob, pos, 4000);
        }

        @Override
        public Writer openWriter(long pos, int bufferSize) throws PersistException {
            Clob masterClob = this.masterClob();
            if (masterClob == null) {
                return this.mReplicaClob.openWriter(pos, bufferSize);
            }
            return this.openWriter(masterClob, pos, bufferSize);
        }

        private Writer openWriter(Clob masterClob, long pos, int bufferSize) throws PersistException {
            if (bufferSize < 4000) {
                bufferSize = 4000;
            }
            Writer masterOut = masterClob.openWriter(pos, 0);
            Writer replicaOut = this.mReplicaClob.openWriter(pos, 0);
            return new BufferedWriter(new Copier(masterOut, replicaOut), bufferSize);
        }

        @Override
        public void setLength(long length) throws PersistException {
            Clob masterClob = this.masterClob();
            if (masterClob != null) {
                masterClob.setLength(length);
            }
            this.mReplicaClob.setLength(length);
        }

        @Override
        public Object getLocator() {
            return this.mReplicaClob.getLocator();
        }

        @Override
        public int hashCode() {
            return this.mReplicaClob.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Replicated) {
                Replicated other = (Replicated)obj;
                return this.parent() == other.parent() && this.mReplicaClob.equals(other.mReplicaClob);
            }
            return false;
        }

        @Override
        public String toString() {
            Object locator = this.getLocator();
            return locator == null ? super.toString() : "ReplicatedClob@" + locator;
        }

        ClobReplicationTrigger parent() {
            return this.this$0;
        }

        private Clob masterClob() throws PersistException {
            Clob masterClob = this.mMasterClob;
            if (this.mMasterClobLoaded) {
                return masterClob;
            }
            Object master = this.this$0.mMasterStorage.prepare();
            this.mReplica.copyPrimaryKeyProperties(master);
            try {
                master.load();
                if (master.isPropertySupported(this.mClobName) && (masterClob = (Clob)master.getPropertyValue(this.mClobName)) == null) {
                    throw new PersistNoneException("Master Clob is null: " + this.mClobName);
                }
                this.mMasterClob = masterClob;
                this.mMasterClobLoaded = true;
                return masterClob;
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
        }
    }
}

