/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.logging;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.capability.Capability;
import com.amazon.carbonado.repo.logging.Log;
import com.amazon.carbonado.repo.logging.LogAccessCapability;
import com.amazon.carbonado.repo.logging.LoggingStorage;
import com.amazon.carbonado.repo.logging.LoggingTransaction;
import com.amazon.carbonado.spi.StoragePool;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggingRepository
implements Repository,
LogAccessCapability {
    private final AtomicReference<Repository> mRootRef;
    private final Repository mRepo;
    private final Log mLog;
    private final StoragePool mStoragePool;
    private final ThreadLocal<LoggingTransaction> mActiveTxn = new ThreadLocal();

    LoggingRepository(AtomicReference<Repository> rootRef, Repository actual, Log log) {
        this.mRootRef = rootRef;
        this.mRepo = actual;
        this.mLog = log;
        this.mStoragePool = new StoragePool(){

            @Override
            protected <S extends Storable> Storage<S> createStorage(Class<S> type) throws RepositoryException {
                return new LoggingStorage<S>(LoggingRepository.this, LoggingRepository.this.mRepo.storageFor(type));
            }
        };
    }

    @Override
    public String getName() {
        return this.mRepo.getName();
    }

    @Override
    public <S extends Storable> Storage<S> storageFor(Class<S> type) throws SupportException, RepositoryException {
        return (Storage)this.mStoragePool.get(type);
    }

    @Override
    public Transaction enterTransaction() {
        this.mLog.write("Repository.enterTransaction()");
        return new LoggingTransaction(this.mActiveTxn, this.mLog, this.mRepo.enterTransaction(), false);
    }

    @Override
    public Transaction enterTransaction(IsolationLevel level) {
        if (this.mLog.isEnabled()) {
            this.mLog.write("Repository.enterTransaction(" + (Object)((Object)level) + ')');
        }
        return new LoggingTransaction(this.mActiveTxn, this.mLog, this.mRepo.enterTransaction(level), false);
    }

    @Override
    public Transaction enterTopTransaction(IsolationLevel level) {
        if (this.mLog.isEnabled()) {
            this.mLog.write("Repository.enterTopTransaction(" + (Object)((Object)level) + ')');
        }
        return new LoggingTransaction(this.mActiveTxn, this.mLog, this.mRepo.enterTopTransaction(level), true);
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        return this.mRepo.getTransactionIsolationLevel();
    }

    @Override
    public <C extends Capability> C getCapability(Class<C> capabilityType) {
        if (capabilityType.isInstance(this)) {
            return (C)this;
        }
        return this.mRepo.getCapability(capabilityType);
    }

    @Override
    public void close() {
        this.mRepo.close();
    }

    @Override
    public Log getLog() {
        return this.mLog;
    }

    Repository getRootRepository() {
        return this.mRootRef.get();
    }
}

