/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.repo.jdbc.JDBCClob;
import com.amazon.carbonado.repo.jdbc.JDBCClobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.OracleSupportStrategy;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;

class OracleClob
extends JDBCClob {
    OracleClob(JDBCRepository repo, Clob clob, JDBCClobLoader loader) {
        super(repo, clob, loader);
    }

    public Reader openReader() throws FetchException {
        return this.openReader(0L);
    }

    public Reader openReader(long pos) throws FetchException {
        Method m = this.support().mCLOB_getCharacterStream;
        if (m == null) {
            return super.openReader(pos);
        }
        try {
            return (Reader)m.invoke((Object)this.getInternalClobForFetch(), pos);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toFetchException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public Reader openReader(long pos, int bufferSize) throws FetchException {
        return this.openReader(pos);
    }

    public long getLength() throws FetchException {
        Method m = this.support().mCLOB_length;
        if (m == null) {
            return super.getLength();
        }
        try {
            return (Long)m.invoke((Object)this.getInternalClobForFetch(), new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toFetchException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public Writer openWriter() throws PersistException {
        return this.openWriter(0L);
    }

    public Writer openWriter(long pos) throws PersistException {
        Method m = this.support().mCLOB_getCharacterOutputStream;
        if (m == null) {
            return super.openWriter(pos);
        }
        try {
            return (Writer)m.invoke((Object)this.getInternalClobForPersist(), pos);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toPersistException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public Writer openWriter(long pos, int bufferSize) throws PersistException {
        return this.openWriter(pos);
    }

    public void setLength(long length) throws PersistException {
        Method m = this.support().mCLOB_trim;
        if (m == null) {
            super.setLength(length);
            return;
        }
        try {
            m.invoke((Object)this.getInternalClobForPersist(), length);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toPersistException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    private OracleSupportStrategy support() {
        return (OracleSupportStrategy)this.mRepo.getSupportStrategy();
    }
}

