/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.SQLStatementBuilder;
import com.amazon.carbonado.repo.jdbc.TableAliasGenerator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JoinNode {
    private final JDBCStorableProperty<?> mProperty;
    private final boolean mOuterJoin;
    private final JDBCStorableInfo<?> mInfo;
    private final String mAlias;
    private final Map<SubNodeKey, JoinNode> mSubNodes;
    private boolean mAliasRequired;

    JoinNode(JDBCStorableInfo<?> info, String alias) {
        this(null, false, info, alias);
    }

    private JoinNode(JDBCStorableProperty<?> property, boolean outerJoin, JDBCStorableInfo<?> info, String alias) {
        this.mProperty = property;
        this.mOuterJoin = outerJoin;
        this.mInfo = info;
        this.mAlias = alias;
        this.mSubNodes = new LinkedHashMap<SubNodeKey, JoinNode>();
    }

    public String getAlias() {
        return this.mAlias;
    }

    public String findAliasFor(ChainedProperty<?> chained) {
        return this.findAliasFor(chained, 0);
    }

    private String findAliasFor(ChainedProperty<?> chained, int offset) {
        if (chained.getChainCount() - offset <= 0) {
            return this.mAlias;
        }
        StorableProperty<?> property = offset == 0 ? chained.getPrimeProperty() : chained.getChainedProperty(offset - 1);
        boolean outerJoin = chained.isOuterJoin(offset);
        SubNodeKey key = new SubNodeKey(property.getName(), outerJoin);
        JoinNode subNode = this.mSubNodes.get(key);
        if (subNode != null) {
            return subNode.findAliasFor(chained, offset + 1);
        }
        return null;
    }

    public boolean isAliasRequired() {
        return this.mAliasRequired || this.mSubNodes.size() > 0;
    }

    public void appendTableNameTo(SQLStatementBuilder fromClause) {
        fromClause.append(' ');
        fromClause.append(this.mInfo.getQualifiedTableName());
    }

    public void appendTableNameAndAliasTo(SQLStatementBuilder fromClause) {
        this.appendTableNameTo(fromClause);
        fromClause.append(' ');
        fromClause.append(this.mAlias);
    }

    public void appendFullJoinTo(SQLStatementBuilder fromClause) {
        this.appendTableNameAndAliasTo(fromClause);
        this.appendTailJoinTo(fromClause);
    }

    private void appendTailJoinTo(SQLStatementBuilder fromClause) {
        for (JoinNode jn : this.mSubNodes.values()) {
            if (jn.mOuterJoin) {
                fromClause.append(" LEFT OUTER JOIN");
            } else {
                fromClause.append(" INNER JOIN");
            }
            jn.appendTableNameAndAliasTo(fromClause);
            fromClause.append(" ON ");
            int count = jn.mProperty.getJoinElementCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    fromClause.append(" AND ");
                }
                fromClause.append(this.mAlias);
                fromClause.append('.');
                fromClause.append(jn.mProperty.getInternalJoinElement(i).getColumnName());
                fromClause.append('=');
                fromClause.append(jn.mAlias);
                fromClause.append('.');
                fromClause.append(jn.mProperty.getExternalJoinElement(i).getColumnName());
            }
            jn.appendTailJoinTo(fromClause);
        }
    }

    public void addJoin(JDBCRepository repository, ChainedProperty<?> chained, TableAliasGenerator aliasGenerator) throws RepositoryException {
        this.addJoin(repository, chained, aliasGenerator, 0);
    }

    private void addJoin(JDBCRepository repository, ChainedProperty<?> chained, TableAliasGenerator aliasGenerator, int offset) throws RepositoryException {
        if (chained.getChainCount() - offset <= 0) {
            return;
        }
        StorableProperty<?> property = offset == 0 ? chained.getPrimeProperty() : chained.getChainedProperty(offset - 1);
        boolean outerJoin = chained.isOuterJoin(offset);
        SubNodeKey key = new SubNodeKey(property.getName(), outerJoin);
        JoinNode subNode = this.mSubNodes.get(key);
        if (subNode == null) {
            JDBCStorableInfo<Storable> info = repository.examineStorable(property.getJoinedType());
            JDBCStorableProperty<?> jProperty = repository.getJDBCStorableProperty(property);
            subNode = new JoinNode(jProperty, outerJoin, info, aliasGenerator.nextAlias());
            this.mSubNodes.put(key, subNode);
        }
        subNode.addJoin(repository, chained, aliasGenerator, offset + 1);
    }

    public void aliasIsRequired() {
        this.mAliasRequired = true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{table=");
        b.append(this.mInfo.getQualifiedTableName());
        b.append(", alias=");
        b.append(this.mAlias);
        if (this.mSubNodes.size() > 0) {
            b.append(", subNodes=");
            b.append(this.mSubNodes);
        }
        b.append('}');
        return b.toString();
    }

    private static class SubNodeKey {
        final String mPropertyName;
        final boolean mOuterJoin;

        SubNodeKey(String propertyName, boolean outerJoin) {
            this.mPropertyName = propertyName;
            this.mOuterJoin = outerJoin;
        }

        public int hashCode() {
            return this.mPropertyName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SubNodeKey) {
                SubNodeKey other = (SubNodeKey)obj;
                return this.mPropertyName.equals(other.mPropertyName) && this.mOuterJoin == other.mOuterJoin;
            }
            return false;
        }

        public String toString() {
            return "propertyName=" + this.mPropertyName + ", outerJoin=" + this.mOuterJoin;
        }
    }
}

