/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.sequence.AbstractSequenceValueProducer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

class JDBCSequenceValueProducer
extends AbstractSequenceValueProducer {
    private final JDBCRepository mRepo;
    private final String mQuery;

    JDBCSequenceValueProducer(JDBCRepository repo, String sequenceQuery) {
        this.mRepo = repo;
        this.mQuery = sequenceQuery;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long nextLongValue() throws PersistException {
        try {
            Connection con = this.mRepo.getConnection();
            try {
                Statement st = con.createStatement();
                try {
                    ResultSet rs = st.executeQuery(this.mQuery);
                    try {
                        if (!rs.next()) throw new PersistException("No results from sequence query: " + this.mQuery);
                        long l = rs.getLong(1);
                        return l;
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    st.close();
                }
            }
            finally {
                this.mRepo.yieldConnection(con);
            }
        }
        catch (Exception e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public boolean returnReservedValues() {
        return false;
    }
}

