/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceAccess;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceBuilder;
import com.amazon.carbonado.util.SoftValuedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexEntryGenerator<S extends Storable> {
    private static final SoftValuedCache<StorableIndex, SyntheticStorableReferenceAccess> cCache = SoftValuedCache.newCache(11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> SyntheticStorableReferenceAccess<S> getIndexAccess(StorableIndex<S> index) throws SupportException {
        index = index.clustered(false);
        SoftValuedCache<StorableIndex, SyntheticStorableReferenceAccess> softValuedCache = cCache;
        synchronized (softValuedCache) {
            SyntheticStorableReferenceAccess<S> access = cCache.get(index);
            if (access != null) {
                return access;
            }
            Class<S> type = index.getProperty(0).getEnclosingType();
            SyntheticStorableReferenceBuilder<S> builder = new SyntheticStorableReferenceBuilder<S>(type, index.isUnique());
            for (int i = 0; i < index.getPropertyCount(); ++i) {
                StorableProperty<S> source = index.getProperty(i);
                builder.addKeyProperty(source.getName(), index.getPropertyDirection(i));
            }
            builder.build();
            access = builder.getReferenceAccess();
            cCache.put(index, access);
            return access;
        }
    }

    private IndexEntryGenerator() {
    }
}

