/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RawCursor<S>
extends AbstractCursor<S> {
    private static final byte UNINITIALIZED = 0;
    private static final byte CLOSED = 1;
    private static final byte TRY_NEXT = 2;
    private static final byte HAS_NEXT = 3;
    protected final Lock mLock;
    private final byte[] mStartBound;
    private final boolean mInclusiveStart;
    private final byte[] mEndBound;
    private final boolean mInclusiveEnd;
    private final int mPrefixLength;
    private final boolean mReverse;
    private byte mState;

    protected RawCursor(Lock lock, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse) {
        Lock lock2 = this.mLock = lock == null ? new ReentrantLock() : lock;
        if (startBound == null && !inclusiveStart || endBound == null && !inclusiveEnd) {
            throw new IllegalArgumentException();
        }
        this.mStartBound = startBound;
        this.mInclusiveStart = inclusiveStart;
        this.mEndBound = endBound;
        this.mInclusiveEnd = inclusiveEnd;
        this.mReverse = reverse;
        if (maxPrefix <= 0 || startBound == null && endBound == null) {
            this.mPrefixLength = 0;
        } else {
            int i;
            int len = Math.min(maxPrefix, Math.min(startBound == null ? 0 : startBound.length, endBound == null ? 0 : endBound.length));
            for (i = 0; i < len && startBound[i] == endBound[i]; ++i) {
            }
            this.mPrefixLength = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FetchException {
        this.mLock.lock();
        try {
            if (this.mState != 1) {
                this.release();
                this.mState = 1;
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() throws FetchException {
        block16: {
            this.mLock.lock();
            try {
                switch (this.mState) {
                    case 0: {
                        if (this.mReverse ? this.toBoundedLast() : this.toBoundedFirst()) {
                            this.mState = (byte)3;
                            boolean bl = true;
                            return bl;
                        }
                        this.mState = (byte)2;
                        break;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                    case 2: {
                        if (!(this.mReverse ? this.toBoundedPrevious() : this.toBoundedNext())) break;
                        this.mState = (byte)3;
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (FetchException e) {
                try {
                    this.close();
                }
                catch (FetchException fetchException) {
                    // empty catch block
                }
                throw e;
            }
            {
                this.close();
                break block16;
            }
            finally {
                this.mLock.unlock();
            }
        }
        return false;
    }

    @Override
    public S next() throws FetchException, NoSuchElementException {
        this.mLock.lock();
        try {
            S s;
            if (!this.hasNext()) {
                this.handleNoSuchElement();
                throw new NoSuchElementException();
            }
            try {
                S obj = this.instantiateCurrent();
                this.mState = (byte)2;
                s = obj;
            }
            catch (FetchException e) {
                try {
                    this.close();
                }
                catch (FetchException fetchException) {
                    // empty catch block
                }
                throw e;
            }
            return s;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        this.mLock.lock();
        try {
            int actual = 0;
            if (this.hasNext()) {
                int n;
                try {
                    n = this.mReverse ? this.toBoundedPrevious(amount) : this.toBoundedNext(amount);
                }
                catch (FetchException e) {
                    try {
                        this.close();
                    }
                    catch (FetchException e2) {
                        // empty catch block
                    }
                    throw e;
                }
                if ((actual += n) >= amount) {
                    int n2 = actual;
                    return n2;
                }
                this.mState = (byte)2;
                ++actual;
            }
            this.close();
            int n = actual;
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    protected abstract void release() throws FetchException;

    protected abstract byte[] getCurrentKey() throws FetchException;

    protected abstract byte[] getCurrentValue() throws FetchException;

    protected void disableKeyAndValue() {
    }

    protected void disableValue() {
    }

    protected void enableKeyAndValue() throws FetchException {
    }

    protected abstract S instantiateCurrent() throws FetchException;

    protected abstract boolean toFirst() throws FetchException;

    protected abstract boolean toFirst(byte[] var1) throws FetchException;

    protected abstract boolean toLast() throws FetchException;

    protected abstract boolean toLast(byte[] var1) throws FetchException;

    protected abstract boolean toNext() throws FetchException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int toNext(int amount) throws FetchException {
        if (amount <= 1) {
            return amount <= 0 ? 0 : (this.toNext() ? 1 : 0);
        }
        int count = 0;
        this.disableKeyAndValue();
        try {
            while (amount > 0 && this.toNext()) {
                ++count;
                --amount;
            }
        }
        finally {
            this.enableKeyAndValue();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean toNextKey() throws FetchException {
        block7: {
            byte[] initialKey = this.getCurrentKey();
            if (initialKey == null) {
                return false;
            }
            this.disableValue();
            try {
                while (this.toNext()) {
                    byte[] currentKey = this.getCurrentKey();
                    if (currentKey == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.compareKeysPartially(currentKey, initialKey) <= 0) continue;
                    break block7;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.enableKeyAndValue();
            }
        }
        return true;
    }

    protected abstract boolean toPrevious() throws FetchException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int toPrevious(int amount) throws FetchException {
        if (amount <= 1) {
            return amount <= 0 ? 0 : (this.toPrevious() ? 1 : 0);
        }
        int count = 0;
        this.disableKeyAndValue();
        try {
            while (amount > 0 && this.toPrevious()) {
                ++count;
                --amount;
            }
        }
        finally {
            this.enableKeyAndValue();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean toPreviousKey() throws FetchException {
        block7: {
            byte[] initialKey = this.getCurrentKey();
            if (initialKey == null) {
                return false;
            }
            this.disableValue();
            try {
                while (this.toPrevious()) {
                    byte[] currentKey = this.getCurrentKey();
                    if (currentKey == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.compareKeysPartially(this.getCurrentKey(), initialKey) >= 0) continue;
                    break block7;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.enableKeyAndValue();
            }
        }
        return true;
    }

    protected int compareKeysPartially(byte[] key1, byte[] key2) {
        int length = Math.min(key1.length, key2.length);
        for (int i = 0; i < length; ++i) {
            byte a1 = key1[i];
            byte a2 = key2[i];
            if (a1 == a2) continue;
            return (a1 & 0xFF) - (a2 & 0xFF);
        }
        return 0;
    }

    protected void handleNoSuchElement() throws FetchException {
    }

    private boolean prefixMatches() throws FetchException {
        int prefixLen = this.mPrefixLength;
        if (prefixLen > 0) {
            byte[] prefix = this.mStartBound;
            byte[] key = this.getCurrentKey();
            if (key == null) {
                return false;
            }
            for (int i = 0; i < prefixLen; ++i) {
                if (prefix[i] == key[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean toBoundedFirst() throws FetchException {
        byte[] currentKey;
        if (this.mStartBound == null) {
            if (!this.toFirst()) {
                return false;
            }
        } else {
            if (!this.toFirst((byte[])this.mStartBound.clone())) {
                return false;
            }
            if (!this.mInclusiveStart) {
                currentKey = this.getCurrentKey();
                if (currentKey == null) {
                    return false;
                }
                if (this.compareKeysPartially(this.mStartBound, currentKey) == 0 && !this.toNextKey()) {
                    return false;
                }
            }
        }
        if (this.mEndBound != null) {
            currentKey = this.getCurrentKey();
            if (currentKey == null) {
                return false;
            }
            int result = this.compareKeysPartially(currentKey, this.mEndBound);
            if (!(result < 0 || result <= 0 && this.mInclusiveEnd)) {
                return false;
            }
        }
        return this.prefixMatches();
    }

    private boolean toBoundedLast() throws FetchException {
        byte[] currentKey;
        if (this.mEndBound == null) {
            if (!this.toLast()) {
                return false;
            }
        } else {
            if (!this.toLast((byte[])this.mEndBound.clone())) {
                return false;
            }
            if (!this.mInclusiveEnd) {
                currentKey = this.getCurrentKey();
                if (currentKey == null) {
                    return false;
                }
                if (this.compareKeysPartially(this.mEndBound, currentKey) == 0 && !this.toPreviousKey()) {
                    return false;
                }
            }
        }
        if (this.mStartBound != null) {
            currentKey = this.getCurrentKey();
            if (currentKey == null) {
                return false;
            }
            int result = this.compareKeysPartially(currentKey, this.mStartBound);
            if (!(result > 0 || result >= 0 && this.mInclusiveStart)) {
                return false;
            }
        }
        return this.prefixMatches();
    }

    private boolean toBoundedNext() throws FetchException {
        if (!this.toNext()) {
            return false;
        }
        if (this.mEndBound != null) {
            byte[] currentKey = this.getCurrentKey();
            if (currentKey == null) {
                return false;
            }
            int result = this.compareKeysPartially(currentKey, this.mEndBound);
            if (!(result < 0 || result <= 0 && this.mInclusiveEnd)) {
                return false;
            }
        }
        return this.prefixMatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int toBoundedNext(int amount) throws FetchException {
        if (this.mEndBound == null) {
            return this.toNext(amount);
        }
        int count = 0;
        this.disableValue();
        try {
            while (amount > 0) {
                if (!this.toNext()) {
                    break;
                }
                byte[] currentKey = this.getCurrentKey();
                if (currentKey == null) {
                    break;
                }
                int result = this.compareKeysPartially(currentKey, this.mEndBound);
                if (result >= 0) {
                    if (result > 0) break;
                    if (!this.mInclusiveEnd) {
                        break;
                    }
                }
                if (!this.prefixMatches()) {
                    break;
                }
                ++count;
                --amount;
            }
        }
        finally {
            this.enableKeyAndValue();
        }
        return count;
    }

    private boolean toBoundedPrevious() throws FetchException {
        if (!this.toPrevious()) {
            return false;
        }
        if (this.mStartBound != null) {
            byte[] currentKey = this.getCurrentKey();
            if (currentKey == null) {
                return false;
            }
            int result = this.compareKeysPartially(currentKey, this.mStartBound);
            if (!(result > 0 || result >= 0 && this.mInclusiveStart)) {
                this.toBoundedFirst();
                return false;
            }
        }
        return this.prefixMatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int toBoundedPrevious(int amount) throws FetchException {
        if (this.mStartBound == null) {
            return this.toPrevious(amount);
        }
        int count = 0;
        this.disableValue();
        try {
            while (amount > 0) {
                if (!this.toPrevious()) {
                    break;
                }
                byte[] currentKey = this.getCurrentKey();
                if (currentKey == null) {
                    break;
                }
                int result = this.compareKeysPartially(currentKey, this.mStartBound);
                if (!(result > 0 || result >= 0 && this.mInclusiveStart)) {
                    this.toBoundedFirst();
                    break;
                }
                if (!this.prefixMatches()) {
                    break;
                }
                ++count;
                --amount;
            }
        }
        finally {
            this.enableKeyAndValue();
        }
        return count;
    }
}

