/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.raw.EncodingConstants;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DataDecoder {
    public static int decodeInt(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            int value = src[srcOffset] << 24 | (src[srcOffset + 1] & 0xFF) << 16 | (src[srcOffset + 2] & 0xFF) << 8 | src[srcOffset + 3] & 0xFF;
            return value ^ Integer.MIN_VALUE;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Integer decodeIntegerObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return DataDecoder.decodeInt(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static long decodeLong(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return ((long)(src[srcOffset] << 24 | (src[srcOffset + 1] & 0xFF) << 16 | (src[srcOffset + 2] & 0xFF) << 8 | src[srcOffset + 3] & 0xFF) ^ Integer.MIN_VALUE) << 32 | (long)(src[srcOffset + 4] << 24 | (src[srcOffset + 5] & 0xFF) << 16 | (src[srcOffset + 6] & 0xFF) << 8 | src[srcOffset + 7] & 0xFF) & 0xFFFFFFFFL;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Long decodeLongObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return DataDecoder.decodeLong(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static byte decodeByte(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (byte)(src[srcOffset] ^ 0x80);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Byte decodeByteObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return DataDecoder.decodeByte(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static short decodeShort(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (short)((src[srcOffset] << 8 | src[srcOffset + 1] & 0xFF) ^ 0x8000);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Short decodeShortObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return DataDecoder.decodeShort(src, srcOffset + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static char decodeChar(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (char)(src[srcOffset] << 8 | src[srcOffset + 1] & 0xFF);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Character decodeCharacterObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return Character.valueOf(DataDecoder.decodeChar(src, srcOffset + 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static boolean decodeBoolean(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return src[srcOffset] == -128;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static Boolean decodeBooleanObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            switch (src[srcOffset]) {
                case -1: 
                case 0: {
                    return null;
                }
                case -128: {
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static float decodeFloat(byte[] src, int srcOffset) throws CorruptEncodingException {
        int bits;
        return Float.intBitsToFloat(bits ^= (bits = DataDecoder.decodeFloatBits(src, srcOffset)) < 0 ? Integer.MIN_VALUE : -1);
    }

    public static Float decodeFloatObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        int bits;
        return (bits ^= (bits = DataDecoder.decodeFloatBits(src, srcOffset)) < 0 ? Integer.MIN_VALUE : -1) == Integer.MAX_VALUE ? null : Float.valueOf(Float.intBitsToFloat(bits));
    }

    protected static int decodeFloatBits(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return src[srcOffset] << 24 | (src[srcOffset + 1] & 0xFF) << 16 | (src[srcOffset + 2] & 0xFF) << 8 | src[srcOffset + 3] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static double decodeDouble(byte[] src, int srcOffset) throws CorruptEncodingException {
        long bits;
        return Double.longBitsToDouble(bits ^= (bits = DataDecoder.decodeDoubleBits(src, srcOffset)) < 0L ? Long.MIN_VALUE : -1L);
    }

    public static Double decodeDoubleObj(byte[] src, int srcOffset) throws CorruptEncodingException {
        long bits;
        return (bits ^= (bits = DataDecoder.decodeDoubleBits(src, srcOffset)) < 0L ? Long.MIN_VALUE : -1L) == Long.MAX_VALUE ? null : Double.valueOf(Double.longBitsToDouble(bits));
    }

    protected static long decodeDoubleBits(byte[] src, int srcOffset) throws CorruptEncodingException {
        try {
            return (long)(src[srcOffset] << 24 | (src[srcOffset + 1] & 0xFF) << 16 | (src[srcOffset + 2] & 0xFF) << 8 | src[srcOffset + 3] & 0xFF) << 32 | (long)(src[srcOffset + 4] << 24 | (src[srcOffset + 5] & 0xFF) << 16 | (src[srcOffset + 6] & 0xFF) << 8 | src[srcOffset + 7] & 0xFF) & 0xFFFFFFFFL;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static int decode(byte[] src, int srcOffset, BigInteger[] valueRef) throws CorruptEncodingException {
        byte[][] bytesRef = new byte[1][];
        int amt = DataDecoder.decode(src, srcOffset, bytesRef);
        valueRef[0] = bytesRef[0] == null ? null : new BigInteger(bytesRef[0]);
        return amt;
    }

    public static int decode(byte[] src, int srcOffset, BigDecimal[] valueRef) throws CorruptEncodingException {
        try {
            int originalOffset = srcOffset;
            int b = src[srcOffset++] & 0xFF;
            if (b >= 248) {
                valueRef[0] = null;
                return 1;
            }
            int scale = b <= 127 ? b : (b <= 191 ? (b & 0x3F) << 8 | src[srcOffset++] & 0xFF : (b <= 223 ? (b & 0x1F) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF : (b <= 239 ? (b & 0xF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF : (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF)));
            scale = (scale & 1) != 0 ? ~(scale >> 1) | Integer.MIN_VALUE : (scale >>>= 1);
            BigInteger[] unscaledRef = new BigInteger[1];
            int amt = DataDecoder.decode(src, srcOffset, unscaledRef);
            valueRef[0] = new BigDecimal(unscaledRef[0], scale);
            return srcOffset + amt - originalOffset;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static int decode(byte[] src, int srcOffset, byte[][] valueRef) throws CorruptEncodingException {
        try {
            int originalOffset = srcOffset;
            int b = src[srcOffset++] & 0xFF;
            if (b >= 248) {
                valueRef[0] = null;
                return 1;
            }
            int valueLength = b <= 127 ? b : (b <= 191 ? (b & 0x3F) << 8 | src[srcOffset++] & 0xFF : (b <= 223 ? (b & 0x1F) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF : (b <= 239 ? (b & 0xF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF : (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF)));
            if (valueLength == 0) {
                valueRef[0] = EncodingConstants.EMPTY_BYTE_ARRAY;
            } else {
                byte[] value = new byte[valueLength];
                System.arraycopy(src, srcOffset, value, 0, valueLength);
                valueRef[0] = value;
            }
            return srcOffset - originalOffset + valueLength;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static int decodeString(byte[] src, int srcOffset, String[] valueRef) throws CorruptEncodingException {
        try {
            char[] value;
            int originalOffset = srcOffset;
            int b = src[srcOffset++] & 0xFF;
            if (b >= 248) {
                valueRef[0] = null;
                return 1;
            }
            int valueLength = b <= 127 ? b : (b <= 191 ? (b & 0x3F) << 8 | src[srcOffset++] & 0xFF : (b <= 223 ? (b & 0x1F) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF : (b <= 239 ? (b & 0xF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF : (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF)));
            if (valueLength == 0) {
                valueRef[0] = "";
                return srcOffset - originalOffset;
            }
            try {
                value = new char[valueLength];
            }
            catch (NegativeArraySizeException e) {
                throw new CorruptEncodingException("Corrupt encoded string length (negative size): " + valueLength);
            }
            catch (OutOfMemoryError e) {
                throw new CorruptEncodingException("Corrupt encoded string length (too large): " + valueLength, e);
            }
            int valueOffset = 0;
            block10: while (valueOffset < valueLength) {
                int c = src[srcOffset++] & 0xFF;
                switch (c >> 5) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        value[valueOffset++] = (char)c;
                        continue block10;
                    }
                    case 4: 
                    case 5: {
                        value[valueOffset++] = (char)((c & 0x3F) << 8 | src[srcOffset++] & 0xFF);
                        continue block10;
                    }
                    case 6: {
                        c = (c & 0x1F) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
                        if (c >= 65536) {
                            value[valueOffset++] = (char)(0xD800 | (c -= 65536) >> 10 & 0x3FF);
                            value[valueOffset++] = (char)(0xDC00 | c & 0x3FF);
                            continue block10;
                        }
                        value[valueOffset++] = (char)c;
                        continue block10;
                    }
                }
                throw new CorruptEncodingException("Corrupt encoded string data (source offset = " + (srcOffset - 1) + ')');
            }
            valueRef[0] = new String(value);
            return srcOffset - originalOffset;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static int readLength(InputStream in) throws IOException, EOFException {
        int b0 = in.read();
        if (b0 < 0) {
            throw new EOFException();
        }
        if (b0 <= 127) {
            return b0;
        }
        int b1 = in.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        if (b0 <= 191) {
            return (b0 & 0x3F) << 8 | b1;
        }
        int b2 = in.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        if (b0 <= 223) {
            return (b0 & 0x1F) << 16 | b1 << 8 | b2;
        }
        int b3 = in.read();
        if (b3 < 0) {
            throw new EOFException();
        }
        if (b0 <= 239) {
            return (b0 & 0xF) << 24 | b1 << 16 | b2 << 8 | b3;
        }
        int b4 = in.read();
        if (b4 < 0) {
            throw new EOFException();
        }
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public static void readFully(InputStream in, byte[] b) throws IOException, EOFException {
        int amt;
        int length = b.length;
        for (int total = 0; total < length; total += amt) {
            amt = in.read(b, total, length - total);
            if (amt >= 0) continue;
            throw new EOFException();
        }
    }

    public static byte[] decodeSingle(byte[] src, int prefixPadding, int suffixPadding) throws CorruptEncodingException {
        try {
            int length = src.length - suffixPadding - prefixPadding;
            if (length == 0) {
                return EncodingConstants.EMPTY_BYTE_ARRAY;
            }
            if (prefixPadding <= 0 && suffixPadding <= 0) {
                return (byte[])src.clone();
            }
            byte[] dst = new byte[length];
            System.arraycopy(src, prefixPadding, dst, 0, length);
            return dst;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }

    public static byte[] decodeSingleNullable(byte[] src) throws CorruptEncodingException {
        return DataDecoder.decodeSingleNullable(src, 0, 0);
    }

    public static byte[] decodeSingleNullable(byte[] src, int prefixPadding, int suffixPadding) throws CorruptEncodingException {
        try {
            byte b = src[prefixPadding];
            if (b == -1 || b == 0) {
                return null;
            }
            int length = src.length - suffixPadding - 1 - prefixPadding;
            if (length == 0) {
                return EncodingConstants.EMPTY_BYTE_ARRAY;
            }
            byte[] value = new byte[length];
            System.arraycopy(src, 1 + prefixPadding, value, 0, length);
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptEncodingException(null, e);
        }
    }
}

