/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.AbstractQuery;
import com.amazon.carbonado.qe.EmptyQuery;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.qe.StandardQuery;
import com.amazon.carbonado.util.SoftValuedCache;
import java.util.ArrayList;
import java.util.Map;
import org.cojen.util.SoftValuedHashMap;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardQueryFactory<S extends Storable>
implements QueryFactory<S> {
    private final Class<S> mType;
    private final boolean mLazySetExecutor;
    private final SoftValuedCache<String, Query<S>> mStringToQuery;
    private final Map<Filter<S>, Map<OrderingList<S>, Query<S>>> mFilterToQuery;

    protected StandardQueryFactory(Class<S> type) {
        this(type, false);
    }

    protected StandardQueryFactory(Class<S> type, boolean lazySetExecutor) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.mType = type;
        this.mLazySetExecutor = lazySetExecutor;
        this.mStringToQuery = SoftValuedCache.newCache(7);
        this.mFilterToQuery = new WeakIdentityMap(7);
    }

    @Override
    public Class<S> getStorableType() {
        return this.mType;
    }

    public Query<S> query() throws FetchException {
        return this.query(Filter.getOpenFilter(this.mType), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query<S> query(String filter) throws FetchException {
        SoftValuedCache<String, Query<S>> softValuedCache = this.mStringToQuery;
        synchronized (softValuedCache) {
            Query<S> query = this.mStringToQuery.get(filter);
            if (query == null) {
                if (filter == null) {
                    throw new IllegalArgumentException("Query filter must not be null");
                }
                query = this.query(Filter.filterFor(this.mType, filter), null);
                this.mStringToQuery.put(filter, query);
            }
            return query;
        }
    }

    public Query<S> query(Filter<S> filter) throws FetchException {
        return this.query(filter, null);
    }

    public Query<S> query(Filter<S> filter, OrderingList<S> ordering) throws FetchException {
        return this.query(filter, ordering, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query<S> query(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws FetchException {
        AbstractQuery query;
        SoftValuedHashMap map;
        filter = filter.bind();
        Map<Filter<S>, Map<OrderingList<S>, Query<S>>> map2 = this.mFilterToQuery;
        synchronized (map2) {
            map = this.mFilterToQuery.get(filter);
            if (map == null) {
                if (filter == null) {
                    throw new IllegalArgumentException("Query filter must not be null");
                }
                map = new SoftValuedHashMap(7);
                this.mFilterToQuery.put(filter, (Map<OrderingList<S>, Query<S>>)map);
            }
        }
        SoftValuedHashMap softValuedHashMap = map;
        synchronized (softValuedHashMap) {
            query = (EmptyQuery<S>)map.get(ordering);
            if (query == null) {
                FilterValues<S> values = filter.initialFilterValues();
                if (values == null && filter.isClosed()) {
                    query = new EmptyQuery<S>(this, ordering);
                } else {
                    StandardQuery<S> standardQuery = this.createQuery(filter, values, ordering, hints);
                    if (!this.mLazySetExecutor) {
                        try {
                            standardQuery.setExecutor();
                        }
                        catch (RepositoryException e) {
                            throw e.toFetchException();
                        }
                    }
                    query = standardQuery;
                }
                map.put(ordering, query);
            }
        }
        return query;
    }

    public Query<S> query(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering) throws FetchException {
        return this.query(filter, values, ordering, null);
    }

    @Override
    public Query<S> query(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) throws FetchException {
        Query<S> query = this.query(filter != null ? filter : Filter.getOpenFilter(this.mType), ordering, hints);
        if (values != null) {
            query = query.withValues(values.getSuppliedValues());
        }
        return query;
    }

    public void setExecutors() throws RepositoryException {
        for (StandardQuery<S> query : this.gatherQueries()) {
            query.setExecutor();
        }
    }

    public void resetExecutors() throws RepositoryException {
        for (StandardQuery<S> query : this.gatherQueries()) {
            query.resetExecutor();
        }
    }

    public void clearExecutors() {
        for (StandardQuery<S> query : this.gatherQueries()) {
            query.clearExecutor();
        }
    }

    protected abstract StandardQuery<S> createQuery(Filter<S> var1, FilterValues<S> var2, OrderingList<S> var3, QueryHints var4) throws FetchException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<StandardQuery<S>> gatherQueries() {
        ArrayList<StandardQuery<S>> queries = new ArrayList<StandardQuery<S>>();
        Map<Filter<S>, Map<OrderingList<S>, Query<S>>> map = this.mFilterToQuery;
        synchronized (map) {
            for (Map<OrderingList<S>, Query<S>> map2 : this.mFilterToQuery.values()) {
                for (Query<S> query : map2.values()) {
                    if (!(query instanceof StandardQuery)) continue;
                    queries.add((StandardQuery)query);
                }
            }
        }
        return queries;
    }
}

