/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.CompositeScore;
import com.amazon.carbonado.qe.DelegatedQueryExecutor;
import com.amazon.carbonado.qe.FilteredQueryExecutor;
import com.amazon.carbonado.qe.FilteringScore;
import com.amazon.carbonado.qe.FullScanQueryExecutor;
import com.amazon.carbonado.qe.IndexedQueryExecutor;
import com.amazon.carbonado.qe.JoinedQueryExecutor;
import com.amazon.carbonado.qe.KeyQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.PropertyFilterList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.SortedQueryExecutor;
import com.amazon.carbonado.qe.StorageAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedQueryAnalyzer<S extends Storable> {
    final Class<S> mType;
    final RepositoryAccess mRepoAccess;
    private Map<ChainedProperty<S>, ForeignIndexes<S>> mForeignIndexCache;

    public IndexedQueryAnalyzer(Class<S> type, RepositoryAccess access) {
        if (type == null || access == null) {
            throw new IllegalArgumentException();
        }
        this.mType = type;
        this.mRepoAccess = access;
    }

    public Class<S> getStorableType() {
        return this.mType;
    }

    public Result analyze(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws SupportException, RepositoryException {
        CompositeScore<S> bestScore;
        if (filter != null && !filter.isBound()) {
            throw new IllegalArgumentException("Filter must be bound");
        }
        CompositeScore<S> bestLocalScore = null;
        StorableIndex<S> bestLocalIndex = null;
        Comparator<CompositeScore<?>> fullComparator = CompositeScore.fullComparator(hints);
        Collection<StorableIndex<S>> localIndexes = this.indexesFor(this.getStorableType());
        if (localIndexes != null) {
            for (StorableIndex<S> index : localIndexes) {
                CompositeScore<S> candidateScore = CompositeScore.evaluate(index, filter, ordering);
                if (bestLocalScore != null && fullComparator.compare(candidateScore, bestLocalScore) >= 0) continue;
                bestLocalScore = candidateScore;
                bestLocalIndex = index;
            }
        }
        if (bestLocalScore != null && bestLocalScore.getFilteringScore().isKeyMatch()) {
            return new Result(filter, bestLocalScore, bestLocalIndex, null, null, hints);
        }
        CompositeScore bestForeignScore = null;
        StorableIndex<?> bestForeignIndex = null;
        ChainedProperty bestForeignProperty = null;
        for (PropertyFilter propertyFilter : PropertyFilterList.get(filter)) {
            ForeignIndexes foreignIndexes;
            ChainedProperty chainedProp = propertyFilter.getChainedProperty();
            if (chainedProp.getChainCount() == 0 || (foreignIndexes = this.getForeignIndexes(chainedProp)) == null) continue;
            for (StorableIndex<?> index : foreignIndexes.mIndexes) {
                CompositeScore candidateScore = CompositeScore.evaluate(foreignIndexes.getVirtualIndex(index), index.isUnique(), index.isClustered(), filter, ordering);
                if (bestForeignScore != null && fullComparator.compare(candidateScore, bestForeignScore) >= 0) continue;
                bestForeignScore = candidateScore;
                bestForeignIndex = index;
                bestForeignProperty = foreignIndexes.mProperty;
            }
        }
        if (bestLocalScore != null && bestForeignScore != null) {
            Comparator<CompositeScore<?>> comp = CompositeScore.localForeignComparator();
            if (comp.compare(bestForeignScore, bestLocalScore) < 0) {
                bestLocalScore = null;
            } else {
                bestForeignScore = null;
            }
        }
        if (bestLocalScore != null) {
            bestScore = bestLocalScore;
            bestForeignIndex = null;
            bestForeignProperty = null;
        } else {
            bestScore = bestForeignScore;
            bestLocalIndex = null;
        }
        return new Result(filter, bestScore, bestLocalIndex, bestForeignIndex, bestForeignProperty, hints);
    }

    private synchronized ForeignIndexes<S> getForeignIndexes(ChainedProperty<S> chainedProp) throws SupportException, RepositoryException {
        ForeignIndexes<S> foreignIndexes;
        block5: {
            chainedProp = chainedProp.trim();
            foreignIndexes = null;
            if (this.mForeignIndexCache != null && ((foreignIndexes = this.mForeignIndexCache.get(chainedProp)) != null || this.mForeignIndexCache.containsKey(chainedProp))) {
                return foreignIndexes;
            }
            if (this.isProperJoin(chainedProp.getPrimeProperty()) && !chainedProp.isOuterJoin(0)) {
                int count = chainedProp.getChainCount();
                for (int i = 0; i < count; ++i) {
                    if (this.isProperJoin(chainedProp.getChainedProperty(i)) && !chainedProp.isOuterJoin(i + 1)) {
                        continue;
                    }
                    break block5;
                }
                Class<?> foreignType = chainedProp.getLastProperty().getType();
                Collection<StorableIndex<?>> indexes = this.indexesFor(foreignType);
                foreignIndexes = new ForeignIndexes<S>(chainedProp, indexes);
            }
        }
        if (this.mForeignIndexCache == null) {
            this.mForeignIndexCache = Collections.synchronizedMap(new HashMap());
        }
        this.mForeignIndexCache.put(chainedProp, foreignIndexes);
        return foreignIndexes;
    }

    private boolean isProperJoin(StorableProperty<?> property) throws SupportException, RepositoryException {
        if (!property.isJoin() || property.isQuery()) {
            return false;
        }
        Filter filter = Filter.getOpenFilter(property.getEnclosingType());
        int count = property.getJoinElementCount();
        for (int i = 0; i < count; ++i) {
            filter = filter.and(property.getInternalJoinElement(i).getName(), RelOp.EQ);
        }
        Collection indexes = this.indexesFor(filter.getStorableType());
        if (indexes != null) {
            for (StorableIndex index : indexes) {
                FilteringScore score = FilteringScore.evaluate(index, filter);
                if (score.getRemainderCount() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private <T extends Storable> Collection<StorableIndex<T>> indexesFor(Class<T> type) throws SupportException, RepositoryException {
        return this.mRepoAccess.storageAccessFor(type).getAllIndexes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForeignIndexes<S extends Storable> {
        final ChainedProperty<S> mProperty;
        final List<StorableIndex<?>> mIndexes;
        private final Map<StorableIndex<?>, OrderedProperty<S>[]> mVirtualIndexMap;

        ForeignIndexes(ChainedProperty<S> property, Collection<StorableIndex<?>> indexes) {
            this.mProperty = property;
            this.mIndexes = indexes == null || indexes.size() == 0 ? Collections.emptyList() : new ArrayList(indexes);
            this.mVirtualIndexMap = new HashMap();
        }

        synchronized OrderedProperty<S>[] getVirtualIndex(StorableIndex<?> index) {
            OrderedProperty<S>[] virtualProps = this.mVirtualIndexMap.get(index);
            if (virtualProps != null) {
                return virtualProps;
            }
            OrderedProperty<?>[] realProps = index.getOrderedProperties();
            virtualProps = new OrderedProperty[realProps.length];
            int i = realProps.length;
            while (--i >= 0) {
                OrderedProperty<?> realProp = realProps[i];
                ChainedProperty<S> virtualChained = this.mProperty.append(realProp.getChainedProperty());
                virtualProps[i] = OrderedProperty.get(virtualChained, realProp.getDirection());
            }
            this.mVirtualIndexMap.put(index, virtualProps);
            return virtualProps;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result {
        private final Filter<S> mFilter;
        private final CompositeScore<S> mScore;
        private final StorableIndex<S> mLocalIndex;
        private final StorableIndex<?> mForeignIndex;
        private final ChainedProperty<S> mForeignProperty;
        private final QueryHints mHints;

        Result(Filter<S> filter, CompositeScore<S> score, StorableIndex<S> localIndex, StorableIndex<?> foreignIndex, ChainedProperty<S> foreignProperty, QueryHints hints) {
            this.mFilter = filter;
            this.mScore = score;
            this.mLocalIndex = localIndex;
            this.mForeignIndex = foreignIndex;
            this.mForeignProperty = foreignProperty;
            this.mHints = hints;
        }

        public boolean handlesAnything() {
            return this.mScore.getFilteringScore().hasAnyMatches() || this.mScore.getOrderingScore().getHandledCount() > 0;
        }

        public Filter<S> getFilter() {
            return this.mFilter;
        }

        public OrderingList<S> getOrdering() {
            return this.mScore.getOrderingScore().getHandledOrdering().concat(this.getRemainderOrdering());
        }

        public CompositeScore<S> getCompositeScore() {
            return this.mScore;
        }

        public Filter<S> getRemainderFilter() {
            return this.mScore.getFilteringScore().getRemainderFilter();
        }

        public OrderingList<S> getRemainderOrdering() {
            return this.mScore.getOrderingScore().getRemainderOrdering();
        }

        public StorableIndex<S> getLocalIndex() {
            return this.mLocalIndex;
        }

        public StorableIndex<?> getForeignIndex() {
            return this.mForeignIndex;
        }

        public ChainedProperty<S> getForeignProperty() {
            return this.mForeignProperty;
        }

        public boolean isIndexClustered() {
            return this.mLocalIndex != null && this.mLocalIndex.isClustered() || this.mForeignIndex != null && this.mForeignIndex.isClustered();
        }

        public boolean canMergeRemainder(Result other) {
            if (this == other || !this.handlesAnything() && !other.handlesAnything()) {
                return true;
            }
            if (this.equals(this.getLocalIndex(), other.getLocalIndex()) && this.equals(this.getForeignIndex(), other.getForeignIndex()) && this.equals(this.getForeignProperty(), other.getForeignProperty())) {
                return this.getCompositeScore().canMergeRemainder(other.getCompositeScore());
            }
            return false;
        }

        public Result mergeRemainder(Result other) {
            if (this == other) {
                return this;
            }
            Filter handledFilter = this.orFilters(this.getCompositeScore().getFilteringScore().getHandledFilter(), other.getCompositeScore().getFilteringScore().getHandledFilter());
            Filter remainderFilter = this.orFilters(this.getRemainderFilter(), other.getRemainderFilter());
            OrderingList remainderOrdering = this.getRemainderOrdering().concat(other.getRemainderOrdering()).reduce();
            Filter filter = this.andFilters(handledFilter, remainderFilter);
            CompositeScore score = this.mScore.withRemainderFilter(remainderFilter).withRemainderOrdering(remainderOrdering);
            return new Result(filter, score, this.mLocalIndex, this.mForeignIndex, this.mForeignProperty, this.mHints);
        }

        public Result mergeRemainderFilter(Filter<S> filter) {
            return this.withRemainderFilter(this.orFilters(this.getRemainderFilter(), filter));
        }

        private Filter<S> andFilters(Filter<S> a, Filter<S> b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return a.and(b).reduce();
        }

        private Filter<S> orFilters(Filter<S> a, Filter<S> b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return a.or(b).reduce();
        }

        public Result withRemainderFilter(Filter<S> remainderFilter) {
            Filter handledFilter = this.getCompositeScore().getFilteringScore().getHandledFilter();
            Filter filter = this.andFilters(handledFilter, remainderFilter);
            CompositeScore score = this.mScore.withRemainderFilter(remainderFilter);
            return new Result(filter, score, this.mLocalIndex, this.mForeignIndex, this.mForeignProperty, this.mHints);
        }

        public Result withRemainderOrdering(OrderingList<S> remainderOrdering) {
            CompositeScore score = this.mScore.withRemainderOrdering(remainderOrdering);
            return new Result(this.mFilter, score, this.mLocalIndex, this.mForeignIndex, this.mForeignProperty, this.mHints);
        }

        public QueryExecutor<S> createExecutor() throws SupportException, FetchException, RepositoryException {
            OrderingList remainderOrdering;
            AbstractQueryExecutor executor;
            Storage delegate;
            StorableIndex localIndex = this.getLocalIndex();
            StorageAccess localAccess = IndexedQueryAnalyzer.this.mRepoAccess.storageAccessFor(IndexedQueryAnalyzer.this.getStorableType());
            if (localIndex != null && (delegate = localAccess.storageDelegate(localIndex)) != null) {
                return new DelegatedQueryExecutor(delegate, this.getFilter(), this.getOrdering());
            }
            Filter remainderFilter = this.getRemainderFilter();
            if (!this.handlesAnything()) {
                executor = new FullScanQueryExecutor(localAccess);
            } else {
                if (localIndex == null) {
                    return JoinedQueryExecutor.build(IndexedQueryAnalyzer.this.mRepoAccess, this.getForeignProperty(), this.getFilter(), this.getOrdering(), this.mHints);
                }
                CompositeScore score = this.getCompositeScore();
                FilteringScore fScore = score.getFilteringScore();
                if (fScore.isKeyMatch()) {
                    executor = new KeyQueryExecutor(localAccess, localIndex, fScore);
                } else {
                    IndexedQueryExecutor ixExecutor = new IndexedQueryExecutor(localAccess, localIndex, score);
                    executor = ixExecutor;
                    if (ixExecutor.getCoveringFilter() != null) {
                        remainderFilter = fScore.getCoveringRemainderFilter();
                    }
                }
            }
            if (remainderFilter != null) {
                executor = new FilteredQueryExecutor(executor, remainderFilter);
            }
            if ((remainderOrdering = this.getRemainderOrdering()).size() > 0) {
                executor = new SortedQueryExecutor(localAccess, executor, this.getCompositeScore().getOrderingScore().getHandledOrdering(), remainderOrdering);
            }
            return executor;
        }

        public String toString() {
            return "IndexedQueryAnalyzer.Result {score=" + this.getCompositeScore() + ", localIndex=" + this.getLocalIndex() + ", foreignIndex=" + this.getForeignIndex() + ", foreignProperty=" + this.getForeignProperty() + ", remainderFilter=" + this.getRemainderFilter() + ", remainderOrdering=" + this.getRemainderOrdering() + '}';
        }

        private boolean equals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

