/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.qe.FilteringScore;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.OrderingScore;
import com.amazon.carbonado.qe.QueryHint;
import com.amazon.carbonado.qe.QueryHints;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeScore<S extends Storable> {
    private final FilteringScore<S> mFilteringScore;
    private final OrderingScore<S> mOrderingScore;

    public static <S extends Storable> CompositeScore<S> evaluate(StorableIndex<S> index, Filter<S> filter, OrderingList<S> ordering) {
        if (index == null) {
            throw new IllegalArgumentException("Index required");
        }
        return CompositeScore.evaluate(index.getOrderedProperties(), index.isUnique(), index.isClustered(), filter, ordering);
    }

    public static <S extends Storable> CompositeScore<S> evaluate(OrderedProperty<S>[] indexProperties, boolean unique, boolean clustered, Filter<S> filter, OrderingList<S> ordering) {
        FilteringScore<S> filteringScore = FilteringScore.evaluate(indexProperties, unique, clustered, filter);
        OrderingScore<S> orderingScore = OrderingScore.evaluate(indexProperties, unique, clustered, filter, ordering);
        return new CompositeScore<S>(filteringScore, orderingScore);
    }

    public static Comparator<CompositeScore<?>> localForeignComparator() {
        return CompositeScore.localForeignComparator(null);
    }

    public static Comparator<CompositeScore<?>> localForeignComparator(QueryHints hints) {
        if (hints != null && hints.contains(QueryHint.CONSUME_SLICE)) {
            return Comp.LOCAL_FOREIGN_SLICE;
        }
        return Comp.LOCAL_FOREIGN;
    }

    public static Comparator<CompositeScore<?>> fullComparator() {
        return CompositeScore.fullComparator(null);
    }

    public static Comparator<CompositeScore<?>> fullComparator(QueryHints hints) {
        if (hints != null && hints.contains(QueryHint.CONSUME_SLICE)) {
            return Comp.SLICE;
        }
        return Comp.FULL;
    }

    private CompositeScore(FilteringScore<S> filteringScore, OrderingScore<S> orderingScore) {
        this.mFilteringScore = filteringScore;
        this.mOrderingScore = orderingScore;
    }

    public FilteringScore<S> getFilteringScore() {
        return this.mFilteringScore;
    }

    public OrderingScore<S> getOrderingScore() {
        return this.mOrderingScore;
    }

    public boolean canMergeRemainder(CompositeScore<S> other) {
        return this.getFilteringScore().canMergeRemainderFilter(other.getFilteringScore()) && this.getOrderingScore().canMergeRemainderOrdering(other.getOrderingScore());
    }

    public Filter<S> mergeRemainderFilter(CompositeScore<S> other) {
        return this.getFilteringScore().mergeRemainderFilter(other.getFilteringScore());
    }

    public OrderingList<S> mergeRemainderOrdering(CompositeScore<S> other) {
        return this.getOrderingScore().mergeRemainderOrdering(other.getOrderingScore());
    }

    public CompositeScore<S> withRemainderFilter(Filter<S> filter) {
        return new CompositeScore<S>(this.mFilteringScore.withRemainderFilter(filter), this.mOrderingScore);
    }

    public CompositeScore<S> withRemainderOrdering(OrderingList<S> ordering) {
        return new CompositeScore<S>(this.mFilteringScore, this.mOrderingScore.withRemainderOrdering(ordering));
    }

    public String toString() {
        return "CompositeScore {" + this.getFilteringScore() + ", " + this.getOrderingScore() + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comp
    implements Comparator<CompositeScore<?>> {
        static final Comparator<CompositeScore<?>> LOCAL_FOREIGN = new Comp(false, false);
        static final Comparator<CompositeScore<?>> SLICE = new Comp(true, true);
        static final Comparator<CompositeScore<?>> LOCAL_FOREIGN_SLICE = new Comp(false, true);
        static final Comparator<CompositeScore<?>> FULL = new Comp(true, false);
        private final boolean mFull;
        private final boolean mSlice;

        private Comp(boolean full, boolean slice) {
            this.mFull = full;
            this.mSlice = slice;
        }

        @Override
        public int compare(CompositeScore<?> first, CompositeScore<?> second) {
            int result = FilteringScore.nullCompare(first, second);
            if (result != 0) {
                return result;
            }
            FilteringScore<?> firstScore = first.getFilteringScore();
            FilteringScore<?> secondScore = second.getFilteringScore();
            result = FilteringScore.rangeComparator().compare(firstScore, secondScore);
            OrderingScore<?> firstOrderingScore = first.getOrderingScore();
            OrderingScore<?> secondOrderingScore = second.getOrderingScore();
            if (result != 0) {
                if (!firstScore.hasAnyMatches() || !secondScore.hasAnyMatches()) {
                    return result;
                }
                int handledScore = secondOrderingScore.getHandledCount() - firstOrderingScore.getHandledCount();
                if (handledScore == 0) {
                    return result;
                }
                if (Integer.signum(result) == Integer.signum(handledScore)) {
                    return result;
                }
                int preferenceResult = secondScore.getPreferenceScore().compareTo(firstScore.getPreferenceScore());
                if (preferenceResult != 0) {
                    return preferenceResult;
                }
                if (firstScore.getHandledCount() == secondScore.getHandledCount() && handledScore != 0) {
                    return handledScore;
                }
                return result;
            }
            boolean comparedOrdering = false;
            if (this.considerOrdering(firstScore) && this.considerOrdering(secondScore)) {
                result = OrderingScore.fullComparator().compare(first.getOrderingScore(), second.getOrderingScore());
                comparedOrdering = true;
                if (result != 0) {
                    return result;
                }
            }
            if (!this.mFull) {
                if (firstScore.hasAnyMatches()) {
                    if (!secondScore.hasAnyMatches()) {
                        return -1;
                    }
                } else if (secondScore.hasAnyMatches()) {
                    return 1;
                }
                return 0;
            }
            result = FilteringScore.fullComparator().compare(firstScore, secondScore);
            if (result != 0) {
                return result;
            }
            if (!comparedOrdering) {
                result = OrderingScore.fullComparator().compare(first.getOrderingScore(), second.getOrderingScore());
                comparedOrdering = true;
                if (result != 0) {
                    return result;
                }
            }
            if (firstScore.getIndexPropertyCount() < secondScore.getIndexPropertyCount()) {
                return -1;
            }
            if (firstScore.getIndexPropertyCount() > secondScore.getIndexPropertyCount()) {
                return 1;
            }
            return result;
        }

        private boolean considerOrdering(FilteringScore<?> score) {
            return this.mSlice || score.isIndexClustered() || score.getIdentityCount() > 0 || score.hasRangeMatch();
        }
    }
}

