/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.lob;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.lob.Clob;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractClob
implements Clob {
    private final Repository mRepo;

    static FetchException toFetchException(IOException e) {
        Throwable cause = e.getCause();
        if (cause instanceof FetchException) {
            return (FetchException)cause;
        }
        if (cause == null) {
            cause = e;
        }
        return new FetchException(cause);
    }

    static PersistException toPersistException(IOException e) {
        Throwable cause = e.getCause();
        if (cause instanceof PersistException) {
            return (PersistException)cause;
        }
        if (cause == null) {
            cause = e;
        }
        return new PersistException(cause);
    }

    protected AbstractClob() {
        this.mRepo = null;
    }

    protected AbstractClob(Repository repo) {
        this.mRepo = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String asString() throws FetchException {
        txn = this.mRepo == null ? null : this.mRepo.enterTransaction();
        length = this.getLength();
        if (length > 0x7FFFFFFFL) {
            throw new IllegalArgumentException("Clob is too long to fit in a String: " + length);
        }
        iLen = (int)length;
        if (iLen <= 0) {
            var5_4 = "";
            return var5_4;
        }
        r = this.openReader();
        buf = new char[iLen];
        offset = 0;
        while ((amt = r.read(buf, offset, iLen - offset)) > 0) {
            offset += amt;
        }
        if (offset > 0) ** break block23
        var9_11 = "";
        r.close();
        return var9_11;
        {
            var9_12 = new String(buf, 0, offset);
            r.close();
        }
        return var9_12;
        {
            catch (Throwable var11_15) {
                try {
                    r.close();
                    throw var11_15;
                }
                catch (IOException e) {
                    throw AbstractClob.toFetchException(e);
                }
            }
        }
        finally {
            if (txn != null) {
                try {
                    txn.exit();
                }
                catch (PersistException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String value) throws PersistException {
        if (value == null) {
            throw new IllegalArgumentException("Clob value cannot be null");
        }
        if (this.mRepo == null) {
            this.setLength(0L);
            try {
                Writer w = this.openWriter();
                w.write(value);
                w.close();
            }
            catch (IOException e) {
                throw AbstractClob.toPersistException(e);
            }
        }
        Transaction txn = this.mRepo.enterTransaction();
        try {
            long originalLength = this.getLength();
            try {
                Writer w = this.openWriter();
                try {
                    w.write(value);
                }
                finally {
                    w.close();
                }
            }
            catch (IOException e) {
                throw AbstractClob.toPersistException(e);
            }
            if ((long)value.length() < originalLength) {
                this.setLength(value.length());
            }
            txn.commit();
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        finally {
            txn.exit();
        }
    }

    public int hashCode() {
        Object locator = this.getLocator();
        return locator == null ? super.hashCode() : locator.hashCode();
    }

    public boolean equals(Object obj) {
        Object locator;
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractClob && (locator = this.getLocator()) != null) {
            AbstractClob other = (AbstractClob)obj;
            return locator == other.getLocator();
        }
        return false;
    }

    public String toString() {
        Object locator = this.getLocator();
        return locator == null ? super.toString() : "Clob@" + locator;
    }
}

