/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.gen;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.SoftValuedCache;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorablePropertyMap<S extends Storable>
extends AbstractMap<String, Object> {
    private static final SoftValuedCache<Class, Set<String>> cPropertyNamesForType = SoftValuedCache.newCache(11);
    private final Set<String> mPropertyNames;
    private final S mStorable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> StorablePropertyMap<S> createMap(Class<S> type, S storable) {
        Set<String> propertyNames;
        SoftValuedCache<Class, Set<String>> softValuedCache = cPropertyNamesForType;
        synchronized (softValuedCache) {
            propertyNames = cPropertyNamesForType.get(type);
            if (propertyNames == null) {
                Map<String, StorableProperty<S>> properties = StorableIntrospector.examine(type).getAllProperties();
                for (StorableProperty<S> property : properties.values()) {
                    if (!StorablePropertyMap.shouldExclude(property)) continue;
                    if (propertyNames == null) {
                        propertyNames = new LinkedHashSet<String>(properties.keySet());
                    }
                    propertyNames.remove(property.getName());
                }
                propertyNames = propertyNames == null ? properties.keySet() : Collections.unmodifiableSet(propertyNames);
            }
        }
        return new StorablePropertyMap<S>(propertyNames, storable);
    }

    private static boolean shouldExclude(StorableProperty<?> property) {
        return StorablePropertyMap.throwsCheckedException(property.getReadMethod()) || StorablePropertyMap.throwsCheckedException(property.getWriteMethod());
    }

    private static boolean throwsCheckedException(Method method) {
        if (method == null) {
            return false;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes == null) {
            return false;
        }
        for (Class<?> exceptionType : exceptionTypes) {
            if (RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private StorablePropertyMap(Set<String> propertyNames, S storable) {
        this.mPropertyNames = propertyNames;
        this.mStorable = storable;
    }

    @Override
    public int size() {
        return this.mPropertyNames.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mPropertyNames.contains(key);
    }

    @Override
    public Object get(Object key) {
        try {
            return this.mStorable.getPropertyValue((String)key);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Object put(String key, Object value) {
        Object old = this.mStorable.getPropertyValue(key);
        this.mStorable.setPropertyValue(key, value);
        return old;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.mPropertyNames;
    }

    @Override
    public Collection<Object> values() {
        return new AbstractCollection<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    private final Iterator<String> mPropIterator;
                    {
                        this.mPropIterator = StorablePropertyMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mPropIterator.hasNext();
                    }

                    @Override
                    public Object next() {
                        return StorablePropertyMap.this.get(this.mPropIterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return StorablePropertyMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object v) {
                return StorablePropertyMap.this.containsValue(v);
            }

            @Override
            public boolean remove(Object e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    private final Iterator<String> mPropIterator;
                    {
                        this.mPropIterator = StorablePropertyMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mPropIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        final String property = this.mPropIterator.next();
                        final Object value = StorablePropertyMap.this.get(property);
                        return new Map.Entry<String, Object>(){
                            Object mutableValue;
                            {
                                this.mutableValue = value;
                            }

                            @Override
                            public String getKey() {
                                return property;
                            }

                            @Override
                            public Object getValue() {
                                return this.mutableValue;
                            }

                            @Override
                            public Object setValue(Object value2) {
                                Object old = StorablePropertyMap.this.put(property, value2);
                                this.mutableValue = value2;
                                return old;
                            }

                            @Override
                            public boolean equals(Object obj) {
                                if (this == obj) {
                                    return true;
                                }
                                if (obj instanceof Map.Entry) {
                                    Map.Entry other = (Map.Entry)obj;
                                    return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
                                }
                                return false;
                            }

                            @Override
                            public int hashCode() {
                                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                            }

                            public String toString() {
                                return property + "=" + this.mutableValue;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return StorablePropertyMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object e) {
                Map.Entry entry = (Map.Entry)e;
                String key = (String)entry.getKey();
                if (StorablePropertyMap.this.containsKey(key)) {
                    Object value = StorablePropertyMap.this.get(key);
                    return value == null ? entry.getValue() == null : value.equals(entry.getValue());
                }
                return false;
            }

            @Override
            public boolean add(Map.Entry<String, Object> e) {
                StorablePropertyMap.this.put(e.getKey(), e.getValue());
                return true;
            }

            @Override
            public boolean remove(Object e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

