/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchAheadCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mSource;
    private final int mFetchAhead;
    private final Queue<Object> mQueue;

    public FetchAheadCursor(Cursor<S> source, int fetchAhead) {
        this.mSource = source;
        this.mFetchAhead = fetchAhead;
        this.mQueue = new ArrayDeque<Object>(fetchAhead + 1);
    }

    @Override
    public void close() throws FetchException {
        this.mQueue.clear();
        this.mSource.close();
    }

    @Override
    public boolean hasNext() throws FetchException {
        while (this.mQueue.size() <= this.mFetchAhead && this.mSource.hasNext()) {
            try {
                this.mQueue.add(this.mSource.next());
            }
            catch (FetchException e) {
                this.mQueue.add(e);
            }
        }
        return !this.mQueue.isEmpty();
    }

    @Override
    public S next() throws FetchException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object next = this.mQueue.remove();
        if (next instanceof FetchException) {
            throw (FetchException)next;
        }
        return (S)next;
    }
}

