/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.adapter;

import com.amazon.carbonado.adapter.AdapterDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@AdapterDefinition(storageTypePreferences={long.class, Long.class, String.class})
public @interface DateTimeAdapter {
    public String timeZone() default "";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter {
        private static final DateTimeFormatter cDateTimeParser;
        private final String mPropertyName;
        private final DateTimeZone mZone;
        private final DateTimeFormatter mDateTimeParser;

        private static DateTimeZone toDateTimeZone(DateTimeAdapter ann) {
            String id;
            if (ann == null || (id = ann.timeZone()) == null || id.length() == 0) {
                return null;
            }
            return DateTimeZone.forID((String)id);
        }

        public Adapter(Class<?> type, String propertyName, DateTimeAdapter ann) {
            this(type, propertyName, Adapter.toDateTimeZone(ann));
        }

        public Adapter(Class<?> type, String propertyName, DateTimeZone zone) {
            this.mPropertyName = propertyName;
            this.mZone = zone;
            this.mDateTimeParser = cDateTimeParser.withZone(zone);
        }

        public DateTime adaptToDateTime(long instant) {
            return new DateTime(instant, this.mZone);
        }

        public DateTime adaptToDateTime(Long instant) {
            return instant == null ? null : new DateTime((Object)instant, this.mZone);
        }

        public DateTime adaptToDateTime(String isoDateString) {
            return isoDateString == null ? null : this.mDateTimeParser.parseDateTime(isoDateString);
        }

        public DateTime adaptToDateTime(java.util.Date date) {
            return date == null ? null : new DateTime((Object)date, this.mZone);
        }

        public DateTime adaptToDateTime(Date date) {
            return date == null ? null : new DateTime(date.getTime(), this.mZone);
        }

        public DateTime adaptToDateTime(Time time) {
            return time == null ? null : new DateTime(time.getTime(), this.mZone);
        }

        public DateTime adaptToDateTime(Timestamp timestamp) {
            return timestamp == null ? null : new DateTime(timestamp.getTime(), this.mZone);
        }

        public DateMidnight adaptToDateMidnight(long instant) {
            return new DateMidnight(instant, this.mZone);
        }

        public DateMidnight adaptToDateMidnight(Long instant) {
            return instant == null ? null : new DateMidnight((Object)instant, this.mZone);
        }

        public DateMidnight adaptToDateMidnight(String isoDateString) {
            return isoDateString == null ? null : new DateMidnight((Object)isoDateString, this.mZone);
        }

        public DateMidnight adaptToDateMidnight(java.util.Date date) {
            return date == null ? null : new DateMidnight((Object)date, this.mZone);
        }

        public DateMidnight adaptToDateMidnight(Date date) {
            return date == null ? null : new DateMidnight(date.getTime(), this.mZone);
        }

        public DateMidnight adaptToDateMidnight(Time time) {
            return time == null ? null : new DateMidnight(time.getTime(), this.mZone);
        }

        public DateMidnight adaptToDateMidnight(Timestamp timestamp) {
            return timestamp == null ? null : new DateMidnight(timestamp.getTime(), this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(long instant) {
            return new LocalDateTime(instant, this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(Long instant) {
            return instant == null ? null : new LocalDateTime((Object)instant, this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(String isoDateString) {
            return isoDateString == null ? null : new LocalDateTime((Object)isoDateString, this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(java.util.Date date) {
            return date == null ? null : new LocalDateTime((Object)date, this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(Date date) {
            return date == null ? null : new LocalDateTime(date.getTime(), this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(Time time) {
            return time == null ? null : new LocalDateTime(time.getTime(), this.mZone);
        }

        public LocalDateTime adaptToLocalDateTime(Timestamp timestamp) {
            return timestamp == null ? null : new LocalDateTime(timestamp.getTime(), this.mZone);
        }

        public LocalDate adaptToLocalDate(long instant) {
            return new LocalDate(instant, this.mZone);
        }

        public LocalDate adaptToLocalDate(Long instant) {
            return instant == null ? null : new LocalDate((Object)instant, this.mZone);
        }

        public LocalDate adaptToLocalDate(String isoDateString) {
            return isoDateString == null ? null : new LocalDate((Object)isoDateString, this.mZone);
        }

        public LocalDate adaptToLocalDate(java.util.Date date) {
            return date == null ? null : new LocalDate((Object)date, this.mZone);
        }

        public LocalDate adaptToLocalDate(Date date) {
            return date == null ? null : new LocalDate(date.getTime(), this.mZone);
        }

        public LocalDate adaptToLocalDate(Time time) {
            return time == null ? null : new LocalDate(time.getTime(), this.mZone);
        }

        public LocalDate adaptToLocalDate(Timestamp timestamp) {
            return timestamp == null ? null : new LocalDate(timestamp.getTime(), this.mZone);
        }

        public long adaptToLong(ReadableInstant instant) {
            if (instant != null) {
                return instant.getMillis();
            }
            throw new IllegalArgumentException("Cannot adapt null instant into long for property \"" + this.mPropertyName + '\"');
        }

        public Long adaptToLongObj(ReadableInstant instant) {
            return instant == null ? null : Long.valueOf(instant.getMillis());
        }

        public String adaptToString(ReadableInstant instant) {
            return instant == null ? null : instant.toString();
        }

        public java.util.Date adaptToDate(ReadableInstant instant) {
            return instant == null ? null : new java.util.Date(instant.getMillis());
        }

        public Date adaptToSqlDate(ReadableInstant instant) {
            return instant == null ? null : new Date(instant.getMillis());
        }

        public Time adaptToSqlTime(ReadableInstant instant) {
            return instant == null ? null : new Time(instant.getMillis());
        }

        public Timestamp adaptToSqlTimestamp(ReadableInstant instant) {
            return instant == null ? null : new Timestamp(instant.getMillis());
        }

        public long adaptToLong(LocalDateTime dateTime) {
            if (dateTime != null) {
                return dateTime.toDateTime(this.mZone).getMillis();
            }
            throw new IllegalArgumentException("Cannot adapt null datetime into long for property \"" + this.mPropertyName + '\"');
        }

        public Long adaptToLongObj(LocalDateTime dateTime) {
            return dateTime == null ? null : Long.valueOf(dateTime.toDateTime(this.mZone).getMillis());
        }

        public String adaptToString(LocalDateTime dateTime) {
            return dateTime == null ? null : dateTime.toString();
        }

        public java.util.Date adaptToDate(LocalDateTime dateTime) {
            return dateTime == null ? null : dateTime.toDateTime(this.mZone).toDate();
        }

        public Date adaptToSqlDate(LocalDateTime dateTime) {
            return dateTime == null ? null : new Date(dateTime.toDateTime(this.mZone).getMillis());
        }

        public Time adaptToSqlTime(LocalDateTime dateTime) {
            return dateTime == null ? null : new Time(dateTime.toDateTime(this.mZone).getMillis());
        }

        public Timestamp adaptToSqlTimestamp(LocalDateTime dateTime) {
            return dateTime == null ? null : new Timestamp(dateTime.toDateTime(this.mZone).getMillis());
        }

        public long adaptToLong(LocalDate date) {
            if (date != null) {
                return date.toDateMidnight(this.mZone).getMillis();
            }
            throw new IllegalArgumentException("Cannot adapt null date into long for property \"" + this.mPropertyName + '\"');
        }

        public Long adaptToLongObj(LocalDate date) {
            return date == null ? null : Long.valueOf(date.toDateMidnight(this.mZone).getMillis());
        }

        public String adaptToString(LocalDate date) {
            return date == null ? null : date.toString();
        }

        public java.util.Date adaptToDate(LocalDate date) {
            return date == null ? null : date.toDateMidnight(this.mZone).toDate();
        }

        public Date adaptToSqlDate(LocalDate date) {
            return date == null ? null : new Date(date.toDateMidnight(this.mZone).getMillis());
        }

        public Timestamp adaptToSqlTimestamp(LocalDate date) {
            return date == null ? null : new Timestamp(date.toDateMidnight(this.mZone).getMillis());
        }

        public java.util.Date adaptToDate(long instant) {
            return new java.util.Date(instant);
        }

        public java.util.Date adaptToDate(Long instant) {
            return instant == null ? null : new java.util.Date(instant);
        }

        public java.util.Date adaptToDate(String isoDateString) {
            return isoDateString == null ? null : this.mDateTimeParser.parseDateTime(isoDateString).toDate();
        }

        public java.util.Date adaptToDate(Date date) {
            return date == null ? null : new java.util.Date(date.getTime());
        }

        public java.util.Date adaptToDate(Time time) {
            return time == null ? null : new java.util.Date(time.getTime());
        }

        public java.util.Date adaptToDate(Timestamp timestamp) {
            return timestamp == null ? null : new java.util.Date(timestamp.getTime());
        }

        public long adaptToLong(java.util.Date date) {
            if (date != null) {
                return date.getTime();
            }
            throw new IllegalArgumentException("Cannot adapt null date into long for property \"" + this.mPropertyName + '\"');
        }

        public Long adaptToLongObj(java.util.Date date) {
            return date == null ? null : Long.valueOf(date.getTime());
        }

        public String adaptToString(java.util.Date date) {
            return date == null ? null : new DateTime((Object)date, this.mZone).toString();
        }

        public Date adaptToSqlDate(java.util.Date date) {
            return date == null ? null : new Date(date.getTime());
        }

        public Time adaptToSqlTime(java.util.Date date) {
            return date == null ? null : new Time(date.getTime());
        }

        public Timestamp adaptToSqlTimestamp(java.util.Date date) {
            return date == null ? null : new Timestamp(date.getTime());
        }

        static {
            DateTimeParser offset = new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toParser();
            DateTimeParser ttime = new DateTimeFormatterBuilder().appendLiteral('T').append(ISODateTimeFormat.timeElementParser().getParser()).appendOptional(offset).toParser();
            DateTimeParser separator = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral(' ').toParser(), new DateTimeFormatterBuilder().appendLiteral('T').toParser()}).toParser();
            DateTimeParser separatedTimeOrOffset = new DateTimeFormatterBuilder().append(separator).appendOptional(ISODateTimeFormat.timeElementParser().getParser()).appendOptional(offset).toParser();
            DateTimeParser dateOptionalTime = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser().getParser()).appendOptional(separatedTimeOrOffset).toParser();
            cDateTimeParser = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{ttime, dateOptionalTime}).toFormatter();
        }
    }
}

