/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.repo.sleepycat.BDBProduct;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.repo.sleepycat.BDBRepositoryBuilder;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.repo.sleepycat.CompactionCapability;
import com.amazon.carbonado.repo.sleepycat.DB_ExceptionTransformer;
import com.amazon.carbonado.repo.sleepycat.DB_Storage;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.VerifyConfig;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DB_Repository
extends BDBRepository<com.sleepycat.db.Transaction>
implements CompactionCapability {
    private static final int DEFAULT_LOG_REGION_SIZE = 262144;
    private static final TransactionConfig TXN_READ_UNCOMMITTED = new TransactionConfig();
    private static final TransactionConfig TXN_READ_COMMITTED;
    private static final TransactionConfig TXN_REPEATABLE_READ;
    private static final TransactionConfig TXN_READ_UNCOMMITTED_NOWAIT;
    private static final TransactionConfig TXN_READ_COMMITTED_NOWAIT;
    private static final TransactionConfig TXN_REPEATABLE_READ_NOWAIT;
    private static final TransactionConfig TXN_SNAPSHOT;
    private static Map<String, Integer> cRegisterCountMap;
    private static final long DEFAULT_CACHE_SIZE = 0x3C00000L;
    private final BDBProduct mProduct;
    final Environment mEnv;
    final boolean mMVCC;
    final boolean mReadOnly;
    final boolean mDatabasesTransactional;
    final boolean mReverseSplitOff;
    final Boolean mChecksum;
    final long mLockTimeoutMicros;
    volatile String mRegisteredHome;

    private static synchronized boolean register(String envHome) {
        Integer count;
        if (cRegisterCountMap == null) {
            cRegisterCountMap = new HashMap<String, Integer>();
        }
        count = (count = cRegisterCountMap.get(envHome)) == null ? 1 : count + 1;
        cRegisterCountMap.put(envHome, count);
        return count == 1;
    }

    private static synchronized void unregister(String envHome) {
        Integer count;
        if (cRegisterCountMap != null && (count = cRegisterCountMap.get(envHome)) != null) {
            if ((count = Integer.valueOf(count - 1)) <= 0) {
                cRegisterCountMap.remove(envHome);
            } else {
                cRegisterCountMap.put(envHome, count);
            }
        }
    }

    private static EnvironmentConfig createEnvConfig(BDBRepositoryBuilder builder) throws ConfigurationException {
        EnvironmentConfig envConfig;
        try {
            envConfig = (EnvironmentConfig)builder.getInitialEnvironmentConfig();
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Unsupported initial environment config. Must be instance of " + EnvironmentConfig.class.getName(), (Throwable)e);
        }
        if (envConfig == null) {
            Long cacheSize;
            boolean initializeLogging;
            envConfig = new EnvironmentConfig();
            envConfig.setTransactional(true);
            envConfig.setAllowCreate(!builder.getReadOnly());
            envConfig.setTxnNoSync(builder.getTransactionNoSync());
            envConfig.setTxnWriteNoSync(builder.getTransactionWriteNoSync());
            try {
                if (builder.getTransactionMaxActive() != null) {
                    envConfig.setTxnMaxActive(builder.getTransactionMaxActive().intValue());
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            envConfig.setPrivate(builder.isPrivate());
            envConfig.setRunRecovery(builder.isPrivate() && !builder.getReadOnly());
            if (builder.isMultiversion()) {
                try {
                    envConfig.setMultiversion(true);
                }
                catch (NoSuchMethodError e) {
                    throw new ConfigurationException("BDB product and version does not support MVCC");
                }
            }
            envConfig.setLogInMemory(builder.getLogInMemory());
            try {
                Integer maxSize = builder.getLogFileMaxSize();
                if (maxSize != null) {
                    envConfig.setMaxLogFileSize(maxSize.intValue());
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            envConfig.setInitializeCache(true);
            envConfig.setInitializeLocking(true);
            boolean bl = initializeLogging = builder.isPrivate() || !new File(builder.getEnvironmentHomeFile(), "__db.001").exists();
            if (!initializeLogging) {
                try {
                    initializeLogging = builder.getInitializeLogging();
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            if (initializeLogging) {
                envConfig.setInitializeLogging(true);
            }
            envConfig.setCacheSize((cacheSize = builder.getCacheSize()) != null ? cacheSize : 0x3C00000L);
            try {
                Integer logRegionSize = builder.getLogRegionSize();
                envConfig.setLogRegionSize(logRegionSize != null ? logRegionSize : 262144);
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            int maxLocks = 10000;
            try {
                if (builder.getMaxLocks() != null) {
                    maxLocks = builder.getMaxLocks();
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            envConfig.setMaxLocks(maxLocks);
            envConfig.setMaxLockObjects(maxLocks);
            envConfig.setMaxLockers(maxLocks);
            envConfig.setLockTimeout(builder.getLockTimeoutInMicroseconds());
            envConfig.setTxnTimeout(builder.getTransactionTimeoutInMicroseconds());
        } else {
            if (!envConfig.getTransactional()) {
                throw new IllegalArgumentException("EnvironmentConfig: getTransactional is false");
            }
            if (!envConfig.getInitializeCache()) {
                throw new IllegalArgumentException("EnvironmentConfig: getInitializeCache is false");
            }
            if (envConfig.getCacheSize() <= 0L) {
                throw new IllegalArgumentException("EnvironmentConfig: invalid cache size");
            }
            if (!envConfig.getInitializeLocking()) {
                throw new IllegalArgumentException("EnvironmentConfig: getInitializeLocking is false");
            }
        }
        return envConfig;
    }

    DB_Repository(AtomicReference<Repository> rootRef, BDBRepositoryBuilder builder) throws RepositoryException {
        this(rootRef, builder, DB_ExceptionTransformer.getInstance());
    }

    DB_Repository(AtomicReference<Repository> rootRef, BDBRepositoryBuilder builder, ExceptionTransformer exTransformer) throws RepositoryException {
        super(rootRef, builder, exTransformer);
        boolean off;
        boolean mvcc;
        EnvironmentConfig envConfig;
        this.mProduct = builder.getBDBProduct();
        if (builder.getRunFullRecovery() && !builder.getReadOnly()) {
            envConfig = DB_Repository.createEnvConfig(builder);
            envConfig.setRunRecovery(false);
            envConfig.setRunFatalRecovery(true);
            envConfig.setPrivate(true);
            envConfig.setInitializeLogging(true);
            try {
                new Environment(builder.getEnvironmentHomeFile(), envConfig).close();
            }
            catch (DatabaseException e) {
                throw DB_ExceptionTransformer.getInstance().toRepositoryException(e);
            }
            catch (Throwable e) {
                String message = "Unable to recover environment";
                if (e.getMessage() != null) {
                    message = message + ": " + e.getMessage();
                }
                throw new RepositoryException(message, e);
            }
        }
        envConfig = DB_Repository.createEnvConfig(builder);
        try {
            if (!builder.isPrivate()) {
                this.mRegisteredHome = builder.getEnvironmentHome();
                if (DB_Repository.register(this.mRegisteredHome)) {
                    envConfig.setRegister(true);
                    if (!builder.getReadOnly()) {
                        envConfig.setRunRecovery(true);
                    }
                }
            }
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        try {
            mvcc = envConfig.getMultiversion();
        }
        catch (NoSuchMethodError e) {
            mvcc = false;
        }
        this.mMVCC = mvcc;
        boolean databasesTransactional = envConfig.getTransactional();
        if (builder.getDatabasesTransactional() != null) {
            databasesTransactional = builder.getDatabasesTransactional();
        }
        this.mDatabasesTransactional = databasesTransactional;
        try {
            off = builder.isReverseSplitOff();
        }
        catch (NoSuchMethodError e) {
            off = false;
        }
        this.mReverseSplitOff = off;
        this.mChecksum = builder.getChecksumEnabled();
        try {
            this.mEnv = new Environment(builder.getEnvironmentHomeFile(), envConfig);
        }
        catch (DatabaseException e) {
            throw DB_ExceptionTransformer.getInstance().toRepositoryException(e);
        }
        catch (Throwable e) {
            if (this.mRegisteredHome != null) {
                DB_Repository.unregister(this.mRegisteredHome);
            }
            String message = "Unable to open environment";
            if (e.getMessage() != null) {
                message = message + ": " + e.getMessage();
            }
            throw new RepositoryException(message, e);
        }
        boolean readOnly = builder.getReadOnly();
        if (!readOnly && !builder.getDataHomeFile().canWrite()) {
            readOnly = true;
        }
        this.mReadOnly = readOnly;
        long lockTimeout = envConfig.getLockTimeout();
        long txnTimeout = envConfig.getTxnTimeout();
        this.mLockTimeoutMicros = lockTimeout;
        long deadlockInterval = Math.min(lockTimeout, txnTimeout);
        deadlockInterval = Math.max(500000L, deadlockInterval) / 1000L;
        this.start(builder.getCheckpointInterval(), deadlockInterval, builder);
    }

    public Object getEnvironment() {
        return this.mEnv;
    }

    public BDBProduct getBDBProduct() {
        return this.mProduct;
    }

    public int[] getVersion() {
        int[] nArray = new int[3];
        DB_Repository dB_Repository = this;
        nArray[0] = dB_Repository.mEnv.getVersionMajor();
        DB_Repository dB_Repository2 = this;
        nArray[1] = dB_Repository2.mEnv.getVersionMinor();
        DB_Repository dB_Repository3 = this;
        nArray[2] = dB_Repository3.mEnv.getVersionPatch();
        return nArray;
    }

    public File getHome() {
        return this.mEnvHome;
    }

    public File getDataHome() {
        return this.mDataHome == null ? this.mEnvHome : this.mDataHome;
    }

    public <S extends Storable> CompactionCapability.Result<S> compact(Class<S> storableType) throws RepositoryException {
        return ((BDBStorage)this.storageFor(storableType)).compact();
    }

    boolean verify(PrintStream out) throws Exception {
        boolean result = true;
        for (File file : this.backupDataFiles()) {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setType(DatabaseType.BTREE);
            dbConfig.setSortedDuplicates(false);
            if (this.mChecksum != null) {
                dbConfig.setChecksum(this.mChecksum.booleanValue());
            }
            dbConfig.setTransactional(this.mDatabasesTransactional);
            dbConfig.setReadOnly(true);
            dbConfig.setAllowCreate(false);
            VerifyConfig vConfig = new VerifyConfig();
            result &= Database.verify((String)file.getPath(), null, (PrintStream)out, (VerifyConfig)vConfig, (DatabaseConfig)dbConfig);
        }
        return result;
    }

    IsolationLevel selectIsolationLevel(Transaction parent, IsolationLevel level) {
        if (level == null) {
            if (parent == null) {
                return IsolationLevel.REPEATABLE_READ;
            }
            return parent.getIsolationLevel();
        }
        if (level == IsolationLevel.SNAPSHOT ? !this.mMVCC : level == IsolationLevel.SERIALIZABLE) {
            return null;
        }
        return level;
    }

    protected com.sleepycat.db.Transaction txn_begin(com.sleepycat.db.Transaction parent, IsolationLevel level) throws Exception {
        TransactionConfig config;
        if (!this.mDatabasesTransactional) {
            return null;
        }
        switch (level) {
            case READ_UNCOMMITTED: {
                config = TXN_READ_UNCOMMITTED;
                break;
            }
            case READ_COMMITTED: {
                config = TXN_READ_COMMITTED;
                break;
            }
            case SNAPSHOT: {
                config = TXN_SNAPSHOT;
                break;
            }
            default: {
                config = TXN_REPEATABLE_READ;
            }
        }
        return this.mEnv.beginTransaction(parent, config);
    }

    protected com.sleepycat.db.Transaction txn_begin(com.sleepycat.db.Transaction parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        com.sleepycat.db.Transaction txn = this.txn_begin(parent, level);
        txn.setLockTimeout(unit.toMicros(timeout));
        return txn;
    }

    protected com.sleepycat.db.Transaction txn_begin_nowait(com.sleepycat.db.Transaction parent, IsolationLevel level) throws Exception {
        TransactionConfig config;
        if (!this.mDatabasesTransactional) {
            return null;
        }
        switch (level) {
            case READ_UNCOMMITTED: {
                config = TXN_READ_UNCOMMITTED_NOWAIT;
                break;
            }
            case READ_COMMITTED: {
                config = TXN_READ_COMMITTED_NOWAIT;
                break;
            }
            case SNAPSHOT: {
                config = TXN_SNAPSHOT;
                break;
            }
            default: {
                config = TXN_REPEATABLE_READ_NOWAIT;
            }
        }
        return this.mEnv.beginTransaction(parent, config);
    }

    protected void txn_commit(com.sleepycat.db.Transaction txn) throws Exception {
        if (txn == null) {
            return;
        }
        txn.commit();
    }

    protected void txn_abort(com.sleepycat.db.Transaction txn) throws Exception {
        if (txn == null) {
            return;
        }
        txn.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void env_checkpoint() throws Exception {
        Object object = this.mBackupLock;
        synchronized (object) {
            CheckpointConfig cc = new CheckpointConfig();
            cc.setForce(true);
            this.mEnv.checkpoint(cc);
            if (this.mBackupCount == 0) {
                this.removeOldLogFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void env_checkpoint(int kBytes, int minutes) throws Exception {
        Object object = this.mBackupLock;
        synchronized (object) {
            CheckpointConfig cc = new CheckpointConfig();
            cc.setKBytes(kBytes);
            cc.setMinutes(minutes);
            this.mEnv.checkpoint(cc);
            if (this.mBackupCount == 0) {
                this.removeOldLogFiles();
            }
        }
    }

    protected void env_sync() throws Exception {
        this.mEnv.logFlush(null);
    }

    private void removeOldLogFiles() throws Exception {
        try {
            if (this.mKeepOldLogFiles) {
                return;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.mEnv.removeOldLogFiles();
    }

    protected void env_detectDeadlocks() throws Exception {
        this.mEnv.detectDeadlocks(LockDetectMode.DEFAULT);
    }

    protected void env_close() throws Exception {
        if (this.mEnv != null) {
            this.mEnv.close();
            String registeredHome = this.mRegisteredHome;
            if (registeredHome != null) {
                this.mRegisteredHome = null;
                DB_Repository.unregister(registeredHome);
            }
        }
    }

    protected <S extends Storable> BDBStorage<com.sleepycat.db.Transaction, S> createBDBStorage(Class<S> type) throws Exception {
        return new DB_Storage<S>(this, type);
    }

    void enterBackupMode(boolean deleteOldLogFiles) throws Exception {
        this.forceCheckpoint();
        if (deleteOldLogFiles && this.mBackupCount == 0 && this.mIncrementalBackupCount == 0) {
            this.deleteOldLogFiles(-1L);
        }
    }

    void exitBackupMode() throws Exception {
    }

    void enterIncrementalBackupMode(long lastLogNumber, boolean deleteOldLogFiles) throws Exception {
        if (!this.mKeepOldLogFiles) {
            throw new IllegalStateException("Incremental backup requires old log files to be kept");
        }
        this.mEnv.logFlush(null);
        if (deleteOldLogFiles && lastLogNumber > 0L && this.mBackupCount == 0 && this.mIncrementalBackupCount == 0) {
            this.deleteOldLogFiles(lastLogNumber);
        }
    }

    void exitIncrementalBackupMode() throws Exception {
    }

    File[] backupDataFiles() throws Exception {
        LinkedHashSet<File> dbFileSet = new LinkedHashSet<File>();
        for (String dbName : this.getAllDatabaseNames()) {
            File file = new File(this.getDatabaseFileName(dbName));
            if (!file.isAbsolute()) {
                file = new File(this.mDataHome, file.getPath());
            }
            if (dbFileSet.contains(file) || !file.exists()) continue;
            dbFileSet.add(file);
        }
        return dbFileSet.toArray(new File[dbFileSet.size()]);
    }

    File[] backupLogFiles(long[] newLastLogNum) throws Exception {
        LinkedHashSet<File> dbFileSet = new LinkedHashSet<File>();
        long maxLogNum = 0L;
        for (File file : this.mEnv.getArchiveLogFiles(true)) {
            long currLogNum = this.getLogFileNum(file.getName());
            if (!file.isAbsolute()) {
                file = new File(this.mEnvHome, file.getPath());
            }
            if (dbFileSet.contains(file) || !file.exists()) continue;
            dbFileSet.add(file);
            if (currLogNum <= maxLogNum) continue;
            maxLogNum = currLogNum;
        }
        newLastLogNum[0] = maxLogNum;
        return dbFileSet.toArray(new File[dbFileSet.size()]);
    }

    File[] incrementalBackup(long lastLogNum, long[] newLastLogNum) throws Exception {
        LinkedHashSet<File> dbFileSet = new LinkedHashSet<File>();
        long maxLogNum = 0L;
        for (File file : this.mEnv.getArchiveLogFiles(true)) {
            long currLogNum = this.getLogFileNum(file.getName());
            if (currLogNum < lastLogNum) continue;
            if (!file.isAbsolute()) {
                file = new File(this.mEnvHome, file.getPath());
            }
            if (dbFileSet.contains(file) || !file.exists()) continue;
            dbFileSet.add(file);
            if (currLogNum <= maxLogNum) continue;
            maxLogNum = currLogNum;
        }
        newLastLogNum[0] = maxLogNum;
        return dbFileSet.toArray(new File[dbFileSet.size()]);
    }

    private void deleteOldLogFiles(long maxLogNum) throws Exception {
        for (File file : this.mEnv.getArchiveLogFiles(false)) {
            long currLogNum = this.getLogFileNum(file.getName());
            if (currLogNum >= maxLogNum) continue;
            file.delete();
        }
    }

    private long getLogFileNum(String fileName) {
        int ix = fileName.indexOf(".");
        return Long.parseLong(fileName.substring(ix + 1));
    }

    static {
        TXN_READ_UNCOMMITTED.setReadUncommitted(true);
        TXN_READ_COMMITTED = new TransactionConfig();
        TXN_READ_COMMITTED.setReadCommitted(true);
        TXN_REPEATABLE_READ = TransactionConfig.DEFAULT;
        TXN_READ_UNCOMMITTED_NOWAIT = new TransactionConfig();
        TXN_READ_UNCOMMITTED_NOWAIT.setReadUncommitted(true);
        TXN_READ_UNCOMMITTED_NOWAIT.setNoWait(true);
        TXN_READ_COMMITTED_NOWAIT = new TransactionConfig();
        TXN_READ_COMMITTED_NOWAIT.setReadCommitted(true);
        TXN_READ_COMMITTED_NOWAIT.setNoWait(true);
        TXN_REPEATABLE_READ_NOWAIT = new TransactionConfig();
        TXN_REPEATABLE_READ_NOWAIT.setNoWait(true);
        TXN_SNAPSHOT = new TransactionConfig();
        try {
            TXN_SNAPSHOT.setSnapshot(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }
}

