/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.PersistDeadlockException;
import com.amazon.carbonado.PersistDeniedException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.LockNotGrantedException;

class DB_ExceptionTransformer
extends ExceptionTransformer {
    private static volatile DB_ExceptionTransformer cInstance;

    public static DB_ExceptionTransformer getInstance() {
        if (cInstance == null) {
            cInstance = new DB_ExceptionTransformer();
        }
        return cInstance;
    }

    DB_ExceptionTransformer() {
    }

    protected FetchException transformIntoFetchException(Throwable e) {
        FetchException fe = super.transformIntoFetchException(e);
        if (fe != null) {
            return fe;
        }
        if (e instanceof DatabaseException) {
            if (e instanceof LockNotGrantedException) {
                return new FetchTimeoutException(e);
            }
            if (e instanceof DeadlockException) {
                return new FetchDeadlockException(e);
            }
            String message = e.getMessage();
            if (message != null) {
                if ((message = message.toUpperCase()).indexOf("DB_LOCK_NOTGRANTED") >= 0) {
                    return new FetchTimeoutException(e);
                }
                if (message.indexOf("DB_LOCK_DEADLOCK") >= 0) {
                    return new FetchDeadlockException(e);
                }
            }
        }
        return null;
    }

    protected PersistException transformIntoPersistException(Throwable e) {
        PersistException pe = super.transformIntoPersistException(e);
        if (pe != null) {
            return pe;
        }
        if (e instanceof DatabaseException) {
            if (e instanceof LockNotGrantedException) {
                return new PersistTimeoutException(e);
            }
            if (e instanceof DeadlockException) {
                return new PersistDeadlockException(e);
            }
            String message = e.getMessage();
            if (message != null) {
                if ((message = message.toUpperCase()).indexOf("READ ONLY") >= 0) {
                    return new PersistDeniedException(e);
                }
                if (message.indexOf("DB_LOCK_NOTGRANTED") >= 0) {
                    return new PersistTimeoutException(e);
                }
                if (message.indexOf("DB_LOCK_DEADLOCK") >= 0) {
                    return new PersistDeadlockException(e);
                }
            }
        }
        return null;
    }
}

