/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.repo.sleepycat.JE_Transaction;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;

class JE_TimeoutTransaction
extends JE_Transaction {
    private final long mOriginalTimeout;
    private long mLockTimeout;

    JE_TimeoutTransaction(JE_Transaction parent, Environment env, long timeout) throws DatabaseException {
        super(parent);
        long originalTimeout = env.getConfig().getLockTimeout();
        this.mOriginalTimeout = originalTimeout <= 0L ? -1L : originalTimeout;
        this.setLockTimeout(timeout);
    }

    private JE_TimeoutTransaction(JE_TimeoutTransaction parent) throws DatabaseException {
        super(parent);
        this.mOriginalTimeout = this.mLockTimeout = parent.mLockTimeout;
    }

    JE_Transaction createChild() throws DatabaseException {
        return new JE_TimeoutTransaction(this);
    }

    void abort() throws DatabaseException {
        super.abort();
        this.mParent.setLockTimeout(this.mOriginalTimeout);
    }

    void setLockTimeout(long timeout) throws DatabaseException {
        this.mParent.setLockTimeout(timeout);
        this.mLockTimeout = timeout;
    }
}

