/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.cojen.util.ThrowUnchecked;

public class TaskQueueThread
extends Thread
implements Executor {
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_SHOULD_STOP = 2;
    private static final int STATE_STOPPED = 3;
    private static final Runnable STOP_TASK = new Runnable(){

        public void run() {
        }
    };
    private final BlockingQueue<Runnable> mQueue;
    private final long mTimeoutMillis;
    private int mState = 0;

    public TaskQueueThread(String name, int queueSize) {
        this(name, queueSize, 0L);
    }

    public TaskQueueThread(String name, int queueSize, long timeoutMillis) {
        super(name);
        this.mQueue = new ArrayBlockingQueue<Runnable>(queueSize, true);
        this.mTimeoutMillis = timeoutMillis;
    }

    public void execute(Runnable task) throws RejectedExecutionException {
        this.execute(task, this.mTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, long timeoutMillis) throws RejectedExecutionException {
        if (task == null) {
            throw new NullPointerException("Cannot accept null task");
        }
        TaskQueueThread taskQueueThread = this;
        synchronized (taskQueueThread) {
            if (this.mState != 1 && this.mState != 0) {
                throw new RejectedExecutionException("Task queue is shutdown");
            }
        }
        try {
            if (!this.mQueue.offer(task, timeoutMillis, TimeUnit.MILLISECONDS)) {
                throw new RejectedExecutionException("Unable to enqueue task after waiting " + timeoutMillis + " milliseconds");
            }
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException(e);
        }
    }

    public synchronized void shutdown() {
        if (this.mState == 3) {
            return;
        }
        if (this.mState == 0) {
            this.mState = 3;
            return;
        }
        this.mState = 2;
        this.mQueue.offer(STOP_TASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block29: {
            TaskQueueThread taskQueueThread = this;
            synchronized (taskQueueThread) {
                if (this.mState == 2 || this.mState == 3) {
                    return;
                }
                if (this.mState == 1) {
                    throw new IllegalStateException("Already running");
                }
                this.mState = 1;
            }
            block22: while (true) {
                while (true) {
                    Runnable task;
                    boolean isStopping;
                    TaskQueueThread taskQueueThread2 = this;
                    synchronized (taskQueueThread2) {
                        isStopping = this.mState != 1;
                    }
                    if (isStopping) {
                        task = (Runnable)this.mQueue.poll();
                    } else {
                        try {
                            task = this.mQueue.take();
                        }
                        catch (InterruptedException e) {
                            break block29;
                        }
                    }
                    if (task == null) break block29;
                    if (task == STOP_TASK) {
                        break block29;
                    }
                    try {
                        task.run();
                        continue block22;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        try {
                            Thread t = Thread.currentThread();
                            t.getUncaughtExceptionHandler().uncaughtException(t, e);
                            continue block22;
                        }
                        catch (Throwable e2) {
                            ThrowUnchecked.fire((Throwable)e);
                            continue;
                        }
                    }
                    break;
                }
            }
            finally {
                TaskQueueThread taskQueueThread3 = this;
                synchronized (taskQueueThread3) {
                    this.mState = 3;
                }
            }
        }
    }
}

