/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import java.util.Comparator;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparators {
    private static final Comparator<byte[]> SignedByteArray = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] a, byte[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                byte ai = a[i];
                byte bi = b[i];
                if (ai == bi) continue;
                return ai - bi;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<byte[]> UnsignedByteArray = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] a, byte[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                byte ai = a[i];
                byte bi = b[i];
                if (ai == bi) continue;
                return (ai & 0xFF) - (bi & 0xFF);
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<short[]> SignedShortArray = new Comparator<short[]>(){

        @Override
        public int compare(short[] a, short[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                short ai = a[i];
                short bi = b[i];
                if (ai == bi) continue;
                return ai - bi;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<short[]> UnsignedShortArray = new Comparator<short[]>(){

        @Override
        public int compare(short[] a, short[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                short ai = a[i];
                short bi = b[i];
                if (ai == bi) continue;
                return (ai & 0xFFFF) - (bi & 0xFFFF);
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<int[]> SignedIntArray = new Comparator<int[]>(){

        @Override
        public int compare(int[] a, int[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                int ai = a[i];
                int bi = b[i];
                if (ai == bi) continue;
                return ai < bi ? -1 : 1;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<int[]> UnsignedIntArray = new Comparator<int[]>(){

        @Override
        public int compare(int[] a, int[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                int ai = a[i];
                int bi = b[i];
                if (ai == bi) continue;
                return ((long)ai & 0xFFFFFFFFL) < ((long)bi & 0xFFFFFFFFL) ? -1 : 1;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<long[]> SignedLongArray = new Comparator<long[]>(){

        @Override
        public int compare(long[] a, long[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                long ai = a[i];
                long bi = b[i];
                if (ai == bi) continue;
                return ai < bi ? -1 : 1;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<long[]> UnsignedLongArray = new Comparator<long[]>(){

        @Override
        public int compare(long[] a, long[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                long ai = a[i];
                long bi = b[i];
                if (ai == bi) continue;
                long sai = ai >>> 1;
                long sbi = bi >>> 1;
                if (sai < sbi) {
                    return -1;
                }
                if (sai > sbi) {
                    return 1;
                }
                return (ai & 1L) == 0L ? -1 : 1;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<boolean[]> BooleanArray = new Comparator<boolean[]>(){

        @Override
        public int compare(boolean[] a, boolean[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                boolean ai = a[i];
                boolean bi = b[i];
                if (ai == bi) continue;
                return ai ? 1 : -1;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<char[]> CharArray = new Comparator<char[]>(){

        @Override
        public int compare(char[] a, char[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                char ai = a[i];
                char bi = b[i];
                if (ai == bi) continue;
                return ai - bi;
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<float[]> FloatArray = new Comparator<float[]>(){

        @Override
        public int compare(float[] a, float[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                float ai = a[i];
                float bi = b[i];
                if (ai == bi) continue;
                return Float.compare(ai, bi);
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<double[]> DoubleArray = new Comparator<double[]>(){

        @Override
        public int compare(double[] a, double[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                double ai = a[i];
                double bi = b[i];
                if (ai == bi) continue;
                return Double.compare(ai, bi);
            }
            return a.length - b.length;
        }
    };
    private static final Comparator<Comparable[]> ComparableArray = new Comparator<Comparable[]>(){

        @Override
        public int compare(Comparable[] a, Comparable[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                Comparable ai = a[i];
                Comparable bi = b[i];
                if (ai == bi) continue;
                if (ai == null) {
                    return 1;
                }
                if (bi == null) {
                    return -1;
                }
                int compare = ai.compareTo(bi);
                if (compare == 0) continue;
                return compare;
            }
            return a.length - b.length;
        }
    };

    public static <T> Comparator<T> arrayComparator(Class<T> arrayType, boolean unsigned) {
        Comparator<Object[]> c;
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException();
        }
        TypeDesc componentType = TypeDesc.forClass(arrayType.getComponentType());
        switch (componentType.getTypeCode()) {
            case 8: {
                c = unsigned ? UnsignedByteArray : SignedByteArray;
                break;
            }
            case 9: {
                c = unsigned ? UnsignedShortArray : SignedShortArray;
                break;
            }
            case 10: {
                c = unsigned ? UnsignedIntArray : SignedIntArray;
                break;
            }
            case 11: {
                c = unsigned ? UnsignedLongArray : SignedLongArray;
                break;
            }
            case 4: {
                c = BooleanArray;
                break;
            }
            case 5: {
                c = CharArray;
                break;
            }
            case 6: {
                c = FloatArray;
                break;
            }
            case 7: {
                c = DoubleArray;
                break;
            }
            default: {
                c = componentType.isArray() ? new ComparatorArray(Comparators.arrayComparator(componentType.toClass(), unsigned)) : (Comparable.class.isAssignableFrom(componentType.toClass()) ? ComparableArray : null);
            }
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparatorArray
    implements Comparator<Object[]> {
        private final Comparator<Object> mComparator;

        ComparatorArray(Comparator<Object> comparator) {
            this.mComparator = comparator;
        }

        @Override
        public int compare(Object[] a, Object[] b) {
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                Object ai = a[i];
                Object bi = b[i];
                if (ai == bi) continue;
                if (ai == null) {
                    return 1;
                }
                if (bi == null) {
                    return -1;
                }
                int compare = this.mComparator.compare(ai, bi);
                if (compare == 0) continue;
                return compare;
            }
            return a.length - b.length;
        }
    }
}

