/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.synthetic;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.SortedCursor;
import com.amazon.carbonado.synthetic.SyntheticKey;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Comparator;
import java.util.Iterator;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticStorableReferenceAccess<S extends Storable> {
    private final Class<S> mMasterClass;
    private final Class<? extends Storable> mReferenceClass;
    private final Comparator<? extends Storable> mComparator;
    private final Method mCopyFromMasterMethod;
    private final Method mIsConsistentMethod;
    private final Method mCopyToMasterPkMethod;

    SyntheticStorableReferenceAccess(Class<S> masterClass, Class<? extends Storable> referenceClass, SyntheticStorableReferenceBuilder builder) {
        this.mMasterClass = masterClass;
        this.mReferenceClass = referenceClass;
        SyntheticKey pk = builder.mPrimaryKey;
        String[] orderBy = new String[pk.getPropertyCount()];
        int i = 0;
        Iterator<String> it = pk.getProperties();
        while (it.hasNext()) {
            orderBy[i++] = it.next();
        }
        this.mComparator = SortedCursor.createComparator(referenceClass, orderBy);
        try {
            this.mCopyFromMasterMethod = referenceClass.getMethod(builder.mCopyFromMasterMethodName, masterClass);
            this.mIsConsistentMethod = referenceClass.getMethod(builder.mIsConsistentMethodName, masterClass);
            this.mCopyToMasterPkMethod = referenceClass.getMethod(builder.mCopyToMasterPkMethodName, masterClass);
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public Class<S> getMasterClass() {
        return this.mMasterClass;
    }

    public Class<? extends Storable> getReferenceClass() {
        return this.mReferenceClass;
    }

    public Comparator<? extends Storable> getComparator() {
        return this.mComparator;
    }

    public void copyToMasterPrimaryKey(Storable reference, S master) throws FetchException {
        try {
            this.mCopyToMasterPkMethod.invoke((Object)reference, master);
        }
        catch (Exception e) {
            ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[]{FetchException.class});
        }
    }

    public void copyFromMaster(Storable reference, S master) throws FetchException {
        try {
            this.mCopyFromMasterMethod.invoke((Object)reference, master);
        }
        catch (Exception e) {
            ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[]{FetchException.class});
        }
    }

    public boolean isConsistent(Storable reference, S master) throws FetchException {
        try {
            return (Boolean)this.mIsConsistentMethod.invoke((Object)reference, master);
        }
        catch (Exception e) {
            ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[]{FetchException.class});
            return false;
        }
    }
}

