/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class RepairExecutor {
    static final ThreadLocal<RepairExecutor> cExecutor;
    private final int mKeepAliveSeconds;
    private BlockingQueue<Runnable> mQueue;
    private Worker mWorker;
    private boolean mIdle = true;

    public static void execute(Runnable repair) {
        cExecutor.get().executeIt(repair);
    }

    public static boolean waitForRepairsToFinish(long timeoutMillis) throws InterruptedException {
        return cExecutor.get().waitToFinish(timeoutMillis);
    }

    private RepairExecutor(int keepAliveSeconds, int queueSize) {
        this.mKeepAliveSeconds = keepAliveSeconds;
        this.mQueue = new LinkedBlockingQueue<Runnable>(queueSize);
    }

    private synchronized void executeIt(Runnable repair) {
        this.mQueue.offer(repair);
        if (this.mWorker == null) {
            this.mWorker = new Worker();
            this.mWorker.start();
        }
    }

    private synchronized boolean waitToFinish(long timeoutMillis) throws InterruptedException {
        block6: {
            if (this.mIdle && this.mQueue.size() == 0) {
                return true;
            }
            if (this.mWorker == null) {
                this.mWorker = new Worker();
                this.mWorker.start();
            }
            if (timeoutMillis == 0L) break block6;
            if (timeoutMillis < 0L) {
                while (!this.mIdle || this.mQueue.size() > 0) {
                    this.wait();
                }
            } else {
                long start = System.currentTimeMillis();
                while (!(timeoutMillis <= 0L || this.mIdle && this.mQueue.size() <= 0)) {
                    this.wait(timeoutMillis);
                    long now = System.currentTimeMillis();
                    timeoutMillis -= now - start;
                    start = now;
                }
            }
        }
        return this.mQueue.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable dequeue() throws InterruptedException {
        while (true) {
            RepairExecutor repairExecutor = this;
            synchronized (repairExecutor) {
                this.mIdle = true;
                this.notify();
            }
            Runnable task = this.mQueue.poll(this.mKeepAliveSeconds, TimeUnit.SECONDS);
            RepairExecutor repairExecutor2 = this;
            synchronized (repairExecutor2) {
                if (task != null) {
                    this.mIdle = false;
                    return task;
                }
                if (this.mQueue.size() == 0) {
                    this.notify();
                    this.mWorker = null;
                    return null;
                }
            }
        }
    }

    static {
        final int keepAliveSeconds = Integer.getInteger("com.amazon.carbonado.spi.RepairExecutor.keepAliveSeconds", 10);
        final int queueSize = Integer.getInteger("com.amazon.carbonado.spi.RepairExecutor.queueSize", 10000);
        cExecutor = new ThreadLocal<RepairExecutor>(){

            @Override
            protected RepairExecutor initialValue() {
                return new RepairExecutor(keepAliveSeconds, queueSize);
            }
        };
    }

    private class Worker
    extends Thread {
        Worker() {
            this.setDaemon(true);
            this.setName(Thread.currentThread().getName() + " (repository repair)");
        }

        public void run() {
            while (true) {
                try {
                    Runnable task;
                    while ((task = RepairExecutor.this.dequeue()) != null) {
                        task.run();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (ThreadDeath e) {
                }
                catch (Throwable e) {
                    try {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                        continue;
                    }
                    catch (ThreadDeath e2) {
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                break;
            }
        }
    }
}

