/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.spi.LobEngine;
import com.amazon.carbonado.spi.LobProperty;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlobProperty
extends LobProperty<Blob> {
    BlobProperty(LobEngine engine, String propertyName) {
        super(engine, propertyName);
    }

    @Override
    Blob createNewLob(int blockSize) throws PersistException {
        return this.mEngine.createNewBlob(blockSize);
    }

    @Override
    void setLobValue(long locator, Blob data) throws PersistException {
        try {
            this.mEngine.setBlobValue(locator, data);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw ((RepositoryException)cause).toPersistException();
            }
            throw new PersistException(e);
        }
    }
}

