/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.Query;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.util.BelatedCreator;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BelatedStorageCreator<S extends Storable>
extends BelatedCreator<Storage<S>, SupportException> {
    final Log mLog;
    final Repository mRepo;
    final Class<S> mStorableType;

    public BelatedStorageCreator(Log log, Repository repo, Class<S> storableType, int minRetryDelayMillis) {
        super(Storage.class, minRetryDelayMillis);
        this.mLog = log;
        this.mRepo = repo;
        this.mStorableType = storableType;
    }

    @Override
    protected Storage<S> createReal() throws SupportException {
        Exception error;
        try {
            return this.mRepo.storageFor(this.mStorableType);
        }
        catch (SupportException e) {
            throw e;
        }
        catch (RepositoryException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException) {
                throw new SupportException(cause);
            }
            error = e;
        }
        catch (Exception e) {
            error = e;
        }
        this.mLog.error((Object)("Error getting Storage of type \"" + this.mStorableType.getName() + '\"'), (Throwable)error);
        return null;
    }

    @Override
    protected Storage<S> createBogus() {
        return new BogusStorage();
    }

    @Override
    protected void timedOutNotification(long timedOutMillis) {
        this.mLog.error((Object)("Timed out waiting to get Storage of type \"" + this.mStorableType.getName() + "\" after waiting " + timedOutMillis + " milliseconds"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BogusStorage
    implements Storage<S> {
        private BogusStorage() {
        }

        @Override
        public Class<S> getStorableType() {
            return BelatedStorageCreator.this.mStorableType;
        }

        @Override
        public S prepare() {
            throw this.error();
        }

        @Override
        public Query<S> query() {
            throw this.error();
        }

        @Override
        public Query<S> query(String filter) {
            throw this.error();
        }

        @Override
        public Query<S> query(Filter<S> filter) {
            throw this.error();
        }

        public Repository getRepository() {
            return BelatedStorageCreator.this.mRepo;
        }

        @Override
        public void truncate() {
            throw this.error();
        }

        @Override
        public boolean addTrigger(Trigger<? super S> trigger) {
            throw this.error();
        }

        @Override
        public boolean removeTrigger(Trigger<? super S> trigger) {
            throw this.error();
        }

        private IllegalStateException error() {
            return new IllegalStateException("Creation of Storage for type \"" + BelatedStorageCreator.this.mStorableType.getName() + "\" is delayed");
        }
    }
}

