/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.replicated;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.OptimisticLockException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.capability.ResyncCapability;
import com.amazon.carbonado.repo.replicated.BlobReplicationTrigger;
import com.amazon.carbonado.repo.replicated.ClobReplicationTrigger;
import com.amazon.carbonado.repo.replicated.ReplicatedRepository;
import com.amazon.carbonado.spi.RepairExecutor;
import com.amazon.carbonado.spi.TriggerManager;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicationTrigger<S extends Storable>
extends Trigger<S> {
    private final Repository mRepository;
    private final Storage<S> mReplicaStorage;
    private final Storage<S> mMasterStorage;
    private final TriggerManager<S> mTriggerManager;

    ReplicationTrigger(Repository repository, Storage<S> replicaStorage, Storage<S> masterStorage) {
        ClobReplicationTrigger<S> clobTrigger;
        this.mRepository = repository;
        this.mReplicaStorage = replicaStorage;
        this.mMasterStorage = masterStorage;
        this.mTriggerManager = new TriggerManager();
        this.mTriggerManager.addTrigger(this);
        BlobReplicationTrigger<S> blobTrigger = BlobReplicationTrigger.create(masterStorage);
        if (blobTrigger != null) {
            this.mTriggerManager.addTrigger(blobTrigger);
        }
        if ((clobTrigger = ClobReplicationTrigger.create(masterStorage)) != null) {
            this.mTriggerManager.addTrigger(clobTrigger);
        }
        replicaStorage.addTrigger(this.mTriggerManager);
    }

    @Override
    public Object beforeInsert(S replica) throws PersistException {
        return this.beforeInsert(replica, false);
    }

    @Override
    public Object beforeTryInsert(S replica) throws PersistException {
        return this.beforeInsert(replica, true);
    }

    private Object beforeInsert(S replica, boolean forTry) throws PersistException {
        S master = this.mMasterStorage.prepare();
        replica.copyAllProperties(master);
        try {
            if (forTry) {
                if (!master.tryInsert()) {
                    throw this.abortTry();
                }
            } else {
                master.insert();
            }
        }
        catch (UniqueConstraintException e) {
            this.repair(replica);
            throw e;
        }
        replica.markPropertiesDirty();
        master.copyAllProperties(replica);
        return null;
    }

    @Override
    public Object beforeUpdate(S replica) throws PersistException {
        return this.beforeUpdate(replica, false);
    }

    @Override
    public Object beforeTryUpdate(S replica) throws PersistException {
        return this.beforeUpdate(replica, true);
    }

    private Object beforeUpdate(S replica, boolean forTry) throws PersistException {
        S master;
        block8: {
            master = this.mMasterStorage.prepare();
            replica.copyPrimaryKeyProperties(master);
            replica.copyVersionProperty(master);
            replica.copyDirtyProperties(master);
            try {
                if (forTry) {
                    if (!master.tryUpdate()) {
                        if (this.tryDeleteReplica((Storable)replica)) {
                            this.repair(replica);
                        }
                        throw this.abortTry();
                    }
                    break block8;
                }
                try {
                    master.update();
                }
                catch (PersistNoneException e) {
                    if (this.tryDeleteReplica((Storable)replica)) {
                        this.repair(replica);
                    }
                    throw e;
                }
            }
            catch (OptimisticLockException e) {
                this.repair(replica);
                throw e;
            }
        }
        master.copyUnequalProperties(replica);
        return null;
    }

    @Override
    public Object beforeDelete(S replica) throws PersistException {
        S master = this.mMasterStorage.prepare();
        replica.copyPrimaryKeyProperties(master);
        master.tryDelete();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resyncEntries(ResyncCapability.Listener<? super S> listener, S replicaEntry, S masterEntry) throws FetchException, PersistException {
        if (replicaEntry == null && masterEntry == null) {
            return;
        }
        Log log = LogFactory.getLog(ReplicatedRepository.class);
        this.setReplicationDisabled();
        try {
            Transaction txn = this.mRepository.enterTransaction();
            try {
                Object state;
                S newReplicaEntry;
                block29: {
                    if (replicaEntry == null) {
                        newReplicaEntry = this.mReplicaStorage.prepare();
                        masterEntry.copyAllProperties(newReplicaEntry);
                        log.info((Object)("Inserting missing replica entry: " + newReplicaEntry));
                    } else if (masterEntry != null) {
                        if (replicaEntry.equalProperties(masterEntry)) {
                            return;
                        }
                        newReplicaEntry = this.mReplicaStorage.prepare();
                        this.transferToReplicaEntry(replicaEntry, masterEntry, newReplicaEntry);
                        log.info((Object)("Updating stale replica entry with: " + newReplicaEntry));
                    } else {
                        newReplicaEntry = null;
                        log.info((Object)("Deleting bogus replica entry: " + replicaEntry));
                    }
                    state = listener == null ? null : (replicaEntry == null ? listener.beforeInsert(newReplicaEntry) : (masterEntry != null ? listener.beforeUpdate(replicaEntry, newReplicaEntry) : listener.beforeDelete(replicaEntry)));
                    if (replicaEntry == null) break block29;
                    try {
                        replicaEntry.tryDelete();
                    }
                    catch (PersistException e) {
                        log.error((Object)("Unable to delete replica entry: " + replicaEntry), (Throwable)e);
                        if (masterEntry == null) break block29;
                        log.info((Object)("Updating corrupt replica entry with: " + newReplicaEntry));
                        try {
                            newReplicaEntry.update();
                            masterEntry = null;
                        }
                        catch (PersistException e2) {
                            log.error((Object)("Unable to update replica entry: " + replicaEntry), (Throwable)e2);
                            this.resyncFailed(listener, replicaEntry, masterEntry, newReplicaEntry, state);
                            txn.exit();
                            this.setReplicationEnabled();
                            return;
                        }
                    }
                }
                try {
                    if (masterEntry != null && newReplicaEntry != null && !newReplicaEntry.tryInsert()) {
                        newReplicaEntry.tryDelete();
                        newReplicaEntry.tryInsert();
                    }
                    if (listener != null) {
                        if (replicaEntry == null) {
                            listener.afterInsert(newReplicaEntry, state);
                        } else if (masterEntry != null) {
                            listener.afterUpdate(newReplicaEntry, state);
                        } else {
                            listener.afterDelete(replicaEntry, state);
                        }
                    }
                    txn.commit();
                }
                catch (Throwable e) {
                    this.resyncFailed(listener, replicaEntry, masterEntry, newReplicaEntry, state);
                    ThrowUnchecked.fire((Throwable)e);
                }
            }
            finally {
                txn.exit();
            }
        }
        finally {
            this.setReplicationEnabled();
        }
    }

    private void resyncFailed(ResyncCapability.Listener<? super S> listener, S replicaEntry, S masterEntry, S newReplicaEntry, Object state) {
        if (listener != null) {
            try {
                if (replicaEntry == null) {
                    listener.failedInsert(newReplicaEntry, state);
                } else if (masterEntry != null) {
                    listener.failedUpdate(newReplicaEntry, state);
                } else {
                    listener.failedDelete(replicaEntry, state);
                }
            }
            catch (Throwable e2) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e2);
            }
        }
    }

    private void transferToReplicaEntry(S replicaEntry, S masterEntry, S newReplicaEntry) {
        try {
            replicaEntry.copyUnequalProperties(newReplicaEntry);
        }
        catch (IllegalArgumentException e) {
            Map<String, Object> propertyMap = replicaEntry.propertyMap();
            for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
                String name = entry.getKey();
                Object oldValue = entry.getValue();
                try {
                    Object newValue = newReplicaEntry.getPropertyValue(name);
                    if (!(oldValue == null ? newValue != null : !oldValue.equals(newValue))) continue;
                    newReplicaEntry.setPropertyValue(name, oldValue);
                }
                catch (IllegalArgumentException e2) {
                }
                catch (UnsupportedOperationException e2) {}
            }
        }
        masterEntry.copyAllProperties(newReplicaEntry);
    }

    private void repair(S replica) throws PersistException {
        replica = replica.copy();
        S master = this.mMasterStorage.prepare();
        replica.copyAllProperties(master);
        try {
            if (replica.tryLoad() ? master.tryLoad() && replica.equalProperties(master) : !master.tryLoad()) {
                return;
            }
        }
        catch (IllegalStateException e) {
            return;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        S finalReplica = replica;
        S finalMaster = master;
        RepairExecutor.execute(new Runnable((Storable)finalReplica, (Storable)finalMaster){
            final /* synthetic */ Storable val$finalReplica;
            final /* synthetic */ Storable val$finalMaster;
            {
                this.val$finalReplica = storable;
                this.val$finalMaster = storable2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Transaction txn = ReplicationTrigger.this.mRepository.enterTransaction();
                    try {
                        txn.setForUpdate(true);
                        if (this.val$finalReplica.tryLoad()) {
                            if (this.val$finalMaster.tryLoad()) {
                                ReplicationTrigger.this.resyncEntries(null, this.val$finalReplica, this.val$finalMaster);
                            } else {
                                ReplicationTrigger.this.resyncEntries(null, this.val$finalReplica, null);
                            }
                        } else if (this.val$finalMaster.tryLoad()) {
                            ReplicationTrigger.this.resyncEntries(null, null, this.val$finalMaster);
                        }
                        txn.commit();
                    }
                    finally {
                        txn.exit();
                    }
                }
                catch (FetchException fe) {
                    Log log = LogFactory.getLog(ReplicatedRepository.class);
                    log.warn((Object)("Unable to check if repair is required for " + this.val$finalReplica.toStringKeyOnly()), (Throwable)fe);
                }
                catch (PersistException pe) {
                    Log log = LogFactory.getLog(ReplicatedRepository.class);
                    log.error((Object)("Unable to repair entry " + this.val$finalReplica.toStringKeyOnly()), (Throwable)pe);
                }
            }
        });
    }

    boolean addTrigger(Trigger<? super S> trigger) {
        return this.mTriggerManager.addTrigger(trigger);
    }

    boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mTriggerManager.removeTrigger(trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryDeleteReplica(Storable replica) throws PersistException {
        TriggerManager<S> tm = this.mTriggerManager;
        tm.locallyDisableDelete();
        try {
            boolean bl = replica.tryDelete();
            return bl;
        }
        finally {
            tm.locallyEnableDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteReplica(Storable replica) throws PersistException {
        TriggerManager<S> tm = this.mTriggerManager;
        tm.locallyDisableDelete();
        try {
            replica.delete();
        }
        finally {
            tm.locallyEnableDelete();
        }
    }

    void setReplicationDisabled() {
        TriggerManager<S> tm = this.mTriggerManager;
        tm.locallyDisableInsert();
        tm.locallyDisableUpdate();
        tm.locallyDisableDelete();
        tm.locallyDisableLoad();
    }

    void setReplicationEnabled() {
        TriggerManager<S> tm = this.mTriggerManager;
        tm.locallyEnableInsert();
        tm.locallyEnableUpdate();
        tm.locallyEnableDelete();
        tm.locallyEnableLoad();
    }
}

