/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistInterruptedException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.cursor.ArraySortBuffer;
import com.amazon.carbonado.cursor.ControllerCursor;
import com.amazon.carbonado.cursor.EmptyCursor;
import com.amazon.carbonado.cursor.FilteredCursor;
import com.amazon.carbonado.cursor.SingletonCursor;
import com.amazon.carbonado.cursor.SortBuffer;
import com.amazon.carbonado.cursor.SortedCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.gen.DelegateStorableGenerator;
import com.amazon.carbonado.gen.DelegateSupport;
import com.amazon.carbonado.gen.MasterFeature;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.qe.BoundaryType;
import com.amazon.carbonado.qe.QueryEngine;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.repo.map.Key;
import com.amazon.carbonado.repo.map.MapCursor;
import com.amazon.carbonado.repo.map.MapRepository;
import com.amazon.carbonado.repo.map.MapTransaction;
import com.amazon.carbonado.repo.map.UpgradableLock;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.IndexInfoImpl;
import com.amazon.carbonado.spi.LobEngine;
import com.amazon.carbonado.spi.TriggerManager;
import com.amazon.carbonado.txn.TransactionScope;
import com.amazon.carbonado.util.QuickConstructorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapStorage<S extends Storable>
implements Storage<S>,
DelegateSupport<S>,
StorageAccess<S> {
    private static final int DEFAULT_LOB_BLOCK_SIZE = 1000;
    private static final Object[] NO_VALUES = new Object[0];
    private final MapRepository mRepo;
    private final StorableInfo<S> mInfo;
    private final TriggerManager<S> mTriggers;
    private final InstanceFactory mInstanceFactory;
    private final StorableIndex<S> mPrimaryKeyIndex;
    private final QueryEngine<S> mQueryEngine;
    private final int mLockTimeout;
    private final TimeUnit mLockTimeoutUnit;
    private final ConcurrentNavigableMap<Key<S>, S> mMap;
    private final Comparator<S> mFullComparator;
    private final Comparator<S>[] mSearchComparators;
    private final Key.Assigner<S> mKeyAssigner;
    final UpgradableLock<Object> mLock = new UpgradableLock<Object>(){

        @Override
        protected boolean isReadLockHeld(Object locker) {
            return locker instanceof MapTransaction;
        }
    };

    MapStorage(MapRepository repo, Class<S> type, int lockTimeout, TimeUnit lockTimeoutUnit) throws SupportException {
        this.mRepo = repo;
        this.mInfo = StorableIntrospector.examine(type);
        this.mTriggers = new TriggerManager();
        EnumSet<MasterFeature> features = repo.isMaster() ? EnumSet.of(MasterFeature.INSERT_CHECK_REQUIRED, MasterFeature.NORMALIZE, MasterFeature.VERSIONING, MasterFeature.INSERT_SEQUENCES) : EnumSet.of(MasterFeature.INSERT_CHECK_REQUIRED, MasterFeature.NORMALIZE);
        Class<S> delegateStorableClass = DelegateStorableGenerator.getDelegateClass(type, features);
        this.mInstanceFactory = QuickConstructorGenerator.getInstance(delegateStorableClass, InstanceFactory.class);
        this.mPrimaryKeyIndex = new StorableIndex<S>(this.mInfo.getPrimaryKey(), Direction.ASCENDING).clustered(true);
        this.mQueryEngine = new QueryEngine<S>(type, repo);
        this.mLockTimeout = lockTimeout;
        this.mLockTimeoutUnit = lockTimeoutUnit;
        this.mMap = new ConcurrentSkipListMap<Key<S>, S>();
        List<OrderedProperty<S>> propList = this.createPkPropList();
        this.mFullComparator = SortedCursor.createComparator(propList);
        this.mSearchComparators = new Comparator[propList.size() + 1];
        this.mSearchComparators[propList.size()] = this.mFullComparator;
        this.mKeyAssigner = Key.getAssigner(type);
        try {
            if (LobEngine.hasLobs(type)) {
                Trigger<S> lobTrigger = repo.getLobEngine().getSupportTrigger(type, 1000);
                this.addTrigger(lobTrigger);
            }
            this.mTriggers.addTriggers(type, repo.mTriggerFactories);
        }
        catch (SupportException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new SupportException(e);
        }
    }

    @Override
    public Class<S> getStorableType() {
        return this.mInfo.getStorableType();
    }

    @Override
    public S prepare() {
        return (S)this.mInstanceFactory.instantiate(this);
    }

    @Override
    public Query<S> query() throws FetchException {
        return this.mQueryEngine.query();
    }

    @Override
    public Query<S> query(String filter) throws FetchException {
        return this.mQueryEngine.query(filter);
    }

    @Override
    public Query<S> query(Filter<S> filter) throws FetchException {
        return this.mQueryEngine.query(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws PersistException {
        block7: {
            try {
                TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
                MapTransaction txn = scope.getTxn();
                if (txn == null) {
                    this.doLockForWrite(scope);
                    try {
                        this.mMap.clear();
                        break block7;
                    }
                    finally {
                        this.mLock.unlockFromWrite(scope);
                    }
                }
                txn.lockForWrite(this.mLock);
                this.mMap.clear();
            }
            catch (PersistException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PersistException(e);
            }
        }
    }

    @Override
    public boolean addTrigger(Trigger<? super S> trigger) {
        return this.mTriggers.addTrigger(trigger);
    }

    @Override
    public boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mTriggers.removeTrigger(trigger);
    }

    public IndexInfo[] getIndexInfo() {
        StorableIndex<S> pkIndex = this.mPrimaryKeyIndex;
        if (pkIndex == null) {
            return new IndexInfo[0];
        }
        int i = pkIndex.getPropertyCount();
        String[] propertyNames = new String[i];
        Direction[] directions = new Direction[i];
        while (--i >= 0) {
            propertyNames[i] = pkIndex.getProperty(i).getName();
            directions[i] = pkIndex.getPropertyDirection(i);
        }
        return new IndexInfo[]{new IndexInfoImpl(this.getStorableType().getName(), true, true, propertyNames, directions)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doTryLoad(S storable) throws FetchException {
        try {
            TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
            MapTransaction txn = scope.getTxn();
            if (txn == null) {
                this.doLockForRead(scope);
                try {
                    boolean bl = this.doTryLoadNoLock(storable);
                    return bl;
                }
                finally {
                    this.mLock.unlockFromRead(scope);
                }
            }
            boolean isForUpdate = scope.isForUpdate();
            txn.lockForUpgrade(this.mLock, isForUpdate);
            try {
                boolean bl = this.doTryLoadNoLock(storable);
                return bl;
            }
            finally {
                txn.unlockFromUpgrade(this.mLock, isForUpdate);
            }
        }
        catch (FetchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FetchException(e);
        }
    }

    boolean doTryLoadNoLock(S storable) {
        Storable existing = (Storable)this.mMap.get(new Key<S>(storable, this.mFullComparator));
        if (existing == null) {
            return false;
        }
        storable.markAllPropertiesDirty();
        existing.copyAllProperties(storable);
        storable.markAllPropertiesClean();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doTryInsert(S storable) throws PersistException {
        try {
            TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
            MapTransaction txn = scope.getTxn();
            if (txn != null) {
                txn.lockForWrite(this.mLock);
                if (!this.doTryInsertNoLock(storable)) return false;
                txn.inserted(this, storable);
                return true;
            }
            this.doLockForUpgrade(scope);
            try {
                boolean bl = this.doTryInsertNoLock(storable);
                return bl;
            }
            finally {
                this.mLock.unlockFromUpgrade(scope);
            }
        }
        catch (PersistException e) {
            throw e;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        catch (Exception e) {
            throw new PersistException(e);
        }
    }

    private boolean doTryInsertNoLock(S storable) {
        Object copy = storable.prepare();
        storable.copyAllProperties(copy);
        copy.markAllPropertiesClean();
        Key key = new Key(copy, this.mFullComparator);
        Storable existing = (Storable)this.mMap.get(key);
        if (existing != null) {
            return false;
        }
        this.mMap.put(key, copy);
        storable.markAllPropertiesClean();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doTryUpdate(S storable) throws PersistException {
        try {
            TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
            MapTransaction txn = scope.getTxn();
            if (txn == null) {
                this.doLockForWrite(scope);
                try {
                    boolean bl = this.doTryUpdateNoLock(storable);
                    return bl;
                }
                finally {
                    this.mLock.unlockFromWrite(scope);
                }
            }
            txn.lockForWrite(this.mLock);
            Storable existing = (Storable)this.mMap.get(new Key<Storable>(storable, this.mFullComparator));
            if (existing == null) {
                return false;
            }
            txn.updated(this, existing.copy());
            existing.markAllPropertiesDirty();
            storable.copyDirtyProperties(existing);
            existing.markAllPropertiesClean();
            storable.markAllPropertiesDirty();
            existing.copyAllProperties(storable);
            storable.markAllPropertiesClean();
            return true;
        }
        catch (PersistException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistException(e);
        }
    }

    private boolean doTryUpdateNoLock(S storable) {
        Storable existing = (Storable)this.mMap.get(new Key<S>(storable, this.mFullComparator));
        if (existing == null) {
            return false;
        }
        existing.markAllPropertiesDirty();
        storable.copyDirtyProperties((Storable)existing);
        existing.markAllPropertiesClean();
        storable.markAllPropertiesDirty();
        existing.copyAllProperties(storable);
        storable.markAllPropertiesClean();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doTryDelete(S storable) throws PersistException {
        try {
            TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
            MapTransaction txn = scope.getTxn();
            if (txn == null) {
                this.doLockForUpgrade(scope);
                try {
                    boolean bl = this.doTryDeleteNoLock(storable);
                    return bl;
                }
                finally {
                    this.mLock.unlockFromUpgrade(scope);
                }
            }
            txn.lockForWrite(this.mLock);
            Storable existing = (Storable)this.mMap.remove(new Key<S>(storable, this.mFullComparator));
            if (existing == null) {
                return false;
            }
            txn.deleted(this, existing);
            return true;
        }
        catch (PersistException e) {
            throw e;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        catch (Exception e) {
            throw new PersistException(e);
        }
    }

    private boolean doTryDeleteNoLock(S storable) {
        return this.mMap.remove(new Key<S>(storable, this.mFullComparator)) != null;
    }

    void mapPut(S storable) {
        this.mMap.put(new Key<S>(storable, this.mFullComparator), storable);
    }

    void mapRemove(S storable) {
        this.mMap.remove(new Key<S>(storable, this.mFullComparator));
    }

    private void doLockForRead(Object locker) throws FetchException {
        try {
            if (!this.mLock.tryLockForRead(locker, this.mLockTimeout, this.mLockTimeoutUnit)) {
                throw new FetchTimeoutException("" + this.mLockTimeout + ' ' + this.mLockTimeoutUnit.toString().toLowerCase());
            }
        }
        catch (InterruptedException e) {
            throw new FetchInterruptedException(e);
        }
    }

    private void doLockForUpgrade(Object locker) throws FetchException {
        try {
            if (!this.mLock.tryLockForUpgrade(locker, this.mLockTimeout, this.mLockTimeoutUnit)) {
                throw new FetchTimeoutException("" + this.mLockTimeout + ' ' + this.mLockTimeoutUnit.toString().toLowerCase());
            }
        }
        catch (InterruptedException e) {
            throw new FetchInterruptedException(e);
        }
    }

    private void doLockForWrite(Object locker) throws PersistException {
        try {
            if (!this.mLock.tryLockForWrite(locker, this.mLockTimeout, this.mLockTimeoutUnit)) {
                throw new PersistTimeoutException("" + this.mLockTimeout + ' ' + this.mLockTimeoutUnit.toString().toLowerCase());
            }
        }
        catch (InterruptedException e) {
            throw new PersistInterruptedException(e);
        }
    }

    @Override
    public Repository getRootRepository() {
        return this.mRepo.getRootRepository();
    }

    @Override
    public boolean isPropertySupported(String propertyName) {
        return this.mInfo.getAllProperties().containsKey(propertyName);
    }

    @Override
    public Trigger<? super S> getInsertTrigger() {
        return this.mTriggers.getInsertTrigger();
    }

    @Override
    public Trigger<? super S> getUpdateTrigger() {
        return this.mTriggers.getUpdateTrigger();
    }

    @Override
    public Trigger<? super S> getDeleteTrigger() {
        return this.mTriggers.getDeleteTrigger();
    }

    @Override
    public Trigger<? super S> getLoadTrigger() {
        return this.mTriggers.getLoadTrigger();
    }

    @Override
    public void locallyDisableLoadTrigger() {
        this.mTriggers.locallyDisableLoad();
    }

    @Override
    public void locallyEnableLoadTrigger() {
        this.mTriggers.locallyEnableLoad();
    }

    @Override
    public SequenceValueProducer getSequenceValueProducer(String name) throws PersistException {
        try {
            return this.mRepo.getSequenceValueProducer(name);
        }
        catch (RepositoryException e) {
            throw e.toPersistException();
        }
    }

    @Override
    public QueryExecutorFactory<S> getQueryExecutorFactory() {
        return this.mQueryEngine;
    }

    @Override
    public Collection<StorableIndex<S>> getAllIndexes() {
        return Collections.singletonList(this.mPrimaryKeyIndex);
    }

    @Override
    public Storage<S> storageDelegate(StorableIndex<S> index) {
        return null;
    }

    @Override
    public long countAll() throws FetchException {
        return this.countAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countAll(Query.Controller controller) throws FetchException {
        try {
            TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
            MapTransaction txn = scope.getTxn();
            if (txn == null) {
                this.doLockForRead(scope);
                try {
                    long l = this.mMap.size();
                    return l;
                }
                finally {
                    this.mLock.unlockFromRead(scope);
                }
            }
            boolean isForUpdate = scope.isForUpdate();
            txn.lockForUpgrade(this.mLock, isForUpdate);
            try {
                long l = this.mMap.size();
                return l;
            }
            finally {
                txn.unlockFromUpgrade(this.mLock, isForUpdate);
            }
        }
        catch (FetchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FetchException(e);
        }
    }

    @Override
    public Cursor<S> fetchAll() throws FetchException {
        try {
            return new MapCursor(this, this.mRepo.localTransactionScope(), this.mMap.values());
        }
        catch (FetchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FetchException(e);
        }
    }

    @Override
    public Cursor<S> fetchAll(Query.Controller controller) throws FetchException {
        return ControllerCursor.apply(this.fetchAll(), controller);
    }

    @Override
    public Cursor<S> fetchOne(StorableIndex<S> index, Object[] identityValues) throws FetchException {
        return this.fetchOne(index, identityValues, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cursor<S> fetchOne(StorableIndex<S> index, Object[] identityValues, Query.Controller controller) throws FetchException {
        try {
            S key = this.prepare();
            for (int i = 0; i < identityValues.length; ++i) {
                key.setPropertyValue(index.getProperty(i).getName(), identityValues[i]);
            }
            TransactionScope<MapTransaction> scope = this.mRepo.localTransactionScope();
            MapTransaction txn = scope.getTxn();
            if (txn == null) {
                this.doLockForRead(scope);
                try {
                    Storable value = (Storable)this.mMap.get(new Key<S>(key, this.mFullComparator));
                    if (value == null) {
                        Cursor cursor = EmptyCursor.the();
                        return cursor;
                    }
                    SingletonCursor<Storable> singletonCursor = new SingletonCursor<Storable>(this.copyAndFireLoadTrigger(value));
                    return singletonCursor;
                }
                finally {
                    this.mLock.unlockFromRead(scope);
                }
            }
            boolean isForUpdate = scope.isForUpdate();
            txn.lockForUpgrade(this.mLock, isForUpdate);
            try {
                Storable value = (Storable)this.mMap.get(new Key<S>(key, this.mFullComparator));
                if (value == null) {
                    Cursor cursor = EmptyCursor.the();
                    return cursor;
                }
                SingletonCursor<Storable> singletonCursor = new SingletonCursor<Storable>(this.copyAndFireLoadTrigger(value));
                return singletonCursor;
            }
            finally {
                txn.unlockFromUpgrade(this.mLock, isForUpdate);
            }
        }
        catch (FetchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FetchException(e);
        }
    }

    S copyAndFireLoadTrigger(S storable) throws FetchException {
        storable = storable.copy();
        Trigger<S> trigger = this.getLoadTrigger();
        if (trigger != null) {
            trigger.afterLoad(storable);
            storable.markAllPropertiesClean();
        }
        return storable;
    }

    @Override
    public Query<?> indexEntryQuery(StorableIndex<S> index) {
        return null;
    }

    @Override
    public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> index, Query<?> indexEntryQuery) {
        return null;
    }

    @Override
    public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> index, Query<?> indexEntryQuery, Query.Controller controller) {
        return null;
    }

    @Override
    public Cursor<S> fetchSubset(StorableIndex<S> index, Object[] identityValues, BoundaryType rangeStartBoundary, Object rangeStartValue, BoundaryType rangeEndBoundary, Object rangeEndValue, boolean reverseRange, boolean reverseOrder) throws FetchException {
        FilterValues filterValues;
        Filter filter;
        Cursor<Object> cursor;
        NavigableMap<Key<Object>, Object> map;
        block21: {
            Key<S> startKey;
            if (identityValues == null) {
                identityValues = NO_VALUES;
            }
            map = this.mMap;
            int tieBreaker = 1;
            if (reverseOrder) {
                map = map.descendingMap();
                reverseRange = !reverseRange;
                tieBreaker = -tieBreaker;
            }
            if (reverseRange) {
                BoundaryType t1 = rangeStartBoundary;
                rangeStartBoundary = rangeEndBoundary;
                rangeEndBoundary = t1;
                Object t2 = rangeStartValue;
                rangeStartValue = rangeEndValue;
                rangeEndValue = t2;
            }
            switch (rangeStartBoundary) {
                default: {
                    if (identityValues.length != 0) {
                        startKey = this.searchKey(-tieBreaker, identityValues);
                        break;
                    }
                    break block21;
                }
                case INCLUSIVE: {
                    startKey = this.searchKey(-tieBreaker, identityValues, rangeStartValue);
                    break;
                }
                case EXCLUSIVE: {
                    startKey = this.searchKey(tieBreaker, identityValues, rangeStartValue);
                }
            }
            Key<S> ceilingKey = map.ceilingKey(startKey);
            if (ceilingKey == null) {
                return EmptyCursor.the();
            }
            map = map.tailMap(ceilingKey, true);
        }
        try {
            cursor = new MapCursor(this, this.mRepo.localTransactionScope(), map.values());
        }
        catch (FetchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FetchException(e);
        }
        if (rangeEndBoundary == BoundaryType.OPEN) {
            if (identityValues.length == 0) {
                filter = null;
                filterValues = null;
            } else {
                int i;
                filter = Filter.getOpenFilter(this.getStorableType());
                for (i = 0; i < identityValues.length; ++i) {
                    filter = filter.and(index.getProperty(i).getName(), RelOp.EQ);
                }
                filterValues = filter.initialFilterValues();
                for (i = 0; i < identityValues.length; ++i) {
                    filterValues = filterValues.with(identityValues[i]);
                }
            }
        } else {
            int i;
            filter = Filter.getOpenFilter(this.getStorableType());
            for (i = 0; i < identityValues.length; ++i) {
                filter = filter.and(index.getProperty(i).getName(), RelOp.EQ);
            }
            RelOp rangeOp = reverseRange ? (rangeEndBoundary == BoundaryType.INCLUSIVE ? RelOp.GE : RelOp.GT) : (rangeEndBoundary == BoundaryType.INCLUSIVE ? RelOp.LE : RelOp.LT);
            filter = filter.and(index.getProperty(i).getName(), rangeOp);
            filterValues = filter.initialFilterValues();
            for (i = 0; i < identityValues.length; ++i) {
                filterValues = filterValues.with(identityValues[i]);
            }
            filterValues = filterValues.with(rangeEndValue);
        }
        if (filter != null) {
            cursor = FilteredCursor.applyFilter(filter, filterValues, cursor);
        }
        return cursor;
    }

    @Override
    public Cursor<S> fetchSubset(StorableIndex<S> index, Object[] identityValues, BoundaryType rangeStartBoundary, Object rangeStartValue, BoundaryType rangeEndBoundary, Object rangeEndValue, boolean reverseRange, boolean reverseOrder, Query.Controller controller) throws FetchException {
        return ControllerCursor.apply(this.fetchSubset(index, identityValues, rangeStartBoundary, rangeStartValue, rangeEndBoundary, rangeEndValue, reverseRange, reverseOrder), controller);
    }

    private List<OrderedProperty<S>> createPkPropList() {
        return new ArrayList<OrderedProperty<S>>(this.mInfo.getPrimaryKey().getProperties());
    }

    private Key<S> searchKey(int tieBreaker, Object[] identityValues) {
        S storable = this.prepare();
        this.mKeyAssigner.setKeyValues(storable, identityValues);
        Comparator<S> c = this.getSearchComparator(identityValues.length);
        return new SearchKey<S>(tieBreaker, storable, c);
    }

    private Key<S> searchKey(int tieBreaker, Object[] identityValues, Object rangeValue) {
        S storable = this.prepare();
        this.mKeyAssigner.setKeyValues(storable, identityValues, rangeValue);
        Comparator<S> c = this.getSearchComparator(identityValues.length + 1);
        return new SearchKey<S>(tieBreaker, storable, c);
    }

    private Comparator<S> getSearchComparator(int propertyCount) {
        Comparator<S> comparator = this.mSearchComparators[propertyCount];
        if (comparator == null) {
            List<OrderedProperty<S>> propList = this.createPkPropList().subList(0, propertyCount);
            comparator = propList.size() > 0 ? SortedCursor.createComparator(propList) : SortedCursor.createComparator(this.getStorableType(), new String[0]);
            this.mSearchComparators[propertyCount] = comparator;
        }
        return comparator;
    }

    @Override
    public SortBuffer<S> createSortBuffer() {
        return new ArraySortBuffer();
    }

    @Override
    public SortBuffer<S> createSortBuffer(Query.Controller controller) {
        return new ArraySortBuffer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchKey<S extends Storable>
    extends Key<S> {
        private final int mTieBreaker;

        SearchKey(int tieBreaker, S storable, Comparator<S> comparator) {
            super(storable, comparator);
            this.mTieBreaker = tieBreaker;
        }

        @Override
        protected int tieBreaker() {
            return this.mTieBreaker;
        }

        @Override
        public String toString() {
            return super.toString() + ", tieBreaker=" + this.mTieBreaker;
        }
    }

    public static interface InstanceFactory {
        public Storable instantiate(DelegateSupport var1);
    }
}

