/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.TriggerFactory;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.capability.IndexInfoCapability;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.repo.map.MapRepositoryBuilder;
import com.amazon.carbonado.repo.map.MapStorage;
import com.amazon.carbonado.repo.map.MapTransaction;
import com.amazon.carbonado.repo.map.MapTransactionManager;
import com.amazon.carbonado.sequence.SequenceValueGenerator;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.AbstractRepository;
import com.amazon.carbonado.spi.LobEngine;
import com.amazon.carbonado.txn.TransactionManager;
import com.amazon.carbonado.txn.TransactionScope;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapRepository
extends AbstractRepository<MapTransaction>
implements RepositoryAccess,
IndexInfoCapability {
    private final AtomicReference<Repository> mRootRef;
    private final boolean mIsMaster;
    private final int mLockTimeout;
    private final TimeUnit mLockTimeoutUnit;
    final Iterable<TriggerFactory> mTriggerFactories;
    private final MapTransactionManager mTxnManager;
    private LobEngine mLobEngine;

    MapRepository(AtomicReference<Repository> rootRef, MapRepositoryBuilder builder) {
        super(builder.getName());
        this.mRootRef = rootRef;
        this.mIsMaster = builder.isMaster();
        this.mLockTimeout = builder.getLockTimeout();
        this.mLockTimeoutUnit = builder.getLockTimeoutUnit();
        this.mTriggerFactories = builder.getTriggerFactories();
        this.mTxnManager = new MapTransactionManager(this.mLockTimeout, this.mLockTimeoutUnit);
    }

    @Override
    public Repository getRootRepository() {
        return this.mRootRef.get();
    }

    @Override
    public <S extends Storable> StorageAccess<S> storageAccessFor(Class<S> type) throws RepositoryException {
        return (StorageAccess)((Object)this.storageFor(type));
    }

    @Override
    public <S extends Storable> IndexInfo[] getIndexInfo(Class<S> storableType) throws RepositoryException {
        return ((MapStorage)this.storageFor(storableType)).getIndexInfo();
    }

    protected void finalize() {
        this.close();
    }

    @Override
    protected Log getLog() {
        return null;
    }

    @Override
    protected TransactionManager<MapTransaction> transactionManager() {
        return this.mTxnManager;
    }

    @Override
    protected TransactionScope<MapTransaction> localTransactionScope() {
        return this.mTxnManager.localScope();
    }

    @Override
    protected <S extends Storable> Storage<S> createStorage(Class<S> type) throws RepositoryException {
        return new MapStorage<S>(this, type, this.mLockTimeout, this.mLockTimeoutUnit);
    }

    @Override
    protected SequenceValueProducer createSequenceValueProducer(String name) throws RepositoryException {
        return new SequenceValueGenerator(this, name);
    }

    LobEngine getLobEngine() throws RepositoryException {
        if (this.mLobEngine == null) {
            this.mLobEngine = new LobEngine((Repository)this, this.getRootRepository());
        }
        return this.mLobEngine;
    }

    boolean isMaster() {
        return this.mIsMaster;
    }
}

