/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ClosedFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.JoinNode;
import com.amazon.carbonado.repo.jdbc.JoinNodeBuilder;
import com.amazon.carbonado.repo.jdbc.NullablePropertyStatement;
import com.amazon.carbonado.repo.jdbc.SQLStatementBuilder;
import com.amazon.carbonado.repo.jdbc.TableAliasGenerator;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WhereBuilder<S extends Storable>
extends Visitor<S, FetchException, Object> {
    private final SQLStatementBuilder mStatementBuilder;
    private final JoinNode mJoinNode;
    private final TableAliasGenerator mAliasGenerator;
    private List<PropertyFilter<S>> mPropertyFilters;
    private List<Boolean> mPropertyFilterNullable;

    WhereBuilder(SQLStatementBuilder statementBuilder, JoinNode jn, TableAliasGenerator aliasGenerator) {
        this.mStatementBuilder = statementBuilder;
        this.mJoinNode = jn;
        this.mAliasGenerator = aliasGenerator;
        this.mPropertyFilters = new ArrayList<PropertyFilter<S>>();
        this.mPropertyFilterNullable = new ArrayList<Boolean>();
    }

    public void append(Filter<S> filter) throws FetchException {
        this.mStatementBuilder.append(" WHERE ");
        FetchException e = (FetchException)filter.accept(this, null);
        if (e != null) {
            throw e;
        }
    }

    public void appendExists(Filter<S> filter) throws FetchException {
        JoinNode jn;
        JDBCStorableInfo<S> info;
        this.mStatementBuilder.append(" WHERE ");
        this.mStatementBuilder.append("EXISTS (SELECT * FROM");
        JDBCRepository repo = this.mStatementBuilder.getRepository();
        try {
            info = repo.examineStorable(filter.getStorableType());
        }
        catch (RepositoryException e) {
            throw repo.toFetchException(e);
        }
        try {
            JoinNodeBuilder<S> jnb = new JoinNodeBuilder<S>(repo, info, this.mAliasGenerator);
            filter.accept(jnb, null);
            jn = jnb.getRootJoinNode();
        }
        catch (UndeclaredThrowableException e) {
            throw repo.toFetchException(e);
        }
        jn.appendFullJoinTo(this.mStatementBuilder);
        this.mStatementBuilder.append(" WHERE ");
        int i = 0;
        for (JDBCStorableProperty<S> property : info.getPrimaryKeyProperties().values()) {
            if (i > 0) {
                this.mStatementBuilder.append(" AND ");
            }
            this.mStatementBuilder.append(this.mJoinNode.getAlias());
            this.mStatementBuilder.append('.');
            this.mStatementBuilder.append(property.getColumnName());
            this.mStatementBuilder.append('=');
            this.mStatementBuilder.append(jn.getAlias());
            this.mStatementBuilder.append('.');
            this.mStatementBuilder.append(property.getColumnName());
            ++i;
        }
        this.mStatementBuilder.append(" AND (");
        WhereBuilder<S> wb = new WhereBuilder<S>(this.mStatementBuilder, jn, this.mAliasGenerator);
        FetchException e = (FetchException)filter.accept(wb, null);
        if (e != null) {
            throw e;
        }
        this.mPropertyFilters.addAll(wb.mPropertyFilters);
        this.mPropertyFilterNullable.addAll(wb.mPropertyFilterNullable);
        this.mStatementBuilder.append(')');
        this.mStatementBuilder.append(')');
    }

    public PropertyFilter<S>[] getPropertyFilters() {
        return this.mPropertyFilters.toArray(new PropertyFilter[this.mPropertyFilters.size()]);
    }

    public boolean[] getPropertyFilterNullable() {
        boolean[] array = new boolean[this.mPropertyFilterNullable.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.mPropertyFilterNullable.get(i);
        }
        return array;
    }

    @Override
    public FetchException visit(OrFilter<S> filter, Object param) {
        this.mStatementBuilder.append('(');
        FetchException e = (FetchException)filter.getLeftFilter().accept(this, null);
        if (e != null) {
            return e;
        }
        this.mStatementBuilder.append(" OR ");
        e = (FetchException)filter.getRightFilter().accept(this, null);
        if (e != null) {
            return e;
        }
        this.mStatementBuilder.append(')');
        return null;
    }

    @Override
    public FetchException visit(AndFilter<S> filter, Object param) {
        this.mStatementBuilder.append('(');
        FetchException e = (FetchException)filter.getLeftFilter().accept(this, null);
        if (e != null) {
            return e;
        }
        this.mStatementBuilder.append(" AND ");
        e = (FetchException)filter.getRightFilter().accept(this, null);
        if (e != null) {
            return e;
        }
        this.mStatementBuilder.append(')');
        return null;
    }

    @Override
    public FetchException visit(PropertyFilter<S> filter, Object param) {
        try {
            this.mStatementBuilder.appendColumn(this.mJoinNode, filter.getChainedProperty());
        }
        catch (FetchException e) {
            return e;
        }
        if (!filter.isConstant()) {
            this.addBindParameter(filter);
        } else {
            RelOp op = filter.getOperator();
            Object constant = filter.constant();
            if (constant == null) {
                if (op == RelOp.EQ) {
                    this.mStatementBuilder.append("IS NULL");
                } else if (op == RelOp.NE) {
                    this.mStatementBuilder.append("IS NOT NULL");
                } else {
                    this.mStatementBuilder.append(this.sqlOperatorFor(op));
                    this.mStatementBuilder.append("NULL");
                }
            } else if (filter.getType() == String.class) {
                this.mStatementBuilder.append(this.sqlOperatorFor(op));
                this.mStatementBuilder.append('\'');
                this.mStatementBuilder.append(String.valueOf(constant).replace("'", "''"));
                this.mStatementBuilder.append('\'');
            } else if (Number.class.isAssignableFrom(filter.getBoxedType())) {
                this.mStatementBuilder.append(this.sqlOperatorFor(op));
                this.mStatementBuilder.append(String.valueOf(constant));
            } else {
                this.addBindParameter(filter);
            }
        }
        return null;
    }

    @Override
    public FetchException visit(ExistsFilter<S> filter, Object param) {
        JoinNode oneToManyNode;
        JDBCStorableProperty<?> oneToMany;
        JDBCStorableInfo<Storable> oneToManyInfo;
        if (filter.isNotExists()) {
            this.mStatementBuilder.append("NOT ");
        }
        this.mStatementBuilder.append("EXISTS (SELECT * FROM");
        ChainedProperty<S> chained = filter.getChainedProperty();
        JDBCRepository repo = this.mStatementBuilder.getRepository();
        try {
            StorableProperty<?> lastProp = chained.getLastProperty();
            oneToManyInfo = repo.examineStorable(lastProp.getJoinedType());
            oneToMany = repo.getJDBCStorableProperty(lastProp);
        }
        catch (RepositoryException e) {
            return repo.toFetchException(e);
        }
        Filter<?> subFilter = filter.getSubFilter();
        try {
            JoinNodeBuilder<Storable> jnb = new JoinNodeBuilder<Storable>(repo, oneToManyInfo, this.mAliasGenerator);
            if (subFilter != null) {
                subFilter.accept(jnb, null);
            }
            oneToManyNode = jnb.getRootJoinNode();
        }
        catch (UndeclaredThrowableException e) {
            return repo.toFetchException(e);
        }
        oneToManyNode.appendFullJoinTo(this.mStatementBuilder);
        this.mStatementBuilder.append(" WHERE ");
        String alias = this.mJoinNode.findAliasFor(chained);
        int count = oneToMany.getJoinElementCount();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.mStatementBuilder.append(" AND ");
            }
            this.mStatementBuilder.append(alias);
            this.mStatementBuilder.append('.');
            this.mStatementBuilder.append(oneToMany.getInternalJoinElement(i).getColumnName());
            this.mStatementBuilder.append('=');
            this.mStatementBuilder.append(oneToManyNode.getAlias());
            this.mStatementBuilder.append('.');
            this.mStatementBuilder.append(oneToMany.getExternalJoinElement(i).getColumnName());
        }
        if (subFilter != null && !subFilter.isOpen()) {
            this.mStatementBuilder.append(" AND (");
            WhereBuilder<S> wb = new WhereBuilder<S>(this.mStatementBuilder, oneToManyNode, this.mAliasGenerator);
            FetchException e = (FetchException)subFilter.accept(wb, null);
            if (e != null) {
                return e;
            }
            this.mStatementBuilder.append(')');
            int size = wb.mPropertyFilters.size();
            for (int i = 0; i < size; ++i) {
                PropertyFilter<S> propFilter = wb.mPropertyFilters.get(i);
                this.mPropertyFilters.add((PropertyFilter<S>)propFilter.asJoinedFromAny(chained));
            }
            this.mPropertyFilterNullable.addAll(wb.mPropertyFilterNullable);
        }
        this.mStatementBuilder.append(')');
        return null;
    }

    @Override
    public FetchException visit(ClosedFilter<S> filter, Object param) {
        this.mStatementBuilder.append("1=0");
        return null;
    }

    private void addBindParameter(PropertyFilter<S> filter) {
        RelOp op = filter.getOperator();
        StorableProperty<?> property = filter.getChainedProperty().getLastProperty();
        this.mPropertyFilters.add(filter);
        if (property.isNullable() && (op == RelOp.EQ || op == RelOp.NE)) {
            this.mPropertyFilterNullable.add(true);
            this.mStatementBuilder.append(new NullablePropertyStatement<S>(filter, op == RelOp.EQ));
        } else {
            this.mPropertyFilterNullable.add(false);
            this.mStatementBuilder.append(this.sqlOperatorFor(op));
            this.mStatementBuilder.append('?');
        }
    }

    private String sqlOperatorFor(RelOp op) {
        if (op == RelOp.NE) {
            return "<>";
        }
        return op.toString();
    }
}

