/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.repo.jdbc.CompositeStatement;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.JoinNode;
import com.amazon.carbonado.repo.jdbc.LiteralStatement;
import com.amazon.carbonado.repo.jdbc.SQLStatement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLStatementBuilder<S extends Storable> {
    private final JDBCRepository mRepository;
    private List<SQLStatement<S>> mStatements;
    private StringBuilder mLiteralBuilder;

    SQLStatementBuilder(JDBCRepository repository) {
        this.mRepository = repository;
        this.mStatements = new ArrayList<SQLStatement<S>>();
        this.mLiteralBuilder = new StringBuilder();
    }

    public SQLStatement<S> build() {
        if (this.mStatements.size() == 0 || this.mLiteralBuilder.length() > 0) {
            this.mStatements.add(new LiteralStatement(this.mLiteralBuilder.toString()));
            this.mLiteralBuilder.setLength(0);
        }
        if (this.mStatements.size() == 1) {
            return this.mStatements.get(0);
        }
        return new CompositeStatement<S>(this.mStatements);
    }

    public void append(char c) {
        this.mLiteralBuilder.append(c);
    }

    public void append(String str) {
        this.mLiteralBuilder.append(str);
    }

    public void append(LiteralStatement<S> statement) {
        this.append(statement.toString());
    }

    public void append(SQLStatement<S> statement) {
        if (statement instanceof LiteralStatement) {
            this.append((LiteralStatement)statement);
        } else {
            this.mStatements.add(new LiteralStatement(this.mLiteralBuilder.toString()));
            this.mLiteralBuilder.setLength(0);
            this.mStatements.add(statement);
        }
    }

    public void appendColumn(JoinNode jn, ChainedProperty<?> chained) throws FetchException {
        JDBCStorableProperty<?> jProperty;
        String alias = jn == null ? null : jn.findAliasFor(chained);
        if (alias != null) {
            this.mLiteralBuilder.append(alias);
            this.mLiteralBuilder.append('.');
        }
        StorableProperty<?> property = chained.getLastProperty();
        try {
            jProperty = this.mRepository.getJDBCStorableProperty(property);
        }
        catch (RepositoryException e) {
            throw this.mRepository.toFetchException(e);
        }
        if (jProperty.isJoin()) {
            throw new UnsupportedOperationException("Join property doesn't have a corresponding column: " + chained);
        }
        this.mLiteralBuilder.append(jProperty.getColumnName());
    }

    JDBCRepository getRepository() {
        return this.mRepository;
    }
}

