/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.repo.jdbc.JDBCLob;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;

class JDBCTransaction {
    private static final int LEVEL_NOT_CHANGED = -1;
    private final boolean mIsNested;
    private final Connection mConnection;
    private final int mOriginalLevel;
    private boolean mReady = true;
    private Savepoint mSavepoint;
    private List<JDBCLob> mRegisteredLobs;

    JDBCTransaction(Connection con) {
        this.mIsNested = false;
        this.mConnection = con;
        this.mOriginalLevel = -1;
    }

    JDBCTransaction(JDBCTransaction parent, IsolationLevel level) throws SQLException {
        this.mIsNested = true;
        this.mConnection = parent.mConnection;
        if (level == null) {
            this.mOriginalLevel = -1;
        } else {
            int originalLevel;
            int newLevel = JDBCRepository.mapIsolationLevelToJdbc(level);
            if (newLevel == (originalLevel = this.mConnection.getTransactionIsolation())) {
                this.mOriginalLevel = -1;
            } else {
                this.mOriginalLevel = originalLevel;
                if (originalLevel == 0) {
                    this.mConnection.setAutoCommit(false);
                }
                this.mConnection.setTransactionIsolation(newLevel);
            }
        }
        this.mSavepoint = this.mConnection.setSavepoint();
    }

    Connection getConnection() {
        return this.mConnection;
    }

    void reuse() throws SQLException {
        if (this.mIsNested && this.mSavepoint == null) {
            this.mSavepoint = this.mConnection.setSavepoint();
        }
        this.mReady = true;
    }

    void commit() throws SQLException {
        if (this.mIsNested) {
            this.mSavepoint = null;
        } else {
            this.mConnection.commit();
        }
        this.mReady = false;
    }

    Connection abort() throws SQLException {
        if (this.mRegisteredLobs != null) {
            for (JDBCLob lob : this.mRegisteredLobs) {
                lob.close();
            }
            this.mRegisteredLobs = null;
        }
        if (this.mIsNested) {
            if (this.mReady) {
                if (this.mSavepoint != null) {
                    this.mConnection.rollback(this.mSavepoint);
                    this.mSavepoint = null;
                }
                this.mReady = false;
            }
            if (this.mOriginalLevel != -1) {
                if (this.mOriginalLevel == 0) {
                    this.mConnection.setAutoCommit(true);
                } else {
                    this.mConnection.setTransactionIsolation(this.mOriginalLevel);
                }
            }
            return null;
        }
        if (this.mReady) {
            this.mConnection.rollback();
            this.mReady = false;
        }
        return this.mConnection;
    }

    void register(JDBCLob lob) {
        if (this.mRegisteredLobs == null) {
            this.mRegisteredLobs = new ArrayList<JDBCLob>(4);
        }
        this.mRegisteredLobs.add(lob);
    }
}

